/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation;

import com.google.monitoring.runtime.instrumentation.AllocationInstrumenter;
import com.google.monitoring.runtime.instrumentation.asm.Label;
import com.google.monitoring.runtime.instrumentation.asm.MethodVisitor;
import com.google.monitoring.runtime.instrumentation.asm.Type;
import com.google.monitoring.runtime.instrumentation.asm.commons.LocalVariablesSorter;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AllocationMethodAdapter
extends MethodVisitor {
    public static final String RECORDER_SIGNATURE = "(ILjava/lang/String;Ljava/lang/Object;)V";
    public static final String CLASS_RECORDER_SIG = "(Ljava/lang/Class;Ljava/lang/Object;)V";
    private static final String[] primitiveTypeNames = new String[]{"INVALID0", "INVALID1", "INVALID2", "INVALID3", "boolean", "char", "float", "double", "byte", "short", "int", "long"};
    private int outstandingAllocs = 0;
    private List<VariableScope> localScopes = null;
    private final String recorderClass;
    private final String recorderMethod;
    public LocalVariablesSorter lvs = null;
    private static final Pattern namePattern = Pattern.compile("^\\[*L([^;]+);$");

    private List<VariableScope> getLocalScopes() {
        if (this.localScopes == null) {
            this.localScopes = new LinkedList<VariableScope>();
        }
        return this.localScopes;
    }

    public AllocationMethodAdapter(MethodVisitor mv, String recorderClass, String recorderMethod) {
        super(327680, mv);
        this.recorderClass = recorderClass;
        this.recorderMethod = recorderMethod;
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (opcode == 188) {
            if (operand >= 4 && operand <= 11) {
                super.visitInsn(89);
                super.visitIntInsn(opcode, operand);
                this.invokeRecordAllocation(primitiveTypeNames[operand]);
            } else {
                int n = operand;
                AllocationInstrumenter.logger.severe(new StringBuilder(88).append("NEWARRAY called with an invalid operand ").append(n).append(".  Not instrumenting this allocation!").toString());
                super.visitIntInsn(opcode, operand);
            }
        } else {
            super.visitIntInsn(opcode, operand);
        }
    }

    private void pushClassNameOnStack() {
        super.visitInsn(89);
        super.visitMethodInsn(182, "java/lang/Class", "getName", "()Ljava/lang/String;", false);
        super.visitLdcInsn(Character.valueOf('.'));
        super.visitLdcInsn(Character.valueOf('/'));
        super.visitMethodInsn(182, "java/lang/String", "replace", "(CC)Ljava/lang/String;", false);
    }

    private void pushProductOfIntArrayOnStack() {
        Label beginScopeLabel = new Label();
        Label endScopeLabel = new Label();
        int dimsArrayIndex = this.newLocal("[I", beginScopeLabel, endScopeLabel);
        int counterIndex = this.newLocal("I", beginScopeLabel, endScopeLabel);
        int productIndex = this.newLocal("I", beginScopeLabel, endScopeLabel);
        Label loopLabel = new Label();
        Label endLabel = new Label();
        super.visitLabel(beginScopeLabel);
        super.visitVarInsn(58, dimsArrayIndex);
        super.visitInsn(3);
        super.visitVarInsn(54, counterIndex);
        super.visitInsn(4);
        super.visitVarInsn(54, productIndex);
        super.visitLabel(loopLabel);
        super.visitVarInsn(21, counterIndex);
        super.visitVarInsn(25, dimsArrayIndex);
        super.visitInsn(190);
        super.visitJumpInsn(162, endLabel);
        super.visitVarInsn(25, dimsArrayIndex);
        super.visitVarInsn(21, counterIndex);
        super.visitInsn(46);
        super.visitInsn(89);
        Label nonZeroDimension = new Label();
        super.visitJumpInsn(154, nonZeroDimension);
        super.visitInsn(87);
        super.visitInsn(4);
        super.visitLabel(nonZeroDimension);
        super.visitVarInsn(21, productIndex);
        super.visitInsn(104);
        super.visitVarInsn(54, productIndex);
        super.visitIincInsn(counterIndex, 1);
        super.visitJumpInsn(167, loopLabel);
        super.visitLabel(endLabel);
        super.visitVarInsn(25, dimsArrayIndex);
        super.visitVarInsn(21, productIndex);
        super.visitLabel(endScopeLabel);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String signature, boolean itf) {
        if (opcode == 184 && owner.equals("java/lang/reflect/Array") && name.equals("newInstance")) {
            if (signature.equals("(Ljava/lang/Class;I)Ljava/lang/Object;")) {
                Label beginScopeLabel = new Label();
                Label endScopeLabel = new Label();
                super.visitLabel(beginScopeLabel);
                int countIndex = this.newLocal("I", beginScopeLabel, endScopeLabel);
                super.visitVarInsn(54, countIndex);
                this.pushClassNameOnStack();
                int typeNameIndex = this.newLocal("Ljava/lang/String;", beginScopeLabel, endScopeLabel);
                super.visitVarInsn(58, typeNameIndex);
                super.visitVarInsn(21, countIndex);
                super.visitMethodInsn(opcode, owner, name, signature, itf);
                super.visitInsn(89);
                super.visitVarInsn(21, countIndex);
                super.visitInsn(95);
                super.visitVarInsn(25, typeNameIndex);
                super.visitLabel(endScopeLabel);
                super.visitInsn(95);
                super.visitMethodInsn(184, this.recorderClass, this.recorderMethod, RECORDER_SIGNATURE, false);
                return;
            }
            if (signature.equals("(Ljava/lang/Class;[I)Ljava/lang/Object;")) {
                Label beginScopeLabel = new Label();
                Label endScopeLabel = new Label();
                super.visitLabel(beginScopeLabel);
                int dimsArrayIndex = this.newLocal("[I", beginScopeLabel, endScopeLabel);
                this.pushProductOfIntArrayOnStack();
                int productIndex = this.newLocal("I", beginScopeLabel, endScopeLabel);
                super.visitVarInsn(54, productIndex);
                super.visitVarInsn(58, dimsArrayIndex);
                this.pushClassNameOnStack();
                int typeNameIndex = this.newLocal("Ljava/lang/String;", beginScopeLabel, endScopeLabel);
                super.visitVarInsn(58, typeNameIndex);
                super.visitVarInsn(25, dimsArrayIndex);
                super.visitMethodInsn(opcode, owner, name, signature, itf);
                super.visitInsn(89);
                super.visitVarInsn(21, productIndex);
                super.visitInsn(95);
                super.visitVarInsn(25, typeNameIndex);
                super.visitLabel(endScopeLabel);
                super.visitInsn(95);
                super.visitMethodInsn(184, this.recorderClass, this.recorderMethod, RECORDER_SIGNATURE, false);
                return;
            }
        }
        if (opcode == 182) {
            if ("clone".equals(name) && owner.startsWith("[")) {
                int i;
                super.visitMethodInsn(opcode, owner, name, signature, itf);
                for (i = 0; i < owner.length() && owner.charAt(i) == '['; ++i) {
                }
                if (i > 1) {
                    super.visitTypeInsn(192, owner);
                    this.calculateArrayLengthAndDispatch(owner.substring(i), i);
                } else {
                    super.visitInsn(89);
                    super.visitTypeInsn(192, owner);
                    super.visitInsn(190);
                    super.visitInsn(95);
                    this.invokeRecordAllocation(owner.substring(i));
                }
                return;
            }
            if ("newInstance".equals(name)) {
                if ("java/lang/Class".equals(owner) && "()Ljava/lang/Object;".equals(signature)) {
                    super.visitInsn(89);
                    super.visitMethodInsn(opcode, owner, name, signature, itf);
                    super.visitInsn(90);
                    super.visitMethodInsn(184, this.recorderClass, this.recorderMethod, CLASS_RECORDER_SIG, false);
                    return;
                }
                if ("java/lang/reflect/Constructor".equals(owner) && "([Ljava/lang/Object;)Ljava/lang/Object;".equals(signature)) {
                    this.buildRecorderFromObject(opcode, owner, name, signature, itf);
                    return;
                }
            }
        }
        if (opcode == 183) {
            if ("clone".equals(name) && "java/lang/Object".equals(owner)) {
                this.buildRecorderFromObject(opcode, owner, name, signature, itf);
                return;
            }
            if ("<init>".equals(name) && this.outstandingAllocs > 0) {
                --this.outstandingAllocs;
                this.dupStackElementBeforeSignatureArgs(signature);
                super.visitMethodInsn(opcode, owner, name, signature, itf);
                super.visitLdcInsn(-1);
                super.visitInsn(95);
                this.invokeRecordAllocation(owner);
                super.visitInsn(87);
                return;
            }
        }
        super.visitMethodInsn(opcode, owner, name, signature, itf);
    }

    private void buildRecorderFromObject(int opcode, String owner, String name, String signature, boolean itf) {
        super.visitMethodInsn(opcode, owner, name, signature, itf);
        super.visitInsn(89);
        super.visitInsn(89);
        super.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        super.visitInsn(95);
        super.visitMethodInsn(184, this.recorderClass, this.recorderMethod, CLASS_RECORDER_SIG, false);
    }

    private void dupStackElementBeforeSignatureArgs(String sig) {
        int i;
        Label beginScopeLabel = new Label();
        Label endScopeLabel = new Label();
        super.visitLabel(beginScopeLabel);
        Type[] argTypes = Type.getArgumentTypes(sig);
        int[] args = new int[argTypes.length];
        for (i = argTypes.length - 1; i >= 0; --i) {
            args[i] = this.newLocal(argTypes[i], beginScopeLabel, endScopeLabel);
            super.visitVarInsn(argTypes[i].getOpcode(54), args[i]);
        }
        super.visitInsn(89);
        for (i = 0; i < argTypes.length; ++i) {
            int op = argTypes[i].getOpcode(21);
            super.visitVarInsn(op, args[i]);
            if (op != 25) continue;
            super.visitInsn(1);
            super.visitVarInsn(58, args[i]);
        }
        super.visitLabel(endScopeLabel);
    }

    @Override
    public void visitTypeInsn(int opcode, String typeName) {
        if (opcode == 187) {
            super.visitTypeInsn(opcode, typeName);
            ++this.outstandingAllocs;
        } else if (opcode == 189) {
            super.visitInsn(89);
            super.visitTypeInsn(opcode, typeName);
            this.invokeRecordAllocation(typeName);
        } else {
            super.visitTypeInsn(opcode, typeName);
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.localScopes != null) {
            for (VariableScope scope : this.localScopes) {
                int n = scope.index;
                super.visitLocalVariable(new StringBuilder(17).append("xxxxx$").append(n).toString(), scope.desc, null, scope.start, scope.end, scope.index);
            }
        }
        super.visitMaxs(maxStack, maxLocals);
    }

    private int newLocal(Type type, String typeDesc, Label begin, Label end) {
        int newVar = this.lvs.newLocal(type);
        this.getLocalScopes().add(new VariableScope(newVar, begin, end, typeDesc));
        return newVar;
    }

    private int newLocal(String typeDescriptor, Label begin, Label end) {
        return this.newLocal(Type.getType(typeDescriptor), typeDescriptor, begin, end);
    }

    private int newLocal(Type type, Label begin, Label end) {
        return this.newLocal(type, type.getDescriptor(), begin, end);
    }

    private void invokeRecordAllocation(String typeName) {
        Matcher matcher = namePattern.matcher(typeName);
        if (matcher.find()) {
            typeName = matcher.group(1);
        }
        super.visitInsn(90);
        super.visitLdcInsn(typeName);
        super.visitInsn(95);
        super.visitMethodInsn(184, this.recorderClass, this.recorderMethod, RECORDER_SIGNATURE, false);
    }

    @Override
    public void visitMultiANewArrayInsn(String typeName, int dimCount) {
        super.visitMultiANewArrayInsn(typeName, dimCount);
        this.calculateArrayLengthAndDispatch(typeName, dimCount);
    }

    void calculateArrayLengthAndDispatch(String typeName, int dimCount) {
        Label zeroDimension = new Label();
        super.visitInsn(89);
        super.visitLdcInsn(1);
        for (int i = 0; i < dimCount; ++i) {
            super.visitInsn(95);
            super.visitInsn(90);
            super.visitInsn(190);
            Label nonZeroDimension = new Label();
            super.visitInsn(89);
            super.visitJumpInsn(154, nonZeroDimension);
            super.visitInsn(87);
            super.visitJumpInsn(167, zeroDimension);
            super.visitLabel(nonZeroDimension);
            super.visitInsn(104);
            if (i >= dimCount - 1) continue;
            super.visitInsn(95);
            super.visitInsn(3);
            super.visitInsn(50);
            super.visitInsn(95);
        }
        super.visitLabel(zeroDimension);
        super.visitInsn(95);
        super.visitInsn(87);
        super.visitInsn(95);
        this.invokeRecordAllocation(typeName);
    }

    private static class VariableScope {
        public final int index;
        public final Label start;
        public final Label end;
        public final String desc;

        public VariableScope(int index, Label start, Label end, String desc) {
            this.index = index;
            this.start = start;
            this.end = end;
            this.desc = desc;
        }
    }
}

