/*
 * Decompiled with CFR 0.152.
 */
package japicmp.util;

import java.util.LinkedList;
import java.util.List;

public class MethodDescriptorParser {
    private final List<String> parameters = new LinkedList<String>();
    private String returnType = "void";

    public void parse(String methodDescriptor) {
        int parenthesisCloseIndex = methodDescriptor.indexOf(41);
        if (parenthesisCloseIndex > -1) {
            this.parseParameters(methodDescriptor, parenthesisCloseIndex);
            this.parseReturnValue(methodDescriptor, parenthesisCloseIndex);
        }
    }

    private void parseReturnValue(String signature, int parenthesisCloseIndex) {
        String retValPart = signature.substring(parenthesisCloseIndex + 1);
        List<String> retValTypes = this.parseTypes(retValPart);
        this.returnType = retValTypes.get(0);
    }

    private void parseParameters(String signature, int parenthesisCloseIndex) {
        String paramPart = signature.substring(1, parenthesisCloseIndex);
        List<String> paramTypes = this.parseTypes(paramPart);
        this.parameters.clear();
        this.parameters.addAll(paramTypes);
    }

    public List<String> parseTypes(String paramPart) {
        LinkedList<String> types = new LinkedList<String>();
        boolean arrayNotation = false;
        block13: for (int i = 0; i < paramPart.length(); ++i) {
            char c = paramPart.charAt(i);
            String type = "void";
            switch (c) {
                case 'Z': {
                    type = "boolean";
                    break;
                }
                case 'B': {
                    type = "byte";
                    break;
                }
                case 'C': {
                    type = "char";
                    break;
                }
                case 'S': {
                    type = "short";
                    break;
                }
                case 'I': {
                    type = "int";
                    break;
                }
                case 'J': {
                    type = "long";
                    break;
                }
                case 'F': {
                    type = "float";
                    break;
                }
                case 'D': {
                    type = "double";
                    break;
                }
                case 'V': {
                    type = "void";
                    break;
                }
                case '[': {
                    arrayNotation = true;
                    continue block13;
                }
                case 'L': {
                    StringBuilder fqn = new StringBuilder();
                    ++i;
                    while (i < paramPart.length() && (c = paramPart.charAt(i)) != ';') {
                        if (c == '/') {
                            fqn.append('.');
                        } else {
                            fqn.append(c);
                        }
                        ++i;
                    }
                    type = fqn.toString();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type signature: '" + c + "'");
                }
            }
            if (arrayNotation) {
                type = type + "[]";
                arrayNotation = false;
            }
            types.add(type);
        }
        return types;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getMethodSignature(String methodName) {
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        for (String parameter : this.parameters) {
            if (counter > 0) {
                sb.append(",");
            }
            sb.append(parameter);
            ++counter;
        }
        return methodName + "(" + sb.toString() + ")";
    }
}

