/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output.extapi.jpa.model;

import japicmp.model.JApiAnnotation;
import japicmp.model.JApiAnnotationElement;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiField;
import japicmp.model.JApiMethod;
import japicmp.output.extapi.jpa.model.JpaAttribute;
import japicmp.output.extapi.jpa.model.JpaName;
import japicmp.util.Optional;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class JpaTable {
    private final List<JpaAttribute> attributes = new LinkedList<JpaAttribute>();
    private final JApiClass jApiClass;
    private final JpaName jpaName;
    private final JApiChangeStatus changeStatus;

    public JpaTable(JApiClass jApiClass, JApiAnnotation entityAnnotation) {
        this.jApiClass = jApiClass;
        this.jpaName = this.extractName(entityAnnotation, jApiClass);
        this.extractAttributes();
        this.changeStatus = this.computeChangeStatus();
    }

    private JpaName extractName(JApiAnnotation entityAnnotation, JApiClass jApiClass) {
        JApiAnnotationElement element;
        JApiChangeStatus changeStatusClass = jApiClass.getChangeStatus();
        String tableName = this.computeTablename();
        Iterator<JApiAnnotationElement> iterator = entityAnnotation.getElements().iterator();
        if (iterator.hasNext() && "name".equals((element = iterator.next()).getName())) {
            JApiChangeStatus elementChangeStatus = element.getChangeStatus();
            switch (elementChangeStatus) {
                case NEW: {
                    String newName = this.removeQuotationMarks(element.getNewValue().get().toString());
                    if (changeStatusClass == JApiChangeStatus.NEW) {
                        return new JpaName(Optional.absent(), Optional.of(newName), JApiChangeStatus.NEW);
                    }
                    if (tableName.equals(newName)) {
                        return new JpaName(Optional.of(newName), Optional.of(newName), JApiChangeStatus.UNCHANGED);
                    }
                    return new JpaName(Optional.of(tableName), Optional.of(newName), JApiChangeStatus.MODIFIED);
                }
                case REMOVED: {
                    String oldName = this.removeQuotationMarks(element.getOldValue().get().toString());
                    if (changeStatusClass == JApiChangeStatus.REMOVED) {
                        return new JpaName(Optional.of(oldName), Optional.absent(), JApiChangeStatus.REMOVED);
                    }
                    if (tableName.equals(oldName)) {
                        return new JpaName(Optional.of(oldName), Optional.of(oldName), JApiChangeStatus.UNCHANGED);
                    }
                    return new JpaName(Optional.of(oldName), Optional.of(tableName), JApiChangeStatus.MODIFIED);
                }
                case MODIFIED: {
                    String newName = this.removeQuotationMarks(element.getNewValue().get().toString());
                    String oldName = this.removeQuotationMarks(element.getOldValue().get().toString());
                    return new JpaName(Optional.of(oldName), Optional.of(newName), JApiChangeStatus.MODIFIED);
                }
                case UNCHANGED: {
                    String newName = this.removeQuotationMarks(element.getNewValue().get().toString());
                    return new JpaName(Optional.of(newName), Optional.of(newName), JApiChangeStatus.UNCHANGED);
                }
            }
        }
        if (changeStatusClass == JApiChangeStatus.NEW) {
            return new JpaName(Optional.absent(), Optional.of(tableName), JApiChangeStatus.NEW);
        }
        if (changeStatusClass == JApiChangeStatus.REMOVED) {
            return new JpaName(Optional.of(tableName), Optional.absent(), JApiChangeStatus.REMOVED);
        }
        return new JpaName(Optional.of(tableName), Optional.of(tableName), JApiChangeStatus.UNCHANGED);
    }

    private String removeQuotationMarks(String s) {
        return s.replace("\"", "");
    }

    private JApiChangeStatus computeChangeStatus() {
        JApiChangeStatus changeStatus = this.jApiClass.getChangeStatus();
        if (changeStatus == JApiChangeStatus.MODIFIED) {
            changeStatus = JApiChangeStatus.UNCHANGED;
        }
        if (this.jpaName.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
            changeStatus = JApiChangeStatus.MODIFIED;
        }
        return changeStatus;
    }

    private void extractAttributes() {
        List<JApiField> fields = this.jApiClass.getFields();
        for (JApiField field : fields) {
            JApiChangeStatus fieldChangeStatus;
            Optional<JApiAnnotation> transientAnnotationOfFieldOptional = this.getTransientAnnotationOfField(field);
            Optional<JApiAnnotation> transientAnnotationOfPropertyOptional = this.getTransientAnnotationOfProperty(field);
            if (transientAnnotationOfFieldOptional.isPresent() || transientAnnotationOfPropertyOptional.isPresent() || (fieldChangeStatus = field.getChangeStatus()) != JApiChangeStatus.NEW) continue;
            JpaAttribute jpaAttribute = new JpaAttribute(JApiChangeStatus.NEW);
        }
    }

    private Optional<JApiAnnotation> getTransientAnnotationOfField(JApiField field) {
        Optional<JApiAnnotation> returnValue = Optional.absent();
        for (JApiAnnotation annotation : field.getAnnotations()) {
            if (!"javax.persistence.Transient".equals(annotation.getFullyQualifiedName())) continue;
            returnValue = Optional.of(annotation);
            break;
        }
        return returnValue;
    }

    private Optional<JApiAnnotation> getTransientAnnotationOfProperty(JApiField field) {
        Optional<JApiAnnotation> returnValue = Optional.absent();
        Optional<JApiMethod> propertyMethodOptional = this.getPropertyMethod(field);
        if (propertyMethodOptional.isPresent()) {
            JApiMethod propertyMethod = propertyMethodOptional.get();
            for (JApiAnnotation annotation : propertyMethod.getAnnotations()) {
                if (!"javax.persistence.Transient".equals(annotation.getFullyQualifiedName())) continue;
                returnValue = Optional.of(annotation);
                break;
            }
        }
        return returnValue;
    }

    private Optional<JApiMethod> getPropertyMethod(JApiField field) {
        Optional<JApiMethod> propertyMethod = Optional.absent();
        String fieldName = field.getName();
        String getterName = "get" + (Character.isUpperCase(fieldName.charAt(0)) ? fieldName : (fieldName.length() > 1 ? Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1) : Character.valueOf(Character.toUpperCase(fieldName.charAt(0)))));
        for (JApiMethod method : this.jApiClass.getMethods()) {
            if (!getterName.equals(method.getName())) continue;
            propertyMethod = Optional.of(method);
            break;
        }
        if (!propertyMethod.isPresent()) {
            String isName = "is" + getterName.substring(3);
            for (JApiMethod method : this.jApiClass.getMethods()) {
                if (!isName.equals(method.getName())) continue;
                propertyMethod = Optional.of(method);
                break;
            }
        }
        return propertyMethod;
    }

    @XmlElementWrapper(name="attributes")
    @XmlElement(name="attribute")
    public List<JpaAttribute> getAttributes() {
        return this.attributes;
    }

    @XmlAttribute(name="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.jApiClass.getFullyQualifiedName();
    }

    public String computeTablename() {
        String className = this.toClassName(this.jApiClass.getFullyQualifiedName());
        return JpaTable.toJpaName(className);
    }

    static String toJpaName(String javaName) {
        boolean lastCharWasUpperCase = true;
        StringBuilder jpaName = new StringBuilder();
        for (int i = 0; i < javaName.length(); ++i) {
            char c = javaName.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!lastCharWasUpperCase) {
                    jpaName.append("_");
                }
                jpaName.append(c);
                lastCharWasUpperCase = true;
                continue;
            }
            jpaName.append(Character.toUpperCase(c));
            lastCharWasUpperCase = false;
        }
        return jpaName.toString();
    }

    private String toClassName(String className) {
        String[] parts = className.split("\\.");
        if (parts.length > 0) {
            className = parts[parts.length - 1];
        }
        return className;
    }

    @XmlAttribute(name="changeStatus")
    public String getChangeStatus() {
        return this.changeStatus.toString();
    }

    @XmlElement(name="name")
    public JpaName getJpaName() {
        return this.jpaName;
    }
}

