/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiHasChangeStatus;
import japicmp.util.Optional;
import java.util.ArrayList;
import java.util.List;
import javassist.CtClass;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

public class JApiImplementedInterface
implements JApiHasChangeStatus,
JApiCompatibility {
    private final CtClass ctClass;
    private final String fullyQualifiedName;
    private final JApiChangeStatus changeStatus;
    private final List<JApiCompatibilityChange> compatibilityChanges = new ArrayList<JApiCompatibilityChange>();
    private Optional<JApiClass> correspondingJApiClass = Optional.absent();

    public JApiImplementedInterface(CtClass ctClass, String fullyQualifiedName, JApiChangeStatus changeStatus) {
        this.ctClass = ctClass;
        this.fullyQualifiedName = fullyQualifiedName;
        this.changeStatus = changeStatus;
    }

    @XmlAttribute
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @XmlAttribute
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    @Override
    @XmlAttribute
    public boolean isBinaryCompatible() {
        boolean binaryCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isBinaryCompatible()) continue;
            binaryCompatible = false;
        }
        if (binaryCompatible && this.correspondingJApiClass.isPresent() && !this.correspondingJApiClass.get().isBinaryCompatible()) {
            binaryCompatible = false;
        }
        return binaryCompatible;
    }

    @Override
    @XmlAttribute
    public boolean isSourceCompatible() {
        boolean sourceCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isSourceCompatible()) continue;
            sourceCompatible = false;
        }
        if (sourceCompatible && this.correspondingJApiClass.isPresent() && !this.correspondingJApiClass.get().isSourceCompatible()) {
            sourceCompatible = false;
        }
        return sourceCompatible;
    }

    @Override
    @XmlElementWrapper(name="compatibilityChanges")
    @XmlElement(name="compatibilityChange")
    public List<JApiCompatibilityChange> getCompatibilityChanges() {
        return this.compatibilityChanges;
    }

    public void setJApiClass(JApiClass jApiClass) {
        this.correspondingJApiClass = Optional.of(jApiClass);
    }

    @XmlTransient
    public CtClass getCtClass() {
        return this.ctClass;
    }

    public String toString() {
        return "JApiImplementedInterface [fullyQualifiedName=" + this.fullyQualifiedName + ", changeStatus=" + (Object)((Object)this.changeStatus) + ", compatibilityChanges=" + this.compatibilityChanges + "]";
    }
}

