/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.cmp.JarArchiveComparator;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiHasChangeStatus;
import japicmp.util.Optional;
import javassist.CtClass;
import javax.xml.bind.annotation.XmlAttribute;

public class JApiException
implements JApiHasChangeStatus {
    private final String name;
    private final JApiChangeStatus changeStatus;
    private final boolean checkedException;

    public JApiException(JarArchiveComparator jarArchiveComparator, String name, Optional<CtClass> ctClassOptional, JApiChangeStatus changeStatus) {
        this.name = name;
        this.changeStatus = changeStatus;
        this.checkedException = this.isCheckedException(ctClassOptional, jarArchiveComparator);
    }

    private boolean isCheckedException(Optional<CtClass> ctClassOptional, JarArchiveComparator jarArchiveComparator) throws OutOfMemoryError {
        boolean checkedException = false;
        if (ctClassOptional.isPresent()) {
            Optional<CtClass> runtimeExceptionOptional;
            boolean subClassOfException = false;
            CtClass ctClass = ctClassOptional.get();
            Optional<CtClass> exceptionOptional = jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.NEW, Exception.class.getName());
            if (exceptionOptional.isPresent() && ctClass.subclassOf(exceptionOptional.get())) {
                subClassOfException = true;
            }
            if (subClassOfException && (runtimeExceptionOptional = jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.NEW, RuntimeException.class.getName())).isPresent() && !ctClass.subclassOf(runtimeExceptionOptional.get())) {
                checkedException = true;
            }
        }
        return checkedException;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    @Override
    @XmlAttribute(name="changeStatus")
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    public boolean isCheckedException() {
        return this.checkedException;
    }
}

