/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.exception.JApiCmpException;
import japicmp.model.JApiModifierBase;
import japicmp.util.Optional;

public enum AccessModifier implements JApiModifierBase
{
    PUBLIC(3),
    PROTECTED(2),
    PACKAGE_PROTECTED(1),
    PRIVATE(0);

    private int level;

    private AccessModifier(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public static String listOfAccessModifier() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (AccessModifier am : AccessModifier.values()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(am.toString());
            ++i;
        }
        return sb.toString();
    }

    public static Optional<AccessModifier> toModifier(String accessModifierArg) {
        Optional<String> stringOptional = Optional.fromNullable(accessModifierArg);
        if (stringOptional.isPresent()) {
            try {
                return Optional.of(AccessModifier.valueOf(stringOptional.get().toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new JApiCmpException(JApiCmpException.Reason.CliError, String.format("Invalid value for option accessModifier: %s. Possible values are: %s.", accessModifierArg, AccessModifier.listOfAccessModifier()), e);
            }
        }
        return Optional.of(PROTECTED);
    }
}

