/*
 * Decompiled with CFR 0.152.
 */
package japicmp.filter;

import japicmp.filter.ClassFilter;
import java.util.regex.Pattern;
import javassist.CtClass;

public class JavadocLikePackageFilter
implements ClassFilter {
    private final Pattern pattern;
    private final String packageName;

    public JavadocLikePackageFilter(String packageName, boolean exclusive) {
        this.packageName = packageName;
        String regEx = packageName.replace(".", "\\.");
        regEx = regEx.replace("*", ".*");
        regEx = regEx + (exclusive ? "" : "(\\.[^\\.]+)*");
        this.pattern = Pattern.compile(regEx);
    }

    public String toString() {
        return this.packageName;
    }

    @Override
    public boolean matches(CtClass ctClass) {
        String name = ctClass.getPackageName();
        name = name == null ? "" : name;
        return this.pattern.matcher(name).matches();
    }
}

