/*
 * Decompiled with CFR 0.152.
 */
package japicmp.compat;

import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.exception.JApiCmpException;
import japicmp.model.AbstractModifier;
import japicmp.model.AccessModifier;
import japicmp.model.FinalModifier;
import japicmp.model.JApiAnnotation;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiClassType;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiConstructor;
import japicmp.model.JApiException;
import japicmp.model.JApiField;
import japicmp.model.JApiHasAbstractModifier;
import japicmp.model.JApiHasAnnotations;
import japicmp.model.JApiImplementedInterface;
import japicmp.model.JApiMethod;
import japicmp.model.JApiModifier;
import japicmp.model.JApiSuperclass;
import japicmp.model.JApiType;
import japicmp.model.StaticModifier;
import japicmp.util.ClassHelper;
import japicmp.util.ModifierHelper;
import japicmp.util.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

public class CompatibilityChanges {
    private final JarArchiveComparator jarArchiveComparator;

    public CompatibilityChanges(JarArchiveComparator jarArchiveComparator) {
        this.jarArchiveComparator = jarArchiveComparator;
    }

    public void evaluate(List<JApiClass> classes) {
        Map<String, JApiClass> classMap = this.buildClassMap(classes);
        for (JApiClass clazz : classes) {
            this.evaluateBinaryCompatibility(clazz, classMap);
        }
    }

    private Map<String, JApiClass> buildClassMap(List<JApiClass> classes) {
        HashMap<String, JApiClass> classMap = new HashMap<String, JApiClass>();
        for (JApiClass clazz : classes) {
            classMap.put(clazz.getFullyQualifiedName(), clazz);
        }
        return classMap;
    }

    private void evaluateBinaryCompatibility(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        if (jApiClass.getChangeStatus() == JApiChangeStatus.REMOVED) {
            this.addCompatibilityChange(jApiClass, JApiCompatibilityChange.CLASS_REMOVED);
        } else if (jApiClass.getChangeStatus() == JApiChangeStatus.MODIFIED) {
            if (jApiClass.getAbstractModifier().hasChangedFromTo(AbstractModifier.NON_ABSTRACT, AbstractModifier.ABSTRACT)) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChange.CLASS_NOW_ABSTRACT);
            }
            if (jApiClass.getFinalModifier().hasChangedFromTo(FinalModifier.NON_FINAL, FinalModifier.FINAL)) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChange.CLASS_NOW_FINAL);
            }
            if (jApiClass.getAccessModifier().hasChangedFrom(AccessModifier.PUBLIC)) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChange.CLASS_NO_LONGER_PUBLIC);
            }
        }
        this.checkIfSuperclassesOrInterfacesChangedIncompatible(jApiClass, classMap);
        this.checkIfMethodsHaveChangedIncompatible(jApiClass, classMap);
        this.checkIfConstructorsHaveChangedIncompatible(jApiClass, classMap);
        this.checkIfFieldsHaveChangedIncompatible(jApiClass, classMap);
        if (jApiClass.getClassType().getChangeStatus() == JApiChangeStatus.MODIFIED) {
            this.addCompatibilityChange(jApiClass, JApiCompatibilityChange.CLASS_TYPE_CHANGED);
        }
        this.checkIfAnnotationDeprectedAdded(jApiClass);
        if (ModifierHelper.hasModifierLevelDecreased(jApiClass)) {
            this.addCompatibilityChange(jApiClass, JApiCompatibilityChange.CLASS_LESS_ACCESSIBLE);
        }
    }

    private void checkIfFieldsHaveChangedIncompatible(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        for (final JApiField field : jApiClass.getFields()) {
            ArrayList returnValues;
            if (ModifierHelper.isNotPrivate(field) && field.getChangeStatus() == JApiChangeStatus.REMOVED) {
                returnValues = new ArrayList();
                this.forAllSuperclasses(jApiClass, classMap, returnValues, new OnSuperclassCallback<Integer>(){

                    @Override
                    public Integer callback(JApiClass superclass, Map<String, JApiClass> classMap, JApiChangeStatus changeStatusOfSuperclass) {
                        int movedToSuperclass = 0;
                        for (JApiField superclassField : superclass.getFields()) {
                            if (!superclassField.getName().equals(field.getName()) || !CompatibilityChanges.this.fieldTypeMatches(superclassField, field) || !ModifierHelper.isNotPrivate(superclassField)) continue;
                            movedToSuperclass = 1;
                        }
                        return movedToSuperclass;
                    }
                });
                boolean movedToSuperclass = false;
                for (Integer returnValue : returnValues) {
                    if (returnValue != 1) continue;
                    movedToSuperclass = true;
                }
                if (!movedToSuperclass) {
                    this.addCompatibilityChange(field, JApiCompatibilityChange.FIELD_REMOVED);
                }
            }
            if (ModifierHelper.hasModifierLevelDecreased(field)) {
                this.addCompatibilityChange(field, JApiCompatibilityChange.FIELD_LESS_ACCESSIBLE);
            }
            if (ModifierHelper.isNotPrivate(field) && field.getChangeStatus() == JApiChangeStatus.NEW) {
                returnValues = new ArrayList();
                this.forAllSuperclasses(jApiClass, classMap, returnValues, new OnSuperclassCallback<Integer>(){

                    @Override
                    public Integer callback(JApiClass superclass, Map<String, JApiClass> classMap, JApiChangeStatus changeStatusOfSuperclass) {
                        int changedIncompatible = 0;
                        for (JApiField superclassField : superclass.getFields()) {
                            if (!superclassField.getName().equals(field.getName()) || !CompatibilityChanges.this.fieldTypeMatches(superclassField, field)) continue;
                            boolean superclassFieldIsStatic = false;
                            boolean subclassFieldIsStatic = false;
                            boolean accessModifierSubclassLess = false;
                            if (field.getStaticModifier().getNewModifier().isPresent() && field.getStaticModifier().getNewModifier().get() == StaticModifier.STATIC) {
                                subclassFieldIsStatic = true;
                            }
                            if (superclassField.getStaticModifier().getNewModifier().isPresent() && superclassField.getStaticModifier().getNewModifier().get() == StaticModifier.STATIC && superclassField.getChangeStatus() != JApiChangeStatus.NEW) {
                                superclassFieldIsStatic = true;
                            }
                            if (field.getAccessModifier().getNewModifier().isPresent() && superclassField.getAccessModifier().getNewModifier().isPresent() && field.getAccessModifier().getNewModifier().get().getLevel() < superclassField.getAccessModifier().getNewModifier().get().getLevel() && superclassField.getChangeStatus() != JApiChangeStatus.NEW) {
                                accessModifierSubclassLess = true;
                            }
                            if (superclassFieldIsStatic && subclassFieldIsStatic) {
                                changedIncompatible = 1;
                            }
                            if (!accessModifierSubclassLess) continue;
                            changedIncompatible = 2;
                        }
                        return changedIncompatible;
                    }
                });
                Iterator iterator = returnValues.iterator();
                while (iterator.hasNext()) {
                    int returnValue = (Integer)iterator.next();
                    if (returnValue == 1) {
                        this.addCompatibilityChange(field, JApiCompatibilityChange.FIELD_STATIC_AND_OVERRIDES_STATIC);
                        continue;
                    }
                    if (returnValue != 2) continue;
                    this.addCompatibilityChange(field, JApiCompatibilityChange.FIELD_LESS_ACCESSIBLE_THAN_IN_SUPERCLASS);
                }
            }
            if (ModifierHelper.isNotPrivate(field) && field.getFinalModifier().hasChangedFromTo(FinalModifier.NON_FINAL, FinalModifier.FINAL)) {
                this.addCompatibilityChange(field, JApiCompatibilityChange.FIELD_NOW_FINAL);
            }
            if (ModifierHelper.isNotPrivate(field)) {
                if (field.getStaticModifier().hasChangedFromTo(StaticModifier.NON_STATIC, StaticModifier.STATIC)) {
                    this.addCompatibilityChange(field, JApiCompatibilityChange.FIELD_NOW_STATIC);
                }
                if (field.getStaticModifier().hasChangedFromTo(StaticModifier.STATIC, StaticModifier.NON_STATIC)) {
                    this.addCompatibilityChange(field, JApiCompatibilityChange.FIELD_NO_LONGER_STATIC);
                }
            }
            if (ModifierHelper.isNotPrivate(field) && field.getType().hasChanged()) {
                this.addCompatibilityChange(field, JApiCompatibilityChange.FIELD_TYPE_CHANGED);
            }
            this.checkIfAnnotationDeprectedAdded(field);
        }
    }

    private <T> void forAllSuperclasses(JApiClass jApiClass, Map<String, JApiClass> classMap, List<T> returnValues, OnSuperclassCallback<T> onSuperclassCallback) {
        JApiSuperclass superclass = jApiClass.getSuperclass();
        if (superclass.getNewSuperclassName().isPresent()) {
            String newSuperclassName = superclass.getNewSuperclassName().get();
            JApiClass foundClass = classMap.get(newSuperclassName);
            if (foundClass == null) {
                Optional<JApiClass> superclassJApiClassOptional = superclass.getJApiClass();
                if (superclassJApiClassOptional.isPresent()) {
                    foundClass = superclassJApiClassOptional.get();
                } else {
                    foundClass = this.loadClass(newSuperclassName, EnumSet.of(Classpath.NEW_CLASSPATH));
                    this.evaluate(Collections.singletonList(foundClass));
                }
                classMap.put(foundClass.getFullyQualifiedName(), foundClass);
            }
            T returnValue = onSuperclassCallback.callback(foundClass, classMap, superclass.getChangeStatus());
            returnValues.add(returnValue);
            this.forAllSuperclasses(foundClass, classMap, returnValues, onSuperclassCallback);
        }
    }

    private JApiClass loadClass(String newSuperclassName, EnumSet<Classpath> classpaths) {
        Optional<Object> oldClassOptional = Optional.absent();
        Optional<Object> newClassOptional = Optional.absent();
        JarArchiveComparatorOptions.ClassPathMode classPathMode = this.jarArchiveComparator.getJarArchiveComparatorOptions().getClassPathMode();
        if (classPathMode == JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH) {
            ClassPool classPool = this.jarArchiveComparator.getCommonClassPool();
            try {
                oldClassOptional = Optional.of(classPool.get(newSuperclassName));
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            try {
                newClassOptional = Optional.of(classPool.get(newSuperclassName));
            }
            catch (NotFoundException notFoundException) {}
        } else {
            if (classpaths.contains((Object)Classpath.OLD_CLASSPATH)) {
                ClassPool oldClassPool = this.jarArchiveComparator.getOldClassPool();
                try {
                    oldClassOptional = Optional.of(oldClassPool.get(newSuperclassName));
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            if (classpaths.contains((Object)Classpath.NEW_CLASSPATH)) {
                ClassPool newClassPool = this.jarArchiveComparator.getNewClassPool();
                try {
                    newClassOptional = Optional.of(newClassPool.get(newSuperclassName));
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
        if (!(oldClassOptional.isPresent() || newClassOptional.isPresent() || this.jarArchiveComparator.getJarArchiveComparatorOptions().getIgnoreMissingClasses().ignoreClass(newSuperclassName))) {
            throw JApiCmpException.forClassLoading(newSuperclassName, this.jarArchiveComparator);
        }
        JApiChangeStatus changeStatus = JApiChangeStatus.UNCHANGED;
        JApiClassType classType = oldClassOptional.isPresent() && newClassOptional.isPresent() ? new JApiClassType(Optional.of(ClassHelper.getType((CtClass)oldClassOptional.get())), Optional.of(ClassHelper.getType((CtClass)newClassOptional.get())), JApiChangeStatus.UNCHANGED) : (oldClassOptional.isPresent() && !newClassOptional.isPresent() ? new JApiClassType(Optional.of(ClassHelper.getType((CtClass)oldClassOptional.get())), Optional.absent(), JApiChangeStatus.REMOVED) : (!oldClassOptional.isPresent() && newClassOptional.isPresent() ? new JApiClassType(Optional.absent(), Optional.of(ClassHelper.getType((CtClass)newClassOptional.get())), JApiChangeStatus.NEW) : new JApiClassType(Optional.absent(), Optional.absent(), JApiChangeStatus.UNCHANGED)));
        JApiClass foundClass = new JApiClass(this.jarArchiveComparator, newSuperclassName, oldClassOptional, newClassOptional, changeStatus, classType);
        return foundClass;
    }

    private boolean fieldTypeMatches(JApiField field1, JApiField field2) {
        boolean matches = true;
        JApiType type1 = field1.getType();
        JApiType type2 = field2.getType();
        if (type1.getNewTypeOptional().isPresent() && type2.getNewTypeOptional().isPresent() && !type1.getNewTypeOptional().get().equals(type2.getNewTypeOptional().get())) {
            matches = false;
        }
        return matches;
    }

    private void checkIfConstructorsHaveChangedIncompatible(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        for (JApiConstructor constructor : jApiClass.getConstructors()) {
            if (ModifierHelper.isNotPrivate(constructor) && constructor.getChangeStatus() == JApiChangeStatus.REMOVED) {
                this.addCompatibilityChange(constructor, JApiCompatibilityChange.CONSTRUCTOR_REMOVED);
            }
            if (ModifierHelper.hasModifierLevelDecreased(constructor)) {
                this.addCompatibilityChange(constructor, JApiCompatibilityChange.CONSTRUCTOR_LESS_ACCESSIBLE);
            }
            this.checkIfAnnotationDeprectedAdded(constructor);
        }
    }

    private void checkIfMethodsHaveChangedIncompatible(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        for (final JApiMethod method : jApiClass.getMethods()) {
            ArrayList<Integer> returnValues;
            if (ModifierHelper.isNotPrivate(method) && method.getChangeStatus() == JApiChangeStatus.REMOVED) {
                returnValues = new ArrayList<Integer>();
                this.forAllSuperclasses(jApiClass, classMap, returnValues, new OnSuperclassCallback<Integer>(){

                    @Override
                    public Integer callback(JApiClass superclass, Map<String, JApiClass> classMap, JApiChangeStatus changeStatusOfSuperclass) {
                        for (JApiMethod superMethod : superclass.getMethods()) {
                            if (!superMethod.getName().equals(method.getName()) || !superMethod.hasSameParameter(method) || !superMethod.hasSameReturnType(method)) continue;
                            return 1;
                        }
                        return 0;
                    }
                });
                this.checkIfMethodHasBeenPulledUp(jApiClass, classMap, method, returnValues);
                boolean superclassHasSameMethod = false;
                for (Integer returnValue : returnValues) {
                    if (returnValue != 1) continue;
                    superclassHasSameMethod = true;
                }
                if (!superclassHasSameMethod) {
                    this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_REMOVED);
                }
            }
            if (ModifierHelper.hasModifierLevelDecreased(method)) {
                this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_LESS_ACCESSIBLE);
            }
            if (ModifierHelper.isNotPrivate(method) && method.getChangeStatus() == JApiChangeStatus.NEW) {
                returnValues = new ArrayList();
                this.forAllSuperclasses(jApiClass, classMap, returnValues, new OnSuperclassCallback<Integer>(){

                    @Override
                    public Integer callback(JApiClass superclass, Map<String, JApiClass> classMap, JApiChangeStatus changeStatusOfSuperclass) {
                        for (JApiMethod superMethod : superclass.getMethods()) {
                            if (!superMethod.getName().equals(method.getName()) || !superMethod.hasSameParameter(method) || !superMethod.hasSameReturnType(method)) continue;
                            if (superMethod.getAccessModifier().getNewModifier().isPresent() && method.getAccessModifier().getNewModifier().isPresent() && superMethod.getAccessModifier().getNewModifier().get().getLevel() > method.getAccessModifier().getNewModifier().get().getLevel()) {
                                return 1;
                            }
                            if (!superMethod.getStaticModifier().getNewModifier().isPresent() || !method.getStaticModifier().getNewModifier().isPresent() || superMethod.getStaticModifier().getNewModifier().get() != StaticModifier.NON_STATIC || method.getStaticModifier().getNewModifier().get() != StaticModifier.STATIC) continue;
                            return 2;
                        }
                        return 0;
                    }
                });
                for (Integer returnValue : returnValues) {
                    if (returnValue == 1) {
                        this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_LESS_ACCESSIBLE_THAN_IN_SUPERCLASS);
                        continue;
                    }
                    if (returnValue != 2) continue;
                    this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_IS_STATIC_AND_OVERRIDES_NOT_STATIC);
                }
            }
            if (method.getReturnType().getChangeStatus() == JApiChangeStatus.MODIFIED) {
                this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_RETURN_TYPE_CHANGED);
            }
            if (ModifierHelper.isNotPrivate(method) && method.getAbstractModifier().hasChangedFromTo(AbstractModifier.NON_ABSTRACT, AbstractModifier.ABSTRACT)) {
                this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_NOW_ABSTRACT);
            }
            if (ModifierHelper.isNotPrivate(method) && method.getFinalModifier().hasChangedFromTo(FinalModifier.NON_FINAL, FinalModifier.FINAL) && (!method.getStaticModifier().getOldModifier().isPresent() || method.getStaticModifier().getOldModifier().get() != StaticModifier.STATIC)) {
                this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_NOW_FINAL);
            }
            if (ModifierHelper.isNotPrivate(method)) {
                if (method.getStaticModifier().hasChangedFromTo(StaticModifier.NON_STATIC, StaticModifier.STATIC)) {
                    this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_NOW_STATIC);
                }
                if (method.getStaticModifier().hasChangedFromTo(StaticModifier.STATIC, StaticModifier.NON_STATIC)) {
                    this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_NO_LONGER_STATIC);
                }
            }
            this.checkAbstractMethod(jApiClass, classMap, method);
            this.checkIfExceptionIsNowChecked(method);
            this.checkIfAnnotationDeprectedAdded(method);
        }
    }

    private void checkIfAnnotationDeprectedAdded(JApiHasAnnotations jApiHasAnnotations) {
        for (JApiAnnotation annotation : jApiHasAnnotations.getAnnotations()) {
            if (annotation.getChangeStatus() != JApiChangeStatus.NEW && annotation.getChangeStatus() != JApiChangeStatus.MODIFIED || !annotation.getFullyQualifiedName().equals(Deprecated.class.getName())) continue;
            this.addCompatibilityChange((JApiCompatibility)((Object)jApiHasAnnotations), JApiCompatibilityChange.ANNOTATION_DEPRECATED_ADDED);
        }
    }

    private void checkAbstractMethod(JApiClass jApiClass, Map<String, JApiClass> classMap, JApiMethod method) {
        if (this.isInterface(jApiClass)) {
            if (jApiClass.getChangeStatus() != JApiChangeStatus.NEW) {
                JApiModifier<AbstractModifier> abstractModifier;
                if (method.getChangeStatus() == JApiChangeStatus.NEW && !ModifierHelper.isSynthetic(method)) {
                    List<JApiMethod> implementedMethods = this.getImplementedMethods(jApiClass, classMap, method);
                    if (implementedMethods.size() == 0) {
                        if (method.getAbstractModifier().hasChangedTo(AbstractModifier.NON_ABSTRACT)) {
                            this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_NEW_DEFAULT);
                        } else {
                            this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_ADDED_TO_INTERFACE);
                        }
                    } else {
                        boolean allNew = true;
                        for (JApiMethod jApiMethod : implementedMethods) {
                            if (jApiMethod.getChangeStatus() == JApiChangeStatus.NEW) continue;
                            allNew = false;
                        }
                        if (allNew) {
                            this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_ADDED_TO_INTERFACE);
                        }
                    }
                } else if ((method.getChangeStatus() == JApiChangeStatus.MODIFIED || method.getChangeStatus() == JApiChangeStatus.UNCHANGED) && (abstractModifier = method.getAbstractModifier()).getOldModifier().isPresent() && abstractModifier.getOldModifier().get() == AbstractModifier.ABSTRACT && abstractModifier.getNewModifier().isPresent() && abstractModifier.getNewModifier().get() == AbstractModifier.NON_ABSTRACT) {
                    this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_ABSTRACT_NOW_DEFAULT);
                }
            }
        } else if (this.isAbstract(method) && jApiClass.getChangeStatus() != JApiChangeStatus.NEW && method.getChangeStatus() == JApiChangeStatus.NEW && !ModifierHelper.isSynthetic(method)) {
            List<JApiMethod> overriddenMethods = this.getOverriddenMethods(jApiClass, classMap, method);
            boolean overridesAbstract = false;
            for (JApiMethod jApiMethod : overriddenMethods) {
                if (!this.isAbstract(jApiMethod) || jApiMethod.getChangeStatus() == JApiChangeStatus.NEW) continue;
                overridesAbstract = true;
            }
            List<JApiMethod> implementedMethods = this.getImplementedMethods(jApiClass, classMap, method);
            if (implementedMethods.size() > 0) {
                overridesAbstract = true;
            }
            if (!overridesAbstract) {
                this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_ABSTRACT_ADDED_TO_CLASS);
            }
        }
    }

    private List<JApiMethod> getOverriddenMethods(JApiClass jApiClass, Map<String, JApiClass> classMap, final JApiMethod method) {
        ArrayList<JApiMethod> jApiMethods = new ArrayList<JApiMethod>();
        this.forAllSuperclasses(jApiClass, classMap, jApiMethods, new OnSuperclassCallback<JApiMethod>(){

            @Override
            public JApiMethod callback(JApiClass superclass, Map<String, JApiClass> classMap, JApiChangeStatus changeStatusOfSuperclass) {
                for (JApiMethod jApiMethod : superclass.getMethods()) {
                    if (!CompatibilityChanges.this.isAbstract(jApiMethod) || !jApiMethod.getName().equals(method.getName()) || !jApiMethod.hasSameSignature(method)) continue;
                    return jApiMethod;
                }
                return null;
            }
        });
        return this.removeNullValues(jApiMethods);
    }

    private List<JApiMethod> removeNullValues(ArrayList<JApiMethod> jApiMethods) {
        ArrayList<JApiMethod> returnValues = new ArrayList<JApiMethod>();
        for (JApiMethod jApiMethod : jApiMethods) {
            if (jApiMethod == null) continue;
            returnValues.add(jApiMethod);
        }
        return returnValues;
    }

    private List<JApiMethod> getImplementedMethods(JApiClass jApiClass, Map<String, JApiClass> classMap, final JApiMethod method) {
        ArrayList<JApiMethod> jApiMethods = new ArrayList<JApiMethod>();
        this.forAllImplementedInterfaces(jApiClass, classMap, jApiMethods, new OnImplementedInterfaceCallback<JApiMethod>(){

            @Override
            public JApiMethod callback(JApiClass implementedInterface, Map<String, JApiClass> classMap) {
                for (JApiMethod jApiMethod : implementedInterface.getMethods()) {
                    if (!CompatibilityChanges.this.isAbstract(jApiMethod) || !jApiMethod.getName().equals(method.getName()) || !jApiMethod.hasSameSignature(method)) continue;
                    return jApiMethod;
                }
                return null;
            }
        });
        return this.removeNullValues(jApiMethods);
    }

    private boolean isAbstract(JApiHasAbstractModifier jApiHasAbstractModifier) {
        boolean isAbstract = false;
        if (jApiHasAbstractModifier.getAbstractModifier().hasChangedTo(AbstractModifier.ABSTRACT)) {
            isAbstract = true;
        }
        return isAbstract;
    }

    private void checkIfExceptionIsNowChecked(JApiMethod method) {
        for (JApiException exception : method.getExceptions()) {
            if (exception.getChangeStatus() != JApiChangeStatus.NEW || !exception.isCheckedException() || method.getChangeStatus() == JApiChangeStatus.NEW) continue;
            this.addCompatibilityChange(method, JApiCompatibilityChange.METHOD_NOW_THROWS_CHECKED_EXCEPTION);
        }
    }

    private boolean isInterface(JApiClass jApiClass) {
        return jApiClass.getClassType().getNewTypeOptional().isPresent() && jApiClass.getClassType().getNewTypeOptional().get() == JApiClassType.ClassType.INTERFACE;
    }

    private void checkIfMethodHasBeenPulledUp(JApiClass jApiClass, Map<String, JApiClass> classMap, final JApiMethod method, List<Integer> returnValues) {
        this.forAllImplementedInterfaces(jApiClass, classMap, returnValues, new OnImplementedInterfaceCallback<Integer>(){

            @Override
            public Integer callback(JApiClass implementedInterface, Map<String, JApiClass> classMap) {
                for (JApiMethod superMethod : implementedInterface.getMethods()) {
                    if (!superMethod.getName().equals(method.getName()) || !superMethod.hasSameParameter(method) || !superMethod.hasSameReturnType(method)) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    private <T> void forAllImplementedInterfaces(JApiClass jApiClass, Map<String, JApiClass> classMap, List<T> returnValues, OnImplementedInterfaceCallback<T> onImplementedInterfaceCallback) {
        List<JApiImplementedInterface> interfaces = jApiClass.getInterfaces();
        for (JApiImplementedInterface implementedInterface : interfaces) {
            String fullyQualifiedName = implementedInterface.getFullyQualifiedName();
            JApiClass foundClass = classMap.get(fullyQualifiedName);
            if (foundClass == null) continue;
            T returnValue = onImplementedInterfaceCallback.callback(foundClass, classMap);
            returnValues.add(returnValue);
            this.forAllImplementedInterfaces(foundClass, classMap, returnValues, onImplementedInterfaceCallback);
        }
    }

    private boolean isImplemented(JApiMethod jApiMethod) {
        JApiClass aClass = jApiMethod.getjApiClass();
        while (aClass != null) {
            for (JApiMethod method : aClass.getMethods()) {
                if (!jApiMethod.getName().equals(method.getName()) || !jApiMethod.hasSameParameter(method) || this.isAbstract(method) || method.getChangeStatus() == JApiChangeStatus.REMOVED || !ModifierHelper.isNotPrivate(method)) continue;
                return true;
            }
            if (aClass.getSuperclass() != null && aClass.getSuperclass().getJApiClass().isPresent()) {
                aClass = aClass.getSuperclass().getJApiClass().get();
                continue;
            }
            aClass = null;
        }
        return false;
    }

    private void checkIfSuperclassesOrInterfacesChangedIncompatible(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        final JApiSuperclass superclass = jApiClass.getSuperclass();
        if (superclass.getChangeStatus() == JApiChangeStatus.UNCHANGED || superclass.getChangeStatus() == JApiChangeStatus.MODIFIED || superclass.getChangeStatus() == JApiChangeStatus.REMOVED) {
            final ArrayList<JApiMethod> implementedMethods = new ArrayList<JApiMethod>();
            final ArrayList removedAndNotOverriddenMethods = new ArrayList();
            final ArrayList<JApiField> fields = new ArrayList<JApiField>();
            final ArrayList removedAndNotOverriddenFields = new ArrayList();
            for (JApiMethod jApiMethod : jApiClass.getMethods()) {
                if (this.isAbstract(jApiMethod) || jApiMethod.getChangeStatus() == JApiChangeStatus.REMOVED || !ModifierHelper.isNotPrivate(jApiMethod)) continue;
                implementedMethods.add(jApiMethod);
            }
            for (JApiField jApiField : jApiClass.getFields()) {
                if (jApiField.getChangeStatus() == JApiChangeStatus.REMOVED || !ModifierHelper.isNotPrivate(jApiField)) continue;
                fields.add(jApiField);
            }
            this.forAllSuperclasses(jApiClass, classMap, new ArrayList(), new OnSuperclassCallback<Integer>(){

                @Override
                public Integer callback(JApiClass superclass, Map<String, JApiClass> classMap, JApiChangeStatus changeStatusOfSuperclass) {
                    for (JApiMethod jApiMethod : superclass.getMethods()) {
                        if (CompatibilityChanges.this.isAbstract(jApiMethod) || jApiMethod.getChangeStatus() == JApiChangeStatus.REMOVED || !ModifierHelper.isNotPrivate(jApiMethod)) continue;
                        implementedMethods.add(jApiMethod);
                    }
                    for (JApiField jApiField : superclass.getFields()) {
                        if (jApiField.getChangeStatus() == JApiChangeStatus.REMOVED || !ModifierHelper.isNotPrivate(jApiField)) continue;
                        fields.add(jApiField);
                    }
                    for (JApiMethod jApiMethod : superclass.getMethods()) {
                        if (jApiMethod.getChangeStatus() != JApiChangeStatus.REMOVED || CompatibilityChanges.this.isImplemented(jApiMethod)) continue;
                        boolean implemented = false;
                        for (JApiMethod implementedMethod : implementedMethods) {
                            if (!jApiMethod.getName().equals(implementedMethod.getName()) || !jApiMethod.hasSameSignature(implementedMethod)) continue;
                            implemented = true;
                            break;
                        }
                        if (implemented) continue;
                        removedAndNotOverriddenMethods.add(jApiMethod);
                    }
                    for (JApiField jApiField : superclass.getFields()) {
                        if (jApiField.getChangeStatus() != JApiChangeStatus.REMOVED) continue;
                        boolean overridden = false;
                        for (JApiField field : fields) {
                            if (!field.getName().equals(jApiField.getName()) || !CompatibilityChanges.this.hasSameType(jApiField, field)) continue;
                            overridden = true;
                        }
                        if (overridden) continue;
                        removedAndNotOverriddenFields.add(jApiField);
                    }
                    return 0;
                }
            });
            if (removedAndNotOverriddenMethods.size() > 0) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChange.METHOD_REMOVED_IN_SUPERCLASS);
            }
            if (removedAndNotOverriddenFields.size() > 0) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChange.FIELD_REMOVED_IN_SUPERCLASS);
            }
            if (superclass.getOldSuperclassName().isPresent() && superclass.getNewSuperclassName().isPresent()) {
                if (!superclass.getOldSuperclassName().get().equals(superclass.getNewSuperclassName().get())) {
                    boolean superClassChangedToObject = false;
                    boolean superClassChangedFromObject = false;
                    if (!superclass.getOldSuperclassName().get().equals("java.lang.Object") && superclass.getNewSuperclassName().get().equals("java.lang.Object")) {
                        superClassChangedToObject = true;
                    }
                    if (superclass.getOldSuperclassName().get().equals("java.lang.Object") && !superclass.getNewSuperclassName().get().equals("java.lang.Object")) {
                        superClassChangedFromObject = true;
                    }
                    if (superClassChangedToObject) {
                        this.addCompatibilityChange(superclass, JApiCompatibilityChange.SUPERCLASS_REMOVED);
                    } else if (superClassChangedFromObject) {
                        this.addCompatibilityChange(superclass, JApiCompatibilityChange.SUPERCLASS_ADDED);
                    } else {
                        ArrayList ancestors = new ArrayList();
                        final ArrayList matchingAncestors = new ArrayList();
                        this.forAllSuperclasses(jApiClass, classMap, ancestors, new OnSuperclassCallback<JApiSuperclass>(){

                            @Override
                            public JApiSuperclass callback(JApiClass clazz, Map<String, JApiClass> classMap, JApiChangeStatus changeStatusOfSuperclass) {
                                JApiSuperclass ancestor = clazz.getSuperclass();
                                if (ancestor.getNewSuperclassName().isPresent() && ancestor.getNewSuperclassName().get().equals(superclass.getOldSuperclassName().get())) {
                                    matchingAncestors.add(ancestor);
                                }
                                return ancestor;
                            }
                        });
                        if (matchingAncestors.isEmpty()) {
                            this.addCompatibilityChange(superclass, JApiCompatibilityChange.SUPERCLASS_REMOVED);
                        } else {
                            this.addCompatibilityChange(superclass, JApiCompatibilityChange.SUPERCLASS_ADDED);
                        }
                    }
                }
            } else if (superclass.getOldSuperclassName().isPresent()) {
                this.addCompatibilityChange(superclass, JApiCompatibilityChange.SUPERCLASS_REMOVED);
            } else if (superclass.getNewSuperclassName().isPresent()) {
                this.addCompatibilityChange(superclass, JApiCompatibilityChange.SUPERCLASS_ADDED);
            }
        }
        for (JApiImplementedInterface implementedInterface : jApiClass.getInterfaces()) {
            if (implementedInterface.getChangeStatus() == JApiChangeStatus.REMOVED) {
                this.addCompatibilityChange(implementedInterface, JApiCompatibilityChange.INTERFACE_REMOVED);
                continue;
            }
            JApiClass interfaceClass = classMap.get(implementedInterface.getFullyQualifiedName());
            if (interfaceClass == null) {
                interfaceClass = this.loadClass(implementedInterface.getFullyQualifiedName(), EnumSet.allOf(Classpath.class));
            }
            if (implementedInterface.getChangeStatus() == JApiChangeStatus.MODIFIED || implementedInterface.getChangeStatus() == JApiChangeStatus.UNCHANGED) {
                implementedInterface.setJApiClass(interfaceClass);
                this.checkIfMethodsHaveChangedIncompatible(interfaceClass, classMap);
                this.checkIfFieldsHaveChangedIncompatible(interfaceClass, classMap);
                continue;
            }
            if (implementedInterface.getChangeStatus() != JApiChangeStatus.NEW || interfaceClass.getMethods().size() <= 0) continue;
            boolean allInterfaceMethodsImplemented = true;
            for (JApiMethod interfaceMethod : interfaceClass.getMethods()) {
                boolean interfaceMethodImplemented = false;
                if (ModifierHelper.isSynthetic(interfaceMethod)) continue;
                for (JApiMethod classMethod : jApiClass.getMethods()) {
                    if (!classMethod.getName().equals(interfaceMethod.getName()) || !classMethod.hasSameSignature(interfaceMethod)) continue;
                    interfaceMethodImplemented = true;
                    break;
                }
                if (interfaceMethodImplemented) continue;
                allInterfaceMethodsImplemented = false;
                break;
            }
            if (allInterfaceMethodsImplemented) continue;
            this.addCompatibilityChange(jApiClass, JApiCompatibilityChange.INTERFACE_ADDED);
        }
        this.checkIfClassNowCheckedException(jApiClass);
        this.checkIfAbstractMethodAddedInSuperclass(jApiClass, classMap);
        this.checkIfAbstractMethodAdded(jApiClass, classMap);
    }

    private boolean hasSameType(JApiField field, JApiField otherField) {
        boolean hasSameNewType = false;
        if (field.getType().getNewTypeOptional().isPresent() && otherField.getType().getNewTypeOptional().isPresent()) {
            hasSameNewType = field.getType().getNewTypeOptional().get().equals(otherField.getType().getNewTypeOptional().get());
        } else if (field.getType().getOldTypeOptional().isPresent() && otherField.getType().getNewTypeOptional().isPresent()) {
            hasSameNewType = field.getType().getOldTypeOptional().get().equals(otherField.getType().getNewTypeOptional().get());
        } else if (field.getType().getOldTypeOptional().isPresent() && otherField.getType().getOldTypeOptional().isPresent()) {
            hasSameNewType = field.getType().getOldTypeOptional().get().equals(otherField.getType().getOldTypeOptional().get());
        }
        return hasSameNewType;
    }

    private void checkIfAbstractMethodAdded(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        if (jApiClass.getChangeStatus() == JApiChangeStatus.NEW || !this.isAbstract(jApiClass)) {
            // empty if block
        }
    }

    private void checkIfAbstractMethodAddedInSuperclass(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        if (jApiClass.getChangeStatus() != JApiChangeStatus.NEW) {
            final ArrayList<JApiMethod> abstractMethods = new ArrayList<JApiMethod>();
            final ArrayList<JApiMethod> implementedMethods = new ArrayList<JApiMethod>();
            final ArrayList implementedInterfaces = new ArrayList();
            for (JApiMethod jApiMethod : jApiClass.getMethods()) {
                if (this.isAbstract(jApiMethod)) continue;
                implementedMethods.add(jApiMethod);
            }
            this.forAllSuperclasses(jApiClass, classMap, new ArrayList(), new OnSuperclassCallback<Integer>(){

                @Override
                public Integer callback(JApiClass superclass, Map<String, JApiClass> classMap, JApiChangeStatus changeStatusOfSuperclass) {
                    for (JApiMethod jApiMethod : superclass.getMethods()) {
                        if (CompatibilityChanges.this.isAbstract(jApiMethod)) continue;
                        implementedMethods.add(jApiMethod);
                    }
                    for (JApiMethod jApiMethod : superclass.getMethods()) {
                        if (!CompatibilityChanges.this.isAbstract(jApiMethod)) continue;
                        boolean isImplemented = false;
                        for (JApiMethod implementedMethod : implementedMethods) {
                            if (!jApiMethod.getName().equals(implementedMethod.getName()) || !jApiMethod.hasSameSignature(implementedMethod)) continue;
                            isImplemented = true;
                            break;
                        }
                        if (isImplemented || jApiMethod.getChangeStatus() != JApiChangeStatus.NEW && changeStatusOfSuperclass != JApiChangeStatus.NEW && changeStatusOfSuperclass != JApiChangeStatus.MODIFIED) continue;
                        abstractMethods.add(jApiMethod);
                    }
                    implementedInterfaces.addAll(superclass.getInterfaces());
                    return 0;
                }
            });
            if (abstractMethods.size() > 0) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChange.METHOD_ABSTRACT_ADDED_IN_SUPERCLASS);
            }
            abstractMethods.clear();
            for (JApiImplementedInterface jApiImplementedInterface : implementedInterfaces) {
                String fullyQualifiedName = jApiImplementedInterface.getFullyQualifiedName();
                JApiClass foundClass = classMap.get(fullyQualifiedName);
                if (foundClass == null) {
                    foundClass = this.loadClass(fullyQualifiedName, EnumSet.allOf(Classpath.class));
                }
                for (JApiMethod method : foundClass.getMethods()) {
                    boolean isImplemented = false;
                    for (JApiMethod implementedMethod : implementedMethods) {
                        if (!method.getName().equals(implementedMethod.getName()) || !method.hasSameSignature(implementedMethod)) continue;
                        isImplemented = true;
                        break;
                    }
                    if (isImplemented || method.getChangeStatus() != JApiChangeStatus.NEW && jApiImplementedInterface.getChangeStatus() != JApiChangeStatus.NEW) continue;
                    abstractMethods.add(method);
                }
            }
            if (abstractMethods.size() > 0) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChange.METHOD_ABSTRACT_ADDED_IN_IMPLEMENTED_INTERFACE);
            }
        }
    }

    private void checkIfClassNowCheckedException(JApiClass jApiClass) {
        String fqn;
        JApiSuperclass jApiClassSuperclass = jApiClass.getSuperclass();
        if (jApiClassSuperclass.getChangeStatus() == JApiChangeStatus.MODIFIED && jApiClassSuperclass.getNewSuperclassName().isPresent() && "java.lang.Exception".equals(fqn = jApiClassSuperclass.getNewSuperclassName().get())) {
            this.addCompatibilityChange(jApiClass, JApiCompatibilityChange.CLASS_NOW_CHECKED_EXCEPTION);
        }
    }

    private void addCompatibilityChange(JApiCompatibility binaryCompatibility, JApiCompatibilityChange compatibilityChange) {
        List<JApiCompatibilityChange> compatibilityChanges = binaryCompatibility.getCompatibilityChanges();
        if (!compatibilityChanges.contains((Object)compatibilityChange)) {
            compatibilityChanges.add(compatibilityChange);
        }
    }

    private static enum Classpath {
        OLD_CLASSPATH,
        NEW_CLASSPATH;

    }

    private static interface OnImplementedInterfaceCallback<T> {
        public T callback(JApiClass var1, Map<String, JApiClass> var2);
    }

    private static interface OnSuperclassCallback<T> {
        public T callback(JApiClass var1, Map<String, JApiClass> var2, JApiChangeStatus var3);
    }
}

