/*
 * Decompiled with CFR 0.152.
 */
package japicmp.cmp;

import japicmp.config.IgnoreMissingClasses;
import japicmp.config.Options;
import japicmp.exception.JApiCmpException;
import japicmp.filter.Filters;
import japicmp.model.AccessModifier;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiSemanticVersionLevel;
import japicmp.util.Optional;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class JarArchiveComparatorOptions {
    private final List<String> classPathEntries = new LinkedList<String>();
    private AccessModifier accessModifier = AccessModifier.PROTECTED;
    private final Filters filters = new Filters();
    private boolean includeSynthetic = false;
    private IgnoreMissingClasses ignoreMissingClasses = new IgnoreMissingClasses();
    private ClassPathMode classPathMode = ClassPathMode.ONE_COMMON_CLASSPATH;
    private List<String> oldClassPath = new LinkedList<String>();
    private List<String> newClassPath = new LinkedList<String>();
    private boolean noAnnotations = false;
    private boolean includeClassFileFormatVersion = false;
    private List<OverrideCompatibilityChange> overrideCompatibilityChanges = new ArrayList<OverrideCompatibilityChange>();

    public static JarArchiveComparatorOptions of(Options options) {
        JarArchiveComparatorOptions comparatorOptions = new JarArchiveComparatorOptions();
        comparatorOptions.getFilters().getExcludes().addAll(options.getExcludes());
        comparatorOptions.getFilters().getIncludes().addAll(options.getIncludes());
        comparatorOptions.setAccessModifier(options.getAccessModifier());
        comparatorOptions.setIncludeSynthetic(options.isIncludeSynthetic());
        comparatorOptions.setIgnoreMissingClasses(options.getIgnoreMissingClasses());
        JarArchiveComparatorOptions.toJarArchiveComparatorClassPathMode(options, comparatorOptions);
        JarArchiveComparatorOptions.toJarArchiveComparatorClassPath(options.getOldClassPath(), comparatorOptions.getOldClassPath());
        JarArchiveComparatorOptions.toJarArchiveComparatorClassPath(options.getNewClassPath(), comparatorOptions.getNewClassPath());
        comparatorOptions.setNoAnnotations(options.isNoAnnotations());
        return comparatorOptions;
    }

    private void setIgnoreMissingClasses(IgnoreMissingClasses ignoreMissingClasses) {
        this.ignoreMissingClasses = ignoreMissingClasses;
    }

    private static void toJarArchiveComparatorClassPathMode(Options options, JarArchiveComparatorOptions comparatorOptions) {
        switch (options.getClassPathMode()) {
            case TWO_SEPARATE_CLASSPATHS: {
                comparatorOptions.setClassPathMode(ClassPathMode.TWO_SEPARATE_CLASSPATHS);
                break;
            }
            case ONE_COMMON_CLASSPATH: {
                comparatorOptions.setClassPathMode(ClassPathMode.ONE_COMMON_CLASSPATH);
                break;
            }
            default: {
                throw new JApiCmpException(JApiCmpException.Reason.IllegalState, "Unknown classPathMode: " + (Object)((Object)options.getClassPathMode()));
            }
        }
    }

    private static void toJarArchiveComparatorClassPath(Optional<String> classPathOptional, List<String> comparatorClassPath) {
        if (classPathOptional.isPresent()) {
            String classPathAsString = classPathOptional.get();
            Collections.addAll(comparatorClassPath, classPathAsString.split(File.pathSeparator));
        }
    }

    public Filters getFilters() {
        return this.filters;
    }

    public List<String> getClassPathEntries() {
        return this.classPathEntries;
    }

    public void setAccessModifier(AccessModifier accessModifier) {
        this.accessModifier = accessModifier;
    }

    public AccessModifier getAccessModifier() {
        return this.accessModifier;
    }

    public void setIncludeSynthetic(boolean includeSynthetic) {
        this.includeSynthetic = includeSynthetic;
    }

    public boolean isIncludeSynthetic() {
        return this.includeSynthetic;
    }

    public void setClassPathMode(ClassPathMode classPathMode) {
        this.classPathMode = classPathMode;
    }

    public ClassPathMode getClassPathMode() {
        return this.classPathMode;
    }

    public void setOldClassPath(List<String> oldClassPath) {
        this.oldClassPath = oldClassPath;
    }

    public List<String> getOldClassPath() {
        return this.oldClassPath;
    }

    public void setNewClassPath(List<String> newClassPath) {
        this.newClassPath = newClassPath;
    }

    public List<String> getNewClassPath() {
        return this.newClassPath;
    }

    public void setNoAnnotations(boolean noAnnotations) {
        this.noAnnotations = noAnnotations;
    }

    public boolean isNoAnnotations() {
        return this.noAnnotations;
    }

    public IgnoreMissingClasses getIgnoreMissingClasses() {
        return this.ignoreMissingClasses;
    }

    public boolean isIncludeClassFileFormatVersion() {
        return this.includeClassFileFormatVersion;
    }

    public void addOverrideCompatibilityChange(OverrideCompatibilityChange overrideCompatibilityChange) {
        this.overrideCompatibilityChanges.add(overrideCompatibilityChange);
    }

    public List<OverrideCompatibilityChange> getOverrideCompatibilityChanges() {
        return this.overrideCompatibilityChanges;
    }

    public static enum ClassPathMode {
        ONE_COMMON_CLASSPATH,
        TWO_SEPARATE_CLASSPATHS;

    }

    public static class OverrideCompatibilityChange {
        private JApiCompatibilityChange compatibilityChange;
        private boolean binaryCompatible;
        private boolean sourceCompatible;
        private JApiSemanticVersionLevel semanticVersionLevel;

        public OverrideCompatibilityChange(JApiCompatibilityChange compatibilityChange, boolean binaryCompatible, boolean sourceCompatible, JApiSemanticVersionLevel semanticVersionLevel) {
            this.compatibilityChange = compatibilityChange;
            this.binaryCompatible = binaryCompatible;
            this.sourceCompatible = sourceCompatible;
            this.semanticVersionLevel = semanticVersionLevel;
        }

        public JApiCompatibilityChange getCompatibilityChange() {
            return this.compatibilityChange;
        }

        public boolean isBinaryCompatible() {
            return this.binaryCompatible;
        }

        public boolean isSourceCompatible() {
            return this.sourceCompatible;
        }

        public JApiSemanticVersionLevel getSemanticVersionLevel() {
            return this.semanticVersionLevel;
        }
    }
}

