/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms;

import com.github.qcloudsms.SmsBase;
import com.github.qcloudsms.SmsSenderUtil;
import com.github.qcloudsms.VoiceFileUploaderResult;
import com.github.qcloudsms.httpclient.DefaultHTTPClient;
import com.github.qcloudsms.httpclient.HTTPClient;
import com.github.qcloudsms.httpclient.HTTPException;
import com.github.qcloudsms.httpclient.HTTPMethod;
import com.github.qcloudsms.httpclient.HTTPRequest;
import com.github.qcloudsms.httpclient.HTTPResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.json.JSONException;

public class VoiceFileUploader
extends SmsBase {
    private String url = "https://cloud.tim.qq.com/v5/tlsvoicesvr/uploadvoicefile";

    public VoiceFileUploader(int appid, String appkey) {
        super(appid, appkey, new DefaultHTTPClient());
    }

    public VoiceFileUploader(int appid, String appkey, HTTPClient httpclient) {
        super(appid, appkey, httpclient);
    }

    public VoiceFileUploaderResult upload(byte[] fileContent, ContentType contentType) throws HTTPException, JSONException, IOException {
        long random = SmsSenderUtil.getRandom();
        long now = SmsSenderUtil.getCurrentTime();
        String fileSha1Sum = SmsSenderUtil.sha1sum(fileContent);
        String auth = SmsSenderUtil.calculateAuth(this.appkey, random, now, fileSha1Sum);
        String type = contentType == ContentType.WAV ? "audio/wav" : "audio/mpeg";
        HTTPRequest req = new HTTPRequest(HTTPMethod.POST, this.url).addHeader("Content-Type", type).addHeader("x-content-sha1", fileSha1Sum).addHeader("Authorization", auth).addQueryParameter("sdkappid", this.appid).addQueryParameter("random", random).addQueryParameter("time", now).setConnectionTimeout(60000).setRequestTimeout(60000).setBody(new String(fileContent, StandardCharsets.ISO_8859_1)).setBodyCharset(StandardCharsets.ISO_8859_1);
        try {
            HTTPResponse res = this.httpclient.fetch(req);
            this.handleError(res);
            return new VoiceFileUploaderResult().parseFromHTTPResponse(res);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("API url has been modified, current url: " + this.url);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        WAV,
        MP3;

    }
}

