/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms.httpclient;

import com.github.qcloudsms.httpclient.HTTPClient;
import com.github.qcloudsms.httpclient.HTTPRequest;
import com.github.qcloudsms.httpclient.HTTPResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ProxyHTTPClient
implements HTTPClient {
    private HttpHost proxy;

    public ProxyHTTPClient(String host) {
        this.proxy = new HttpHost(host);
    }

    public ProxyHTTPClient(String host, int port) {
        this.proxy = new HttpHost(host, port);
    }

    public ProxyHTTPClient(String host, int port, String scheme) {
        this.proxy = new HttpHost(host, port, scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPResponse fetch(HTTPRequest request) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(request.url);
        for (Map.Entry<String, String> entry : request.parameters.entrySet()) {
            uriBuilder.addParameter(entry.getKey(), entry.getValue());
        }
        RequestConfig reqConfig = RequestConfig.custom().setSocketTimeout(300000).setConnectTimeout(request.connectTimeout).setConnectionRequestTimeout(request.requestTimeout).setProxy(this.proxy).build();
        RequestBuilder reqBuilder = RequestBuilder.create((String)request.method.name()).setUri(uriBuilder.build()).setEntity((HttpEntity)new ByteArrayEntity(request.body.getBytes(request.bodyCharset))).setConfig(reqConfig);
        for (Map.Entry<String, String> entry : request.headers.entrySet()) {
            reqBuilder.setHeader(entry.getKey(), entry.getValue());
        }
        CloseableHttpClient client = HttpClients.createDefault();
        try {
            HTTPResponse hTTPResponse;
            CloseableHttpResponse response = client.execute(reqBuilder.build());
            try {
                HTTPResponse res = new HTTPResponse().setRequest(request).setStatusCode(response.getStatusLine().getStatusCode()).setReason(response.getStatusLine().getReasonPhrase()).setBody(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
                for (Header header : response.getAllHeaders()) {
                    res.addHeader(header.getName(), header.getValue());
                }
                hTTPResponse = res;
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return hTTPResponse;
        }
        finally {
            client.close();
        }
    }

    public void close() {
    }
}

