/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms;

import com.github.qcloudsms.SmsBase;
import com.github.qcloudsms.SmsSenderUtil;
import com.github.qcloudsms.VoiceFileStatusResult;
import com.github.qcloudsms.httpclient.DefaultHTTPClient;
import com.github.qcloudsms.httpclient.HTTPClient;
import com.github.qcloudsms.httpclient.HTTPException;
import com.github.qcloudsms.httpclient.HTTPMethod;
import com.github.qcloudsms.httpclient.HTTPRequest;
import com.github.qcloudsms.httpclient.HTTPResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import org.json.JSONException;
import org.json.JSONObject;

public class VoiceFileStatus
extends SmsBase {
    private String url = "https://cloud.tim.qq.com/v5/tlsvoicesvr/statusvoicefile";

    public VoiceFileStatus(int appid, String appkey) {
        super(appid, appkey, new DefaultHTTPClient());
    }

    public VoiceFileStatus(int appid, String appkey, HTTPClient httpclient) {
        super(appid, appkey, httpclient);
    }

    public VoiceFileStatusResult get(String fid) throws HTTPException, JSONException, IOException {
        long random = SmsSenderUtil.getRandom();
        long now = SmsSenderUtil.getCurrentTime();
        JSONObject body = new JSONObject().put("fid", (Object)fid).put("sig", (Object)SmsSenderUtil.calculateFStatusSignature(this.appkey, random, now, fid)).put("time", now);
        HTTPRequest req = new HTTPRequest(HTTPMethod.POST, this.url).addHeader("Conetent-Type", "application/json").addQueryParameter("sdkappid", this.appid).addQueryParameter("random", random).setConnectionTimeout(60000).setRequestTimeout(60000).setBody(body.toString());
        try {
            HTTPResponse res = this.httpclient.fetch(req);
            this.handleError(res);
            return new VoiceFileStatusResult().parseFromHTTPResponse(res);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("API url has been modified, current url: " + this.url);
        }
    }
}

