/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.util;

import com.github.pagehelper.Page;
import com.github.pagehelper.cache.Cache;
import com.github.pagehelper.cache.CacheFactory;
import com.github.pagehelper.dialect.Db2Dialect;
import com.github.pagehelper.dialect.HsqldbDialect;
import com.github.pagehelper.dialect.InformixDialect;
import com.github.pagehelper.dialect.MySqlDialect;
import com.github.pagehelper.dialect.OracleDialect;
import com.github.pagehelper.dialect.SqlServer2012Dialect;
import com.github.pagehelper.dialect.SqlServerDialect;
import com.github.pagehelper.util.MetaObjectUtil;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.RowBounds;

public class BaseSqlUtil {
    protected static final ThreadLocal<Page> LOCAL_PAGE = new ThreadLocal();
    protected static Map<String, String> PARAMS = new HashMap<String, String>(5);
    protected static Map<String, Class<?>> dialectAliasMap = new HashMap();
    protected static Boolean hasRequest;
    protected static Class<?> requestClass;
    protected static Method getParameterMap;
    protected Cache<CacheKey, MappedStatement> msCountMap = null;
    protected boolean offsetAsPageNum = false;
    protected boolean rowBoundsWithCount = false;
    protected boolean pageSizeZero = false;
    protected boolean reasonable = false;
    protected boolean supportMethodsArguments = false;

    public static String fromJdbcUrl(String jdbcUrl) {
        for (String dialect : dialectAliasMap.keySet()) {
            if (jdbcUrl.indexOf(":" + dialect.toLowerCase() + ":") == -1) continue;
            return dialect;
        }
        return null;
    }

    public static Class resloveDialectClass(String className) throws Exception {
        if (dialectAliasMap.containsKey(className.toLowerCase())) {
            return dialectAliasMap.get(className.toLowerCase());
        }
        return Class.forName(className);
    }

    public static Boolean getCOUNT() {
        Page page = BaseSqlUtil.getLocalPage();
        if (page != null) {
            return page.getCountSignal();
        }
        return null;
    }

    public static <T> Page<T> getLocalPage() {
        return LOCAL_PAGE.get();
    }

    public static void setLocalPage(Page page) {
        LOCAL_PAGE.set(page);
    }

    public static void clearLocalPage() {
        LOCAL_PAGE.remove();
    }

    public static String getOrderBy() {
        Page page = BaseSqlUtil.getLocalPage();
        if (page != null) {
            String orderBy = page.getOrderBy();
            if (StringUtil.isEmpty(orderBy)) {
                return null;
            }
            return orderBy;
        }
        return null;
    }

    public static <T> Page<T> getPageFromObject(Object params) {
        Object pageSizeZero;
        Object reasonable;
        int pageSize;
        int pageNum;
        MetaObject paramsObject = null;
        if (params == null) {
            throw new NullPointerException("\u65e0\u6cd5\u83b7\u53d6\u5206\u9875\u67e5\u8be2\u53c2\u6570!");
        }
        if (hasRequest.booleanValue() && requestClass.isAssignableFrom(params.getClass())) {
            try {
                paramsObject = MetaObjectUtil.forObject(getParameterMap.invoke(params, new Object[0]));
            }
            catch (Exception exception) {}
        } else {
            paramsObject = MetaObjectUtil.forObject(params);
        }
        if (paramsObject == null) {
            throw new NullPointerException("\u5206\u9875\u67e5\u8be2\u53c2\u6570\u5904\u7406\u5931\u8d25!");
        }
        Object orderBy = BaseSqlUtil.getParamValue(paramsObject, "orderBy", false);
        boolean hasOrderBy = false;
        if (orderBy != null && orderBy.toString().length() > 0) {
            hasOrderBy = true;
        }
        try {
            Object _pageNum = BaseSqlUtil.getParamValue(paramsObject, "pageNum", !hasOrderBy);
            Object _pageSize = BaseSqlUtil.getParamValue(paramsObject, "pageSize", !hasOrderBy);
            if (_pageNum == null || _pageSize == null) {
                Page page = new Page();
                page.setOrderBy(orderBy.toString());
                page.setOrderByOnly(true);
                return page;
            }
            pageNum = Integer.parseInt(String.valueOf(_pageNum));
            pageSize = Integer.parseInt(String.valueOf(_pageSize));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57\u7c7b\u578b!");
        }
        Page page = new Page(pageNum, pageSize);
        Object _count = BaseSqlUtil.getParamValue(paramsObject, "count", false);
        if (_count != null) {
            page.setCount(Boolean.valueOf(String.valueOf(_count)));
        }
        if (hasOrderBy) {
            page.setOrderBy(orderBy.toString());
        }
        if ((reasonable = BaseSqlUtil.getParamValue(paramsObject, "reasonable", false)) != null) {
            page.setReasonable(Boolean.valueOf(String.valueOf(reasonable)));
        }
        if ((pageSizeZero = BaseSqlUtil.getParamValue(paramsObject, "pageSizeZero", false)) != null) {
            page.setPageSizeZero(Boolean.valueOf(String.valueOf(pageSizeZero)));
        }
        return page;
    }

    public static Object getParamValue(MetaObject paramsObject, String paramName, boolean required) {
        Object value = null;
        if (paramsObject.hasGetter(PARAMS.get(paramName))) {
            value = paramsObject.getValue(PARAMS.get(paramName));
        }
        if (value != null && value.getClass().isArray()) {
            Object[] values = (Object[])value;
            value = values.length == 0 ? null : values[0];
        }
        if (required && value == null) {
            throw new RuntimeException("\u5206\u9875\u67e5\u8be2\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570:" + PARAMS.get(paramName));
        }
        return value;
    }

    public void setParams(String params) {
        PARAMS.put("pageNum", "pageNum");
        PARAMS.put("pageSize", "pageSize");
        PARAMS.put("count", "countSql");
        PARAMS.put("orderBy", "orderBy");
        PARAMS.put("reasonable", "reasonable");
        PARAMS.put("pageSizeZero", "pageSizeZero");
        if (StringUtil.isNotEmpty(params)) {
            String[] ps;
            for (String s : ps = params.split("[;|,|&]")) {
                String[] ss = s.split("[=|:]");
                if (ss.length != 2) continue;
                PARAMS.put(ss[0], ss[1]);
            }
        }
    }

    public Page getPage(Object parameterObject, RowBounds rowBounds) {
        Page<Object> page = BaseSqlUtil.getLocalPage();
        if (page == null || page.isOrderByOnly()) {
            Page oldPage = page;
            if ((rowBounds == null || rowBounds == RowBounds.DEFAULT) && page != null) {
                return oldPage;
            }
            if (rowBounds != RowBounds.DEFAULT) {
                if (this.offsetAsPageNum) {
                    page = new Page(rowBounds.getOffset(), rowBounds.getLimit(), this.rowBoundsWithCount);
                } else {
                    page = new Page(new int[]{rowBounds.getOffset(), rowBounds.getLimit()}, this.rowBoundsWithCount);
                    page.setReasonable(false);
                }
            } else {
                try {
                    page = BaseSqlUtil.getPageFromObject(parameterObject);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (oldPage != null) {
                page.setOrderBy(oldPage.getOrderBy());
            }
            BaseSqlUtil.setLocalPage(page);
        }
        if (page.getReasonable() == null) {
            page.setReasonable(this.reasonable);
        }
        if (page.getPageSizeZero() == null) {
            page.setPageSizeZero(this.pageSizeZero);
        }
        return page;
    }

    public void setOffsetAsPageNum(boolean offsetAsPageNum) {
        this.offsetAsPageNum = offsetAsPageNum;
    }

    public void setRowBoundsWithCount(boolean rowBoundsWithCount) {
        this.rowBoundsWithCount = rowBoundsWithCount;
    }

    public void setPageSizeZero(boolean pageSizeZero) {
        this.pageSizeZero = pageSizeZero;
    }

    public void setReasonable(boolean reasonable) {
        this.reasonable = reasonable;
    }

    public void setSupportMethodsArguments(boolean supportMethodsArguments) {
        this.supportMethodsArguments = supportMethodsArguments;
    }

    public void setProperties(Properties p) {
        this.msCountMap = CacheFactory.createSqlCache(p.getProperty("msCountCache"), "ms", p);
        String offsetAsPageNum = p.getProperty("offsetAsPageNum");
        this.offsetAsPageNum = Boolean.parseBoolean(offsetAsPageNum);
        String rowBoundsWithCount = p.getProperty("rowBoundsWithCount");
        this.rowBoundsWithCount = Boolean.parseBoolean(rowBoundsWithCount);
        String pageSizeZero = p.getProperty("pageSizeZero");
        this.pageSizeZero = Boolean.parseBoolean(pageSizeZero);
        String reasonable = p.getProperty("reasonable");
        this.reasonable = Boolean.parseBoolean(reasonable);
        String supportMethodsArguments = p.getProperty("supportMethodsArguments");
        this.supportMethodsArguments = Boolean.parseBoolean(supportMethodsArguments);
        this.setParams(p.getProperty("params"));
    }

    static {
        try {
            requestClass = Class.forName("javax.servlet.ServletRequest");
            getParameterMap = requestClass.getMethod("getParameterMap", new Class[0]);
            hasRequest = true;
        }
        catch (Throwable e) {
            hasRequest = false;
        }
        dialectAliasMap.put("hsqldb", HsqldbDialect.class);
        dialectAliasMap.put("h2", HsqldbDialect.class);
        dialectAliasMap.put("postgresql", HsqldbDialect.class);
        dialectAliasMap.put("mysql", MySqlDialect.class);
        dialectAliasMap.put("mariadb", MySqlDialect.class);
        dialectAliasMap.put("sqlite", MySqlDialect.class);
        dialectAliasMap.put("oracle", OracleDialect.class);
        dialectAliasMap.put("db2", Db2Dialect.class);
        dialectAliasMap.put("informix", InformixDialect.class);
        dialectAliasMap.put("sqlserver", SqlServerDialect.class);
        dialectAliasMap.put("sqlserver2012", SqlServer2012Dialect.class);
        dialectAliasMap.put("derby", SqlServer2012Dialect.class);
    }
}

