/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.cache;

import com.github.pagehelper.cache.Cache;
import com.github.pagehelper.cache.GuavaCache;
import com.github.pagehelper.cache.SimpleCache;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Constructor;
import java.util.Properties;

public abstract class CacheFactory {
    public static <K, V> Cache<K, V> createSqlCache(String sqlCacheClass, String prefix, Properties properties) {
        if (StringUtil.isEmpty(sqlCacheClass)) {
            try {
                Class.forName("com.google.common.cache.Cache");
                return new GuavaCache(properties, prefix);
            }
            catch (Throwable t) {
                return new SimpleCache(properties, prefix);
            }
        }
        try {
            Class<?> clazz = Class.forName(sqlCacheClass);
            try {
                Constructor<?> constructor = clazz.getConstructor(Properties.class, String.class);
                return (Cache)constructor.newInstance(properties, prefix);
            }
            catch (Exception e) {
                return (Cache)clazz.newInstance();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("\u521b\u5efa\u81ea\u5b9a\u4e49 Sql \u7f13\u5b58[" + sqlCacheClass + "]\u5931\u8d25", t);
        }
    }
}

