/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper;

import com.github.pagehelper.ISelect;
import com.github.pagehelper.Page;
import com.github.pagehelper.util.SqlUtil;

public abstract class BasePageHelper {
    public static long count(ISelect select) {
        Page page = BasePageHelper.startPage(1, -1, true);
        select.doSelect();
        return page.getTotal();
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize) {
        return BasePageHelper.startPage(pageNum, pageSize, true);
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize, boolean count) {
        return BasePageHelper.startPage(pageNum, pageSize, count, null);
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize, String orderBy) {
        Page<E> page = BasePageHelper.startPage(pageNum, pageSize);
        page.setOrderBy(orderBy);
        return page;
    }

    public static <E> Page<E> offsetPage(int offset, int limit) {
        return BasePageHelper.offsetPage(offset, limit, true);
    }

    public static <E> Page<E> offsetPage(int offset, int limit, boolean count) {
        Page page = new Page(new int[]{offset, limit}, count);
        Page oldPage = SqlUtil.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        SqlUtil.setLocalPage(page);
        return page;
    }

    public static <E> Page<E> offsetPage(int offset, int limit, String orderBy) {
        Page<E> page = BasePageHelper.offsetPage(offset, limit);
        page.setOrderBy(orderBy);
        return page;
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize, boolean count, Boolean reasonable) {
        return BasePageHelper.startPage(pageNum, pageSize, count, reasonable, null);
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize, boolean count, Boolean reasonable, Boolean pageSizeZero) {
        Page page = new Page(pageNum, pageSize, count);
        page.setReasonable(reasonable);
        page.setPageSizeZero(pageSizeZero);
        Page oldPage = SqlUtil.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        SqlUtil.setLocalPage(page);
        return page;
    }

    public static <E> Page<E> startPage(Object params) {
        Page page = SqlUtil.getPageFromObject(params);
        Page oldPage = SqlUtil.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        SqlUtil.setLocalPage(page);
        return page;
    }

    public static void orderBy(String orderBy) {
        Page<Object> page = SqlUtil.getLocalPage();
        if (page != null) {
            page.setOrderBy(orderBy);
        } else {
            page = new Page();
            page.setOrderBy(orderBy);
            page.setOrderByOnly(true);
            SqlUtil.setLocalPage(page);
        }
    }

    public static void clearPage() {
        SqlUtil.clearLocalPage();
    }
}

