/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.dialect;

import com.github.pagehelper.Constant;
import com.github.pagehelper.Dialect;
import com.github.pagehelper.Page;
import com.github.pagehelper.parser.CountSqlParser;
import com.github.pagehelper.parser.OrderByParser;
import com.github.pagehelper.util.MetaObjectUtil;
import com.github.pagehelper.util.SqlUtil;
import com.github.pagehelper.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.RowBounds;

public abstract class AbstractDialect
implements Dialect,
Constant {
    protected CountSqlParser countSqlParser = new CountSqlParser();
    protected SqlUtil sqlUtil;

    public AbstractDialect(SqlUtil sqlUtil) {
        this.sqlUtil = sqlUtil;
    }

    @Override
    public boolean skip(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        Page page = this.sqlUtil.getPage(parameterObject, rowBounds);
        if (page == null) {
            return true;
        }
        return page.getPageSizeZero() != null && page.getPageSizeZero() != false && page.getPageSize() == 0;
    }

    @Override
    public boolean beforeCount(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        Page page = SqlUtil.getLocalPage();
        return !page.isOrderByOnly() && page.isCount();
    }

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        return this.countSqlParser.getSmartCountSql(boundSql.getSql());
    }

    @Override
    public void afterCount(long count, Object parameterObject, RowBounds rowBounds) {
        Page page = SqlUtil.getLocalPage();
        page.setTotal(count);
    }

    @Override
    public Object processParameterObject(MappedStatement ms, Object parameterObject, BoundSql boundSql, CacheKey pageKey) {
        Page page = SqlUtil.getLocalPage();
        if (page.isOrderByOnly()) {
            return parameterObject;
        }
        HashMap<String, Object> paramMap = null;
        if (parameterObject == null) {
            paramMap = new HashMap<String, Object>();
        } else if (parameterObject instanceof Map) {
            paramMap = new HashMap();
            paramMap.putAll((Map)parameterObject);
        } else {
            paramMap = new HashMap();
            boolean hasTypeHandler = ms.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(parameterObject.getClass());
            MetaObject metaObject = MetaObjectUtil.forObject(parameterObject);
            if (!hasTypeHandler) {
                for (String name : metaObject.getGetterNames()) {
                    paramMap.put(name, metaObject.getValue(name));
                }
            }
            if (boundSql.getParameterMappings() != null && boundSql.getParameterMappings().size() > 0) {
                for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                    String name = parameterMapping.getProperty();
                    if (name.equals("First_PageHelper") || name.equals("Second_PageHelper") || paramMap.get(name) != null || !hasTypeHandler && !parameterMapping.getJavaType().equals(parameterObject.getClass())) continue;
                    paramMap.put(name, parameterObject);
                    break;
                }
            }
        }
        return this.processPageParameter(ms, paramMap, page, boundSql, pageKey);
    }

    public abstract Object processPageParameter(MappedStatement var1, Map<String, Object> var2, Page var3, BoundSql var4, CacheKey var5);

    @Override
    public boolean beforePage(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        Page page = SqlUtil.getLocalPage();
        if (page.isOrderByOnly()) {
            return true;
        }
        return page.getPageSize() > 0 && (rowBounds == RowBounds.DEFAULT && page.getPageNum() > 0 || rowBounds != RowBounds.DEFAULT);
    }

    @Override
    public String getPageSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey pageKey) {
        String sql = boundSql.getSql();
        Page page = SqlUtil.getLocalPage();
        String orderBy = page.getOrderBy();
        if (StringUtil.isNotEmpty(orderBy)) {
            pageKey.update((Object)orderBy);
            sql = OrderByParser.converToOrderBySql(sql, orderBy);
        }
        if (page.isOrderByOnly()) {
            return sql;
        }
        return this.getPageSql(sql, page, rowBounds, pageKey);
    }

    public abstract String getPageSql(String var1, Page var2, RowBounds var3, CacheKey var4);

    @Override
    public Object afterPage(List pageList, Object parameterObject, RowBounds rowBounds) {
        Page page = SqlUtil.getLocalPage();
        if (page == null) {
            return pageList;
        }
        page.addAll(pageList);
        if (!page.isCount()) {
            page.setTotal(-1L);
        } else if (page.isOrderByOnly()) {
            page.setTotal(pageList.size());
        } else if (page.getPageSizeZero() != null && page.getPageSizeZero().booleanValue() && page.getPageSize() == 0) {
            page.setTotal(pageList.size());
        }
        return page;
    }

    @Override
    public void setProperties(Properties properties) {
    }
}

