/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper;

import com.github.pagehelper.Constant;
import com.github.pagehelper.Dialect;
import com.github.pagehelper.MSUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.parser.Parser;
import com.github.pagehelper.parser.impl.AbstractParser;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.RowBounds;

public class SqlUtil
implements Constant {
    private static final ThreadLocal<Page> LOCAL_PAGE = new ThreadLocal();
    private boolean offsetAsPageNum = false;
    private boolean rowBoundsWithCount = false;
    private boolean pageSizeZero = false;
    private boolean reasonable = false;
    private static Map<String, String> PARAMS = new HashMap<String, String>(5);
    private static Boolean hasRequest;
    private static Class<?> requestClass;
    private static Method getParameterMap;
    private Parser parser;
    private MSUtils msUtils;
    private Dialect dialect;

    public SqlUtil(String strDialect) {
        if (strDialect == null || "".equals(strDialect)) {
            throw new IllegalArgumentException("Mybatis\u5206\u9875\u63d2\u4ef6\u65e0\u6cd5\u83b7\u53d6dialect\u53c2\u6570!");
        }
        this.dialect = Dialect.of(strDialect);
        this.parser = AbstractParser.newParser(this.dialect);
        this.msUtils = new MSUtils(this.parser);
    }

    public static void setLocalPage(Page page) {
        LOCAL_PAGE.set(page);
    }

    public static Page getLocalPage() {
        return LOCAL_PAGE.get();
    }

    public static void clearLocalPage() {
        LOCAL_PAGE.remove();
    }

    public Page getPage(Object params) {
        Page page = SqlUtil.getLocalPage();
        if (page == null) {
            if (params instanceof RowBounds) {
                RowBounds rowBounds = (RowBounds)params;
                if (this.offsetAsPageNum) {
                    page = new Page(rowBounds.getOffset(), rowBounds.getLimit(), this.rowBoundsWithCount);
                } else {
                    page = new Page(rowBounds, this.rowBoundsWithCount);
                    page.setReasonable(false);
                }
            } else {
                page = SqlUtil.getPageFromObject(params);
            }
            SqlUtil.setLocalPage(page);
        }
        if (page.getReasonable() == null) {
            page.setReasonable(this.reasonable);
        }
        if (page.getPageSizeZero() == null) {
            page.setPageSizeZero(this.pageSizeZero);
        }
        return page;
    }

    public static Page getPageFromObject(Object params) {
        Object pageSizeZero;
        int pageSize;
        int pageNum;
        MetaObject paramsObject = null;
        if (params == null) {
            throw new NullPointerException("\u5206\u9875\u67e5\u8be2\u53c2\u6570params\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (hasRequest.booleanValue() && requestClass.isAssignableFrom(params.getClass())) {
            try {
                paramsObject = SystemMetaObject.forObject((Object)getParameterMap.invoke(params, new Object[0]));
            }
            catch (Exception e) {}
        } else {
            paramsObject = SystemMetaObject.forObject((Object)params);
        }
        if (paramsObject == null) {
            throw new NullPointerException("\u5206\u9875\u67e5\u8be2\u53c2\u6570params\u5904\u7406\u5931\u8d25!");
        }
        try {
            pageNum = Integer.parseInt(String.valueOf(SqlUtil.getParamValue(paramsObject, "pageNum", true)));
            pageSize = Integer.parseInt(String.valueOf(SqlUtil.getParamValue(paramsObject, "pageSize", true)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57\u7c7b\u578b!");
        }
        Object _count = SqlUtil.getParamValue(paramsObject, "count", false);
        boolean count = true;
        if (_count != null) {
            count = Boolean.valueOf(String.valueOf(_count));
        }
        Page page = new Page(pageNum, pageSize, count);
        Object reasonable = SqlUtil.getParamValue(paramsObject, "reasonable", false);
        if (reasonable != null) {
            page.setReasonable(Boolean.valueOf(String.valueOf(reasonable)));
        }
        if ((pageSizeZero = SqlUtil.getParamValue(paramsObject, "pageSizeZero", false)) != null) {
            page.setPageSizeZero(Boolean.valueOf(String.valueOf(pageSizeZero)));
        }
        return page;
    }

    public static Object getParamValue(MetaObject paramsObject, String paramName, boolean required) {
        Object value = null;
        if (paramsObject.hasGetter(PARAMS.get(paramName))) {
            value = paramsObject.getValue(PARAMS.get(paramName));
        }
        if (required && value == null) {
            throw new RuntimeException("\u5206\u9875\u67e5\u8be2\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570:" + PARAMS.get(paramName));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processPage(Invocation invocation) throws Throwable {
        try {
            Object result;
            Object object = result = this._processPage(invocation);
            return object;
        }
        finally {
            SqlUtil.clearLocalPage();
        }
    }

    private Object _processPage(Invocation invocation) throws Throwable {
        Object result;
        Object[] args = invocation.getArgs();
        RowBounds rowBounds = (RowBounds)args[2];
        if (SqlUtil.getLocalPage() == null && rowBounds == RowBounds.DEFAULT) {
            return invocation.proceed();
        }
        args[2] = RowBounds.DEFAULT;
        Page page = this.getPage(rowBounds);
        if (page.getPageSizeZero() != null && page.getPageSizeZero().booleanValue() && page.getPageSize() == 0) {
            Object result2 = invocation.proceed();
            page.addAll((List)result2);
            page.setPageNum(1);
            page.setPageSize(page.size());
            page.setTotal(page.size());
            return page;
        }
        MappedStatement ms = (MappedStatement)args[0];
        SqlSource sqlSource = ms.getSqlSource();
        if (page.isCount()) {
            this.msUtils.processCountMappedStatement(ms, sqlSource, args);
            result = invocation.proceed();
            page.setTotal(((Integer)((List)result).get(0)).intValue());
            if (page.getTotal() == 0L) {
                return page;
            }
        }
        if (page.getPageSize() > 0 && (rowBounds == RowBounds.DEFAULT && page.getPageNum() > 0 || rowBounds != RowBounds.DEFAULT)) {
            this.msUtils.processPageMappedStatement(ms, sqlSource, page, args);
            result = invocation.proceed();
            page.addAll((List)result);
        }
        return page;
    }

    public void setProperties(Properties p) {
        String offsetAsPageNum = p.getProperty("offsetAsPageNum");
        this.offsetAsPageNum = Boolean.parseBoolean(offsetAsPageNum);
        String rowBoundsWithCount = p.getProperty("rowBoundsWithCount");
        this.rowBoundsWithCount = Boolean.parseBoolean(rowBoundsWithCount);
        String pageSizeZero = p.getProperty("pageSizeZero");
        this.pageSizeZero = Boolean.parseBoolean(pageSizeZero);
        String reasonable = p.getProperty("reasonable");
        this.reasonable = Boolean.parseBoolean(reasonable);
        PARAMS.put("pageNum", "pageNum");
        PARAMS.put("pageSize", "pageSize");
        PARAMS.put("count", "countSql");
        PARAMS.put("reasonable", "reasonable");
        PARAMS.put("pageSizeZero", "pageSizeZero");
        String params = p.getProperty("params");
        if (params != null && params.length() > 0) {
            String[] ps;
            for (String s : ps = params.split("[;|,|&]")) {
                String[] ss = s.split("[=|:]");
                if (ss.length != 2) continue;
                PARAMS.put(ss[0], ss[1]);
            }
        }
    }

    public static void testSql(String dialect, String originalSql) {
        SqlUtil.testSql(Dialect.of(dialect), originalSql);
    }

    public static void testSql(Dialect dialect, String originalSql) {
        Parser parser = AbstractParser.newParser(dialect);
        if (dialect == Dialect.sqlserver) {
            SqlUtil.setLocalPage(new Page(1, 10));
        }
        String countSql = parser.getCountSql(originalSql);
        System.out.println(countSql);
        String pageSql = parser.getPageSql(originalSql);
        System.out.println(pageSql);
        if (dialect == Dialect.sqlserver) {
            SqlUtil.clearLocalPage();
        }
    }

    static {
        try {
            requestClass = Class.forName("javax.servlet.ServletRequest");
            getParameterMap = requestClass.getMethod("getParameterMap", new Class[0]);
            hasRequest = true;
        }
        catch (Exception e) {
            hasRequest = false;
        }
    }
}

