/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper;

import com.github.pagehelper.Page;
import com.github.pagehelper.SqlUtil;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PageHelper
implements Interceptor {
    private SqlUtil sqlUtil;

    public static Page startPage(int pageNum, int pageSize) {
        return PageHelper.startPage(pageNum, pageSize, true);
    }

    public static Page startPage(int pageNum, int pageSize, boolean count) {
        return PageHelper.startPage(pageNum, pageSize, count, null);
    }

    public static Page startPage(int pageNum, int pageSize, boolean count, Boolean reasonable) {
        return PageHelper.startPage(pageNum, pageSize, count, reasonable, null);
    }

    public static Page startPage(int pageNum, int pageSize, boolean count, Boolean reasonable, Boolean pageSizeZero) {
        Page page = new Page(pageNum, pageSize, count);
        page.setReasonable(reasonable);
        page.setPageSizeZero(pageSizeZero);
        SqlUtil.setLocalPage(page);
        return page;
    }

    public static Page startPage(Object params) {
        Page page = SqlUtil.getPageFromObject(params);
        SqlUtil.setLocalPage(page);
        return page;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        return this.sqlUtil.processPage(invocation);
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties p) {
        try {
            Class.forName("org.apache.ibatis.scripting.xmltags.SqlNode");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u60a8\u4f7f\u7528\u7684MyBatis\u7248\u672c\u592a\u4f4e\uff0cMyBatis\u5206\u9875\u63d2\u4ef6PageHelper\u652f\u6301MyBatis3.2.0\u53ca\u4ee5\u4e0a\u7248\u672c!");
        }
        String dialect = p.getProperty("dialect");
        this.sqlUtil = new SqlUtil(dialect);
        this.sqlUtil.setProperties(p);
    }
}

