/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper;

import com.github.pagehelper.Page;
import com.github.pagehelper.SqlParser;
import com.github.pagehelper.SqlServer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;

public class SqlUtil {
    private static final ThreadLocal<Page> LOCAL_PAGE = new ThreadLocal();
    private boolean offsetAsPageNum = false;
    private boolean rowBoundsWithCount = false;
    private boolean pageSizeZero = false;
    private boolean reasonable = false;
    private static Map<String, String> PARAMS = new HashMap<String, String>(5);
    private static Boolean hasRequest;
    private static Class<?> requestClass;
    private static Method getParameterMap;
    private static final List<ResultMapping> EMPTY_RESULTMAPPING;
    private static final String SUFFIX_PAGE = "_PageHelper";
    private static final String SUFFIX_COUNT = "_PageHelper_Count";
    private static final String PAGEPARAMETER_FIRST = "First_PageHelper";
    private static final String PAGEPARAMETER_SECOND = "Second_PageHelper";
    private static final String PROVIDER_OBJECT = "_provider_object";
    private static final String ORIGINAL_PARAMETER_OBJECT = "_ORIGINAL_PARAMETER_OBJECT";
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY;
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY;
    private static final SqlParser sqlParser;
    private Parser parser;
    private Dialect dialect;

    private static MetaObject forObject(Object object) {
        return MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY);
    }

    public static void setLocalPage(Page page) {
        LOCAL_PAGE.set(page);
    }

    private static Page getLocalPage() {
        return LOCAL_PAGE.get();
    }

    private static void clearLocalPage() {
        LOCAL_PAGE.remove();
    }

    public Page getPage(Object params) {
        Page page = SqlUtil.getLocalPage();
        if (page == null) {
            if (params instanceof RowBounds) {
                RowBounds rowBounds = (RowBounds)params;
                page = this.offsetAsPageNum ? new Page(rowBounds.getOffset(), rowBounds.getLimit(), this.rowBoundsWithCount) : new Page(rowBounds, this.rowBoundsWithCount);
            } else {
                page = SqlUtil.getPageFromObject(params);
            }
            SqlUtil.setLocalPage(page);
        }
        if (page.getReasonable() == null) {
            page.setReasonable(this.reasonable);
        }
        if (page.getPageSizeZero() == null) {
            page.setPageSizeZero(this.pageSizeZero);
        }
        return page;
    }

    public static Page getPageFromObject(Object params) {
        Object pageSizeZero;
        int pageSize;
        int pageNum;
        MetaObject paramsObject = null;
        if (params == null) {
            throw new NullPointerException("\u5206\u9875\u67e5\u8be2\u53c2\u6570params\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (hasRequest.booleanValue() && requestClass.isAssignableFrom(params.getClass())) {
            try {
                paramsObject = SqlUtil.forObject(getParameterMap.invoke(params, new Object[0]));
            }
            catch (Exception e) {}
        } else {
            paramsObject = SqlUtil.forObject(params);
        }
        if (paramsObject == null) {
            throw new NullPointerException("\u5206\u9875\u67e5\u8be2\u53c2\u6570params\u5904\u7406\u5931\u8d25!");
        }
        try {
            pageNum = Integer.parseInt(String.valueOf(SqlUtil.getParamValue(paramsObject, "pageNum", true)));
            pageSize = Integer.parseInt(String.valueOf(SqlUtil.getParamValue(paramsObject, "pageSize", true)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57\u7c7b\u578b!");
        }
        Object _count = SqlUtil.getParamValue(paramsObject, "count", false);
        boolean count = true;
        if (_count != null) {
            count = Boolean.valueOf(String.valueOf(_count));
        }
        Page page = new Page(pageNum, pageSize, count);
        Object reasonable = SqlUtil.getParamValue(paramsObject, "reasonable", false);
        if (reasonable != null) {
            page.setReasonable(Boolean.valueOf(String.valueOf(reasonable)));
        }
        if ((pageSizeZero = SqlUtil.getParamValue(paramsObject, "pageSizeZero", false)) != null) {
            page.setPageSizeZero(Boolean.valueOf(String.valueOf(pageSizeZero)));
        }
        return page;
    }

    public static Object getParamValue(MetaObject paramsObject, String paramName, boolean required) {
        Object value = null;
        if (paramsObject.hasGetter(PARAMS.get(paramName))) {
            value = paramsObject.getValue(PARAMS.get(paramName));
        }
        if (required && value == null) {
            throw new RuntimeException("\u5206\u9875\u67e5\u8be2\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570:" + PARAMS.get(paramName));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processPage(Invocation invocation) throws Throwable {
        try {
            Object result = this._processPage(invocation);
            SqlUtil.clearLocalPage();
            Object object = result;
            return object;
        }
        finally {
            SqlUtil.clearLocalPage();
        }
    }

    private Object _processPage(Invocation invocation) throws Throwable {
        Object result;
        Object[] args = invocation.getArgs();
        RowBounds rowBounds = (RowBounds)args[2];
        if (SqlUtil.getLocalPage() == null && rowBounds == RowBounds.DEFAULT) {
            return invocation.proceed();
        }
        MappedStatement ms = (MappedStatement)args[0];
        args[2] = RowBounds.DEFAULT;
        Page page = this.getPage(rowBounds);
        if (page.getPageSizeZero() != null && page.getPageSizeZero().booleanValue() && page.getPageSize() == 0) {
            Object result2 = invocation.proceed();
            page.addAll((List)result2);
            page.setPageNum(1);
            page.setPageSize(page.size());
            page.setTotal(page.size());
            return page;
        }
        SqlSource sqlSource = ((MappedStatement)args[0]).getSqlSource();
        if (page.isCount()) {
            this.processCountMappedStatement(ms, sqlSource, args);
            result = invocation.proceed();
            page.setTotal(((Integer)((List)result).get(0)).intValue());
            if (page.getTotal() == 0L) {
                return page;
            }
        }
        if (page.getPageSize() > 0 && (rowBounds == RowBounds.DEFAULT && page.getPageNum() > 0 || rowBounds != RowBounds.DEFAULT)) {
            this.processPageMappedStatement(ms, sqlSource, page, args);
            result = invocation.proceed();
            page.addAll((List)result);
        }
        return page;
    }

    public void setProperties(Properties p) {
        String offsetAsPageNum = p.getProperty("offsetAsPageNum");
        this.offsetAsPageNum = Boolean.parseBoolean(offsetAsPageNum);
        String rowBoundsWithCount = p.getProperty("rowBoundsWithCount");
        this.rowBoundsWithCount = Boolean.parseBoolean(rowBoundsWithCount);
        String pageSizeZero = p.getProperty("pageSizeZero");
        this.pageSizeZero = Boolean.parseBoolean(pageSizeZero);
        String reasonable = p.getProperty("reasonable");
        this.reasonable = Boolean.parseBoolean(reasonable);
        PARAMS.put("pageNum", "pageNum");
        PARAMS.put("pageSize", "pageSize");
        PARAMS.put("count", "countSql");
        PARAMS.put("reasonable", "reasonable");
        PARAMS.put("pageSizeZero", "pageSizeZero");
        String params = p.getProperty("params");
        if (params != null && params.length() > 0) {
            String[] ps;
            for (String s : ps = params.split("[;|,|&]")) {
                String[] ss = s.split("[=|:]");
                if (ss.length != 2) continue;
                PARAMS.put(ss[0], ss[1]);
            }
        }
    }

    public SqlUtil(String strDialect) {
        if (strDialect == null || "".equals(strDialect)) {
            throw new IllegalArgumentException("Mybatis\u5206\u9875\u63d2\u4ef6\u65e0\u6cd5\u83b7\u53d6dialect\u53c2\u6570!");
        }
        try {
            this.dialect = Dialect.valueOf(strDialect);
            this.parser = SimpleParser.newParser(this.dialect);
        }
        catch (IllegalArgumentException e) {
            String dialects = null;
            for (Dialect d : Dialect.values()) {
                dialects = dialects == null ? d.toString() : dialects + "," + (Object)((Object)d);
            }
            throw new IllegalArgumentException("Mybatis\u5206\u9875\u63d2\u4ef6dialect\u53c2\u6570\u503c\u9519\u8bef\uff0c\u53ef\u9009\u503c\u4e3a[" + dialects + "]");
        }
    }

    public Map setPageParameter(MappedStatement ms, Object parameterObject, Page page) {
        BoundSql boundSql = ms.getBoundSql(parameterObject);
        return this.parser.setPageParameter(ms, parameterObject, boundSql, page);
    }

    public void processCountMappedStatement(MappedStatement ms, SqlSource sqlSource, Object[] args) {
        args[0] = this.getMappedStatement(ms, sqlSource, args[1], SUFFIX_COUNT);
    }

    public void processPageMappedStatement(MappedStatement ms, SqlSource sqlSource, Page page, Object[] args) {
        args[0] = this.getMappedStatement(ms, sqlSource, args[1], SUFFIX_PAGE);
        args[1] = this.setPageParameter((MappedStatement)args[0], args[1], page);
    }

    private MappedStatement getMappedStatement(MappedStatement ms, SqlSource sqlSource, Object parameterObject, String suffix) {
        MappedStatement qs = null;
        if (ms.getId().endsWith(SUFFIX_PAGE) || ms.getId().endsWith(SUFFIX_COUNT)) {
            throw new RuntimeException("\u5206\u9875\u63d2\u4ef6\u914d\u7f6e\u9519\u8bef:\u8bf7\u4e0d\u8981\u5728\u7cfb\u7edf\u4e2d\u914d\u7f6e\u591a\u4e2a\u5206\u9875\u63d2\u4ef6(\u4f7f\u7528Spring\u65f6,mybatis-config.xml\u548cSpring<bean>\u914d\u7f6e\u65b9\u5f0f\uff0c\u8bf7\u9009\u62e9\u5176\u4e2d\u4e00\u79cd\uff0c\u4e0d\u8981\u540c\u65f6\u914d\u7f6e\u591a\u4e2a\u5206\u9875\u63d2\u4ef6)\uff01");
        }
        if (this.parser.isSupportedMappedStatementCache()) {
            try {
                qs = ms.getConfiguration().getMappedStatement(ms.getId() + suffix);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (qs == null) {
            qs = this.newMappedStatement(ms, this.getsqlSource(ms, sqlSource, parameterObject, suffix), suffix);
            if (this.parser.isSupportedMappedStatementCache()) {
                try {
                    ms.getConfiguration().addMappedStatement(qs);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return qs;
    }

    private MappedStatement newMappedStatement(MappedStatement ms, SqlSource sqlSource, String suffix) {
        String id = ms.getId() + suffix;
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, sqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        if (suffix == SUFFIX_PAGE) {
            builder.resultMaps(ms.getResultMaps());
        } else {
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            ResultMap resultMap = new ResultMap.Builder(ms.getConfiguration(), id, Integer.TYPE, EMPTY_RESULTMAPPING).build();
            resultMaps.add(resultMap);
            builder.resultMaps(resultMaps);
        }
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public boolean isDynamic(MappedStatement ms) {
        return ms.getSqlSource() instanceof DynamicSqlSource;
    }

    private SqlSource getsqlSource(MappedStatement ms, SqlSource sqlSource, Object parameterObject, String suffix) {
        if (this.isDynamic(ms)) {
            MetaObject msObject = SqlUtil.forObject(ms);
            SqlNode sqlNode = (SqlNode)msObject.getValue("sqlSource.rootSqlNode");
            MixedSqlNode mixedSqlNode = null;
            if (sqlNode instanceof MixedSqlNode) {
                mixedSqlNode = (MixedSqlNode)sqlNode;
            } else {
                ArrayList<SqlNode> contents = new ArrayList<SqlNode>(1);
                contents.add(sqlNode);
                mixedSqlNode = new MixedSqlNode(contents);
            }
            return new MyDynamicSqlSource(ms.getConfiguration(), (SqlNode)mixedSqlNode, suffix == SUFFIX_COUNT);
        }
        if (sqlSource instanceof ProviderSqlSource) {
            return new MyProviderSqlSource(ms.getConfiguration(), (ProviderSqlSource)sqlSource, suffix == SUFFIX_COUNT);
        }
        if (suffix == SUFFIX_PAGE) {
            return this.getPageSqlSource(ms.getConfiguration(), sqlSource, parameterObject);
        }
        return this.getCountSqlSource(ms.getConfiguration(), sqlSource, parameterObject);
    }

    private SqlSource getPageSqlSource(Configuration configuration, SqlSource sqlSource, Object parameterObject) {
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        return new StaticSqlSource(configuration, this.parser.getPageSql(boundSql.getSql()), this.parser.getPageParameterMapping(configuration, boundSql));
    }

    private SqlSource getCountSqlSource(Configuration configuration, SqlSource sqlSource, Object parameterObject) {
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        return new StaticSqlSource(configuration, this.parser.getCountSql(boundSql.getSql()), boundSql.getParameterMappings());
    }

    public static void testSql(String dialet, String originalSql) {
        SqlUtil sqlUtil = new SqlUtil(dialet);
        if (sqlUtil.dialect == Dialect.sqlserver) {
            SqlUtil.setLocalPage(new Page(1, 10));
        }
        String countSql = sqlUtil.parser.getCountSql(originalSql);
        System.out.println(countSql);
        String pageSql = sqlUtil.parser.getPageSql(originalSql);
        System.out.println(pageSql);
    }

    static {
        try {
            requestClass = Class.forName("javax.servlet.ServletRequest");
            getParameterMap = requestClass.getMethod("getParameterMap", new Class[0]);
            hasRequest = true;
        }
        catch (Exception e) {
            hasRequest = false;
        }
        EMPTY_RESULTMAPPING = new ArrayList<ResultMapping>(0);
        DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
        DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
        sqlParser = new SqlParser();
    }

    private class MyProviderSqlSource
    implements SqlSource {
        private Configuration configuration;
        private ProviderSqlSource providerSqlSource;
        private Boolean count;

        private MyProviderSqlSource(Configuration configuration, ProviderSqlSource providerSqlSource, Boolean count) {
            this.configuration = configuration;
            this.providerSqlSource = providerSqlSource;
            this.count = count;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            BoundSql boundSql = null;
            boundSql = parameterObject instanceof Map && ((Map)parameterObject).containsKey(SqlUtil.PROVIDER_OBJECT) ? this.providerSqlSource.getBoundSql(((Map)parameterObject).get(SqlUtil.PROVIDER_OBJECT)) : this.providerSqlSource.getBoundSql(parameterObject);
            if (this.count.booleanValue()) {
                return new BoundSql(this.configuration, SqlUtil.this.parser.getCountSql(boundSql.getSql()), boundSql.getParameterMappings(), parameterObject);
            }
            return new BoundSql(this.configuration, SqlUtil.this.parser.getPageSql(boundSql.getSql()), SqlUtil.this.parser.getPageParameterMapping(this.configuration, boundSql), parameterObject);
        }
    }

    private class MyDynamicSqlSource
    implements SqlSource {
        private Configuration configuration;
        private SqlNode rootSqlNode;
        private Boolean count;

        public MyDynamicSqlSource(Configuration configuration, SqlNode rootSqlNode, Boolean count) {
            this.configuration = configuration;
            this.rootSqlNode = rootSqlNode;
            this.count = count;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            DynamicContext context = parameterObject != null && parameterObject instanceof Map && ((Map)parameterObject).containsKey(SqlUtil.ORIGINAL_PARAMETER_OBJECT) ? new DynamicContext(this.configuration, ((Map)parameterObject).get(SqlUtil.ORIGINAL_PARAMETER_OBJECT)) : new DynamicContext(this.configuration, parameterObject);
            this.rootSqlNode.apply(context);
            SqlSourceBuilder sqlSourceParser = new SqlSourceBuilder(this.configuration);
            Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
            SqlSource sqlSource = sqlSourceParser.parse(context.getSql(), parameterType, context.getBindings());
            sqlSource = this.count != false ? SqlUtil.this.getCountSqlSource(this.configuration, sqlSource, parameterObject) : SqlUtil.this.getPageSqlSource(this.configuration, sqlSource, parameterObject);
            BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
            for (Map.Entry entry : context.getBindings().entrySet()) {
                boundSql.setAdditionalParameter((String)entry.getKey(), entry.getValue());
            }
            return boundSql;
        }
    }

    private static class Db2Parser
    extends SimpleParser {
        private Db2Parser() {
        }

        @Override
        public String getPageSql(String sql) {
            StringBuilder sqlBuilder = new StringBuilder(sql.length() + 120);
            sqlBuilder.append("select * from (select tmp_page.*,rownumber() over() as row_id from ( ");
            sqlBuilder.append(sql);
            sqlBuilder.append(" ) as tmp_page) where row_id between  ? and ?");
            return sqlBuilder.toString();
        }

        @Override
        public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
            Map paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
            paramMap.put(SqlUtil.PAGEPARAMETER_FIRST, page.getStartRow() + 1);
            paramMap.put(SqlUtil.PAGEPARAMETER_SECOND, page.getEndRow());
            return paramMap;
        }
    }

    private static class SqlServerParser
    extends SimpleParser {
        private static final SqlServer pageSql = new SqlServer();

        private SqlServerParser() {
        }

        @Override
        public boolean isSupportedMappedStatementCache() {
            return false;
        }

        @Override
        public List<ParameterMapping> getPageParameterMapping(Configuration configuration, BoundSql boundSql) {
            return boundSql.getParameterMappings();
        }

        @Override
        public String getPageSql(String sql) {
            Page page = SqlUtil.getLocalPage();
            return pageSql.convertToPageSql(sql, page.getStartRow(), page.getPageSize(), page.getOrderBy());
        }

        @Override
        public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
            return super.setPageParameter(ms, parameterObject, boundSql, page);
        }
    }

    private static class PostgreSQLParser
    extends SimpleParser {
        private PostgreSQLParser() {
        }

        @Override
        public String getPageSql(String sql) {
            StringBuilder sqlBuilder = new StringBuilder(sql.length() + 14);
            sqlBuilder.append(sql);
            sqlBuilder.append(" limit ? offset ?");
            return sqlBuilder.toString();
        }

        @Override
        public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
            Map paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
            paramMap.put(SqlUtil.PAGEPARAMETER_FIRST, page.getPageSize());
            paramMap.put(SqlUtil.PAGEPARAMETER_SECOND, page.getStartRow());
            return paramMap;
        }
    }

    private static class HsqldbParser
    extends SimpleParser {
        private HsqldbParser() {
        }

        @Override
        public String getPageSql(String sql) {
            StringBuilder sqlBuilder = new StringBuilder(sql.length() + 20);
            sqlBuilder.append(sql);
            sqlBuilder.append(" limit ? offset ?");
            return sqlBuilder.toString();
        }

        @Override
        public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
            Map paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
            paramMap.put(SqlUtil.PAGEPARAMETER_FIRST, page.getPageSize());
            paramMap.put(SqlUtil.PAGEPARAMETER_SECOND, page.getStartRow());
            return paramMap;
        }
    }

    private static class OracleParser
    extends SimpleParser {
        private OracleParser() {
        }

        @Override
        public String getPageSql(String sql) {
            StringBuilder sqlBuilder = new StringBuilder(sql.length() + 120);
            sqlBuilder.append("select * from ( select tmp_page.*, rownum row_id from ( ");
            sqlBuilder.append(sql);
            sqlBuilder.append(" ) tmp_page where rownum <= ? ) where row_id > ?");
            return sqlBuilder.toString();
        }

        @Override
        public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
            Map paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
            paramMap.put(SqlUtil.PAGEPARAMETER_FIRST, page.getEndRow());
            paramMap.put(SqlUtil.PAGEPARAMETER_SECOND, page.getStartRow());
            return paramMap;
        }
    }

    private static class MysqlParser
    extends SimpleParser {
        private MysqlParser() {
        }

        @Override
        public String getPageSql(String sql) {
            StringBuilder sqlBuilder = new StringBuilder(sql.length() + 14);
            sqlBuilder.append(sql);
            sqlBuilder.append(" limit ?,?");
            return sqlBuilder.toString();
        }

        @Override
        public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
            Map paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
            paramMap.put(SqlUtil.PAGEPARAMETER_FIRST, page.getStartRow());
            paramMap.put(SqlUtil.PAGEPARAMETER_SECOND, page.getPageSize());
            return paramMap;
        }
    }

    public static abstract class SimpleParser
    implements Parser {
        public static Parser newParser(Dialect dialect) {
            SimpleParser parser = null;
            switch (dialect) {
                case mysql: 
                case mariadb: 
                case sqlite: {
                    parser = new MysqlParser();
                    break;
                }
                case oracle: {
                    parser = new OracleParser();
                    break;
                }
                case hsqldb: {
                    parser = new HsqldbParser();
                    break;
                }
                case sqlserver: {
                    parser = new SqlServerParser();
                    break;
                }
                case db2: {
                    parser = new Db2Parser();
                    break;
                }
                default: {
                    parser = new PostgreSQLParser();
                }
            }
            return parser;
        }

        @Override
        public boolean isSupportedMappedStatementCache() {
            return true;
        }

        @Override
        public String getCountSql(String sql) {
            return sqlParser.getSmartCountSql(sql);
        }

        @Override
        public abstract String getPageSql(String var1);

        @Override
        public List<ParameterMapping> getPageParameterMapping(Configuration configuration, BoundSql boundSql) {
            ArrayList<ParameterMapping> newParameterMappings = new ArrayList<ParameterMapping>();
            if (boundSql.getParameterMappings() != null) {
                newParameterMappings.addAll(boundSql.getParameterMappings());
            }
            newParameterMappings.add(new ParameterMapping.Builder(configuration, SqlUtil.PAGEPARAMETER_FIRST, Integer.class).build());
            newParameterMappings.add(new ParameterMapping.Builder(configuration, SqlUtil.PAGEPARAMETER_SECOND, Integer.class).build());
            return newParameterMappings;
        }

        @Override
        public Map setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page page) {
            Map<String, Object> paramMap = null;
            if (parameterObject == null) {
                paramMap = new HashMap<String, Object>();
            } else if (parameterObject instanceof Map) {
                paramMap = (Map)parameterObject;
            } else {
                paramMap = new HashMap();
                boolean hasTypeHandler = ms.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(parameterObject.getClass());
                MetaObject metaObject = SqlUtil.forObject(parameterObject);
                if (ms.getSqlSource() instanceof MyProviderSqlSource) {
                    paramMap.put(SqlUtil.PROVIDER_OBJECT, parameterObject);
                }
                if (!hasTypeHandler) {
                    for (String name : metaObject.getGetterNames()) {
                        paramMap.put(name, metaObject.getValue(name));
                    }
                }
                if (boundSql.getParameterMappings() != null && boundSql.getParameterMappings().size() > 0) {
                    for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                        String name = parameterMapping.getProperty();
                        if (name.equals(SqlUtil.PAGEPARAMETER_FIRST) || name.equals(SqlUtil.PAGEPARAMETER_SECOND) || paramMap.get(name) != null || !hasTypeHandler && !parameterMapping.getJavaType().equals(parameterObject.getClass())) continue;
                        paramMap.put(name, parameterObject);
                        break;
                    }
                }
            }
            paramMap.put(SqlUtil.ORIGINAL_PARAMETER_OBJECT, parameterObject);
            return paramMap;
        }
    }

    public static interface Parser {
        public boolean isSupportedMappedStatementCache();

        public String getCountSql(String var1);

        public String getPageSql(String var1);

        public List<ParameterMapping> getPageParameterMapping(Configuration var1, BoundSql var2);

        public Map setPageParameter(MappedStatement var1, Object var2, BoundSql var3, Page var4);
    }

    public static enum Dialect {
        mysql,
        mariadb,
        sqlite,
        oracle,
        hsqldb,
        postgresql,
        sqlserver,
        db2;

    }
}

