/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.InvocationListener;
import com.googlecode.jsonrpc4j.JsonRpcServer;
import java.util.logging.Level;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.support.RemoteExporter;

public abstract class AbstractJsonServiceExporter
extends RemoteExporter
implements InitializingBean,
ApplicationContextAware {
    private ObjectMapper objectMapper;
    private JsonRpcServer jsonRpcServer;
    private ApplicationContext applicationContext;
    private ErrorResolver errorResolver = null;
    private boolean backwardsComaptible = true;
    private boolean rethrowExceptions = false;
    private boolean allowExtraParams = false;
    private boolean allowLessParams = false;
    private Level exceptionLogLevel = Level.WARNING;
    private InvocationListener invocationListener = null;

    protected void exportService() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
        if (this.objectMapper == null && this.applicationContext != null && this.applicationContext.containsBean("objectMapper")) {
            this.objectMapper = (ObjectMapper)this.applicationContext.getBean("objectMapper");
        }
        if (this.objectMapper == null && this.applicationContext != null) {
            try {
                this.objectMapper = (ObjectMapper)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ObjectMapper.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        this.jsonRpcServer = new JsonRpcServer(this.objectMapper, this.getProxyForService(), this.getServiceInterface());
        this.jsonRpcServer.setErrorResolver(this.errorResolver);
        this.jsonRpcServer.setBackwardsComaptible(this.backwardsComaptible);
        this.jsonRpcServer.setRethrowExceptions(this.rethrowExceptions);
        this.jsonRpcServer.setAllowExtraParams(this.allowExtraParams);
        this.jsonRpcServer.setAllowLessParams(this.allowLessParams);
        this.jsonRpcServer.setExceptionLogLevel(this.exceptionLogLevel);
        this.jsonRpcServer.setInvocationListener(this.invocationListener);
        this.exportService();
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected JsonRpcServer getJsonRpcServer() {
        return this.jsonRpcServer;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setErrorResolver(ErrorResolver errorResolver) {
        this.errorResolver = errorResolver;
    }

    public void setBackwardsComaptible(boolean backwardsComaptible) {
        this.backwardsComaptible = backwardsComaptible;
    }

    public void setRethrowExceptions(boolean rethrowExceptions) {
        this.rethrowExceptions = rethrowExceptions;
    }

    public void setAllowExtraParams(boolean allowExtraParams) {
        this.allowExtraParams = allowExtraParams;
    }

    public void setAllowLessParams(boolean allowLessParams) {
        this.allowLessParams = allowLessParams;
    }

    public void setExceptionLogLevel(Level exceptionLogLevel) {
        this.exceptionLogLevel = exceptionLogLevel;
    }

    public void setInvocationListener(InvocationListener invocationListener) {
        this.invocationListener = invocationListener;
    }
}

