/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.JsonRpcServer;
import com.googlecode.jsonrpc4j.ProxyUtil;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractCompositeJsonServiceExporter
implements InitializingBean,
ApplicationContextAware {
    private ObjectMapper objectMapper;
    private ApplicationContext applicationContext;
    private ErrorResolver errorResolver = null;
    private boolean backwardsComaptible = true;
    private boolean rethrowExceptions = false;
    private boolean allowExtraParams = false;
    private boolean allowLessParams = false;
    private JsonRpcServer jsonRpcServer;
    private boolean allowMultipleInheritance = false;
    private Class<?>[] serviceInterfaces = null;
    private Object[] services = new Object[0];

    protected void exportService() throws Exception {
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.objectMapper == null && this.applicationContext != null && this.applicationContext.containsBean("objectMapper")) {
            this.objectMapper = (ObjectMapper)this.applicationContext.getBean("objectMapper");
        }
        if (this.objectMapper == null && this.applicationContext != null) {
            try {
                this.objectMapper = (ObjectMapper)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ObjectMapper.class);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        Object service = ProxyUtil.createCompositeServiceProxy(this.getClass().getClassLoader(), this.services, this.serviceInterfaces, this.allowMultipleInheritance);
        this.jsonRpcServer = new JsonRpcServer(this.objectMapper, service);
        this.jsonRpcServer.setErrorResolver(this.errorResolver);
        this.jsonRpcServer.setBackwardsComaptible(this.backwardsComaptible);
        this.jsonRpcServer.setRethrowExceptions(this.rethrowExceptions);
        this.jsonRpcServer.setAllowExtraParams(this.allowExtraParams);
        this.jsonRpcServer.setAllowLessParams(this.allowLessParams);
        this.exportService();
    }

    protected JsonRpcServer getJsonRpcServer() {
        return this.jsonRpcServer;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setErrorResolver(ErrorResolver errorResolver) {
        this.errorResolver = errorResolver;
    }

    public void setBackwardsComaptible(boolean backwardsComaptible) {
        this.backwardsComaptible = backwardsComaptible;
    }

    public void setAllowExtraParams(boolean allowExtraParams) {
        this.allowExtraParams = allowExtraParams;
    }

    public void setAllowLessParams(boolean allowLessParams) {
        this.allowLessParams = allowLessParams;
    }

    public void setAllowMultipleInheritance(boolean allowMultipleInheritance) {
        this.allowMultipleInheritance = allowMultipleInheritance;
    }

    public void setServiceInterfaces(Class<?>[] serviceInterfaces) {
        this.serviceInterfaces = serviceInterfaces;
    }

    public void setServices(Object[] services) {
        this.services = services;
    }
}

