/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.googlecode.jsonrpc4j.JsonRpcMethod;
import com.googlecode.jsonrpc4j.JsonRpcParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ReflectionUtil {
    private static final Map<String, Set<Method>> methodCache = new ConcurrentHashMap<String, Set<Method>>();
    private static final Map<Method, List<Class<?>>> parameterTypeCache = new ConcurrentHashMap();
    private static final Map<Method, List<Annotation>> methodAnnotationCache = new ConcurrentHashMap<Method, List<Annotation>>();
    private static final Map<Method, List<List<Annotation>>> methodParamAnnotationCache = new ConcurrentHashMap<Method, List<List<Annotation>>>();

    public static Set<Method> findMethods(Class<?>[] clazzes, String name) {
        StringBuilder sb = new StringBuilder();
        for (Class<?> clazz : clazzes) {
            sb.append(clazz.getName()).append("::");
        }
        String cacheKey = sb.append(name).toString();
        if (methodCache.containsKey(cacheKey)) {
            return methodCache.get(cacheKey);
        }
        HashSet<Method> methods = new HashSet();
        for (Class<?> clazz : clazzes) {
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(name) && !ReflectionUtil.annotationMatches(method, name)) continue;
                methods.add(method);
            }
        }
        methods = Collections.unmodifiableSet(methods);
        methodCache.put(cacheKey, methods);
        return methods;
    }

    public static boolean annotationMatches(Method method, String name) {
        JsonRpcMethod methodAnnotation;
        return method.isAnnotationPresent(JsonRpcMethod.class) && (methodAnnotation = method.getAnnotation(JsonRpcMethod.class)).value().equals(name);
    }

    public static List<Class<?>> getParameterTypes(Method method) {
        if (parameterTypeCache.containsKey(method)) {
            return parameterTypeCache.get(method);
        }
        ArrayList<Class<?>> types = new ArrayList();
        Collections.addAll(types, method.getParameterTypes());
        types = Collections.unmodifiableList(types);
        parameterTypeCache.put(method, types);
        return types;
    }

    public static List<Annotation> getAnnotations(Method method) {
        if (methodAnnotationCache.containsKey(method)) {
            return methodAnnotationCache.get(method);
        }
        ArrayList<Annotation> annotations = new ArrayList();
        Collections.addAll(annotations, method.getAnnotations());
        annotations = Collections.unmodifiableList(annotations);
        methodAnnotationCache.put(method, annotations);
        return annotations;
    }

    public static <T extends Annotation> List<T> getAnnotations(Method method, Class<T> type) {
        ArrayList<T> ret = new ArrayList<T>();
        for (Annotation a : ReflectionUtil.getAnnotations(method)) {
            if (!type.isInstance(a)) continue;
            ret.add(type.cast(a));
        }
        return ret;
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> type) {
        for (Annotation a : ReflectionUtil.getAnnotations(method)) {
            if (!type.isInstance(a)) continue;
            return (T)((Annotation)type.cast(a));
        }
        return null;
    }

    public static List<List<Annotation>> getParameterAnnotations(Method method) {
        if (methodParamAnnotationCache.containsKey(method)) {
            return methodParamAnnotationCache.get(method);
        }
        ArrayList<List<Annotation>> annotations = new ArrayList();
        for (Annotation[] paramAnnotations : method.getParameterAnnotations()) {
            ArrayList listAnnotations = new ArrayList();
            Collections.addAll(listAnnotations, paramAnnotations);
            annotations.add(listAnnotations);
        }
        annotations = Collections.unmodifiableList(annotations);
        methodParamAnnotationCache.put(method, annotations);
        return annotations;
    }

    public static <T extends Annotation> List<List<T>> getParameterAnnotations(Method method, Class<T> type) {
        ArrayList<List<T>> annotations = new ArrayList<List<T>>();
        for (List<Annotation> paramAnnotations : ReflectionUtil.getParameterAnnotations(method)) {
            ArrayList<T> listAnnotations = new ArrayList<T>();
            for (Annotation a : paramAnnotations) {
                if (!type.isInstance(a)) continue;
                listAnnotations.add(type.cast(a));
            }
            annotations.add(listAnnotations);
        }
        return annotations;
    }

    public static Object parseArguments(Method method, Object[] arguments, boolean useNamedParams) {
        if (useNamedParams) {
            HashMap<String, Object> namedParams = new HashMap<String, Object>();
            Annotation[][] paramAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < paramAnnotations.length; ++i) {
                Annotation[] ann = paramAnnotations[i];
                boolean jsonRpcParamAnnotPresent = false;
                for (Annotation an : ann) {
                    if (!JsonRpcParam.class.isInstance(an)) continue;
                    JsonRpcParam jAnn = (JsonRpcParam)an;
                    namedParams.put(jAnn.value(), arguments[i]);
                    jsonRpcParamAnnotPresent = true;
                    break;
                }
                if (jsonRpcParamAnnotPresent) continue;
                throw new RuntimeException("useNamedParams is enabled and a JsonRpcParam annotation was not found at parameter index " + i + " on method " + method.getName());
            }
            return namedParams;
        }
        return arguments != null ? arguments : new Object[]{};
    }
}

