/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.googlecode.jsonrpc4j.ExceptionResolver;
import java.util.LinkedList;
import java.util.List;

public class MultipleExceptionResolver
implements ExceptionResolver {
    private final List<ExceptionResolver> resolvers = new LinkedList<ExceptionResolver>();

    public MultipleExceptionResolver(ExceptionResolver ... resolvers) {
        for (ExceptionResolver resolver : resolvers) {
            this.resolvers.add(resolver);
        }
    }

    public void addExceptionResolver(ExceptionResolver ExceptionResolver2) {
        this.resolvers.add(ExceptionResolver2);
    }

    @Override
    public Throwable resolveException(ObjectNode response) {
        for (ExceptionResolver resolver : this.resolvers) {
            Throwable resolvedException = resolver.resolveException(response);
            if (resolvedException == null) continue;
            return resolvedException;
        }
        return null;
    }
}

