/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonrpc4j.ErrorResolver;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public class MultipleErrorResolver
implements ErrorResolver {
    private List<ErrorResolver> resolvers = new LinkedList<ErrorResolver>();

    public MultipleErrorResolver(ErrorResolver ... resolvers) {
        for (ErrorResolver resolver : resolvers) {
            this.resolvers.add(resolver);
        }
    }

    public void addErrorResolver(ErrorResolver errorResolver) {
        this.resolvers.add(errorResolver);
    }

    @Override
    public ErrorResolver.JsonError resolveError(Throwable t, Method method, List<JsonNode> arguments) {
        ErrorResolver.JsonError resolvedError = null;
        for (ErrorResolver resolver : this.resolvers) {
            resolvedError = resolver.resolveError(t, method, arguments);
            if (resolvedError == null) continue;
            return resolvedError;
        }
        return null;
    }
}

