/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.HttpException;
import com.googlecode.jsonrpc4j.IJsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class JsonRpcHttpClient
extends JsonRpcClient
implements IJsonRpcClient {
    public static final String JSONRPC_CONTENT_TYPE = "application/json-rpc";
    private URL serviceUrl;
    private Proxy connectionProxy = Proxy.NO_PROXY;
    private int connectionTimeoutMillis = 60000;
    private int readTimeoutMillis = 120000;
    private SSLContext sslContext = null;
    private HostnameVerifier hostNameVerifier = null;
    private final Map<String, String> headers = new HashMap<String, String>();

    public JsonRpcHttpClient(ObjectMapper mapper, URL serviceUrl, Map<String, String> headers) {
        super(mapper);
        this.serviceUrl = serviceUrl;
        this.headers.putAll(headers);
    }

    public JsonRpcHttpClient(URL serviceUrl, Map<String, String> headers) {
        this(new ObjectMapper(), serviceUrl, headers);
    }

    public JsonRpcHttpClient(URL serviceUrl) {
        this(new ObjectMapper(), serviceUrl, new HashMap<String, String>());
    }

    @Override
    public void invoke(String methodName, Object argument) throws Throwable {
        this.invoke(methodName, argument, null, new HashMap<String, String>());
    }

    @Override
    public Object invoke(String methodName, Object argument, Type returnType) throws Throwable {
        return this.invoke(methodName, argument, returnType, new HashMap<String, String>());
    }

    @Override
    public <T> T invoke(String methodName, Object argument, Class<T> clazz) throws Throwable {
        return (T)this.invoke(methodName, argument, (Type)Type.class.cast(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(String methodName, Object argument, Type returnType, Map<String, String> extraHeaders) throws Throwable {
        Object object;
        HttpURLConnection con = this.prepareConnection(extraHeaders);
        con.connect();
        OutputStream ops = con.getOutputStream();
        try {
            super.invoke(methodName, argument, ops);
        }
        finally {
            ops.close();
        }
        InputStream ips = con.getInputStream();
        try {
            object = super.readResponse(returnType, ips);
        }
        catch (Throwable throwable) {
            try {
                ips.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new HttpException(JsonRpcHttpClient.readString(con.getErrorStream()), e);
            }
        }
        ips.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readString(InputStream stream) {
        if (stream == null) {
            return "null";
        }
        try {
            StringBuilder buf = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            int ch22 = reader.read();
            while (ch22 >= 0) {
                buf.append((char)ch22);
                ch22 = reader.read();
            }
            String ch22 = buf.toString();
            return ch22;
        }
        catch (UnsupportedEncodingException e) {
            String string = e.getMessage();
            return string;
        }
        catch (IOException e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public <T> T invoke(String methodName, Object argument, Class<T> clazz, Map<String, String> extraHeaders) throws Throwable {
        return (T)this.invoke(methodName, argument, (Type)Type.class.cast(clazz), extraHeaders);
    }

    protected HttpURLConnection prepareConnection(Map<String, String> extraHeaders) throws IOException {
        HttpURLConnection con = (HttpURLConnection)this.serviceUrl.openConnection(this.connectionProxy);
        con.setConnectTimeout(this.connectionTimeoutMillis);
        con.setReadTimeout(this.readTimeoutMillis);
        con.setAllowUserInteraction(false);
        con.setDefaultUseCaches(false);
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setInstanceFollowRedirects(true);
        con.setRequestMethod("POST");
        if (HttpsURLConnection.class.isInstance(con)) {
            HttpsURLConnection https = (HttpsURLConnection)HttpsURLConnection.class.cast(con);
            if (this.hostNameVerifier != null) {
                https.setHostnameVerifier(this.hostNameVerifier);
            }
            if (this.sslContext != null) {
                https.setSSLSocketFactory(this.sslContext.getSocketFactory());
            }
        }
        con.setRequestProperty("Content-Type", JSONRPC_CONTENT_TYPE);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            con.setRequestProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
            con.setRequestProperty(entry.getKey(), entry.getValue());
        }
        return con;
    }

    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(URL serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public Proxy getConnectionProxy() {
        return this.connectionProxy;
    }

    public void setConnectionProxy(Proxy connectionProxy) {
        this.connectionProxy = connectionProxy;
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setHostNameVerifier(HostnameVerifier hostNameVerifier) {
        this.hostNameVerifier = hostNameVerifier;
    }
}

