/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.googlecode.jsonrpc4j.DefaultExceptionResolver;
import com.googlecode.jsonrpc4j.ExceptionResolver;
import com.googlecode.jsonrpc4j.JsonRpcCallback;
import com.googlecode.jsonrpc4j.JsonRpcClientException;
import com.googlecode.jsonrpc4j.NoCloseInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultHttpClientIODispatch;
import org.apache.http.impl.nio.pool.BasicNIOConnFactory;
import org.apache.http.impl.nio.pool.BasicNIOConnPool;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.pool.NIOConnFactory;
import org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncRequester;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.pool.ConnPool;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;

public class JsonRpcHttpAsyncClient {
    private static final Logger LOGGER = Logger.getLogger(JsonRpcHttpAsyncClient.class.getName());
    private static final String JSON_RPC_VERSION = "2.0";
    private static HttpAsyncRequester requester;
    private static BasicNIOConnPool pool;
    private static SSLContext sslContext;
    private static AtomicBoolean initialized;
    private static AtomicLong nextId;
    private ExceptionResolver exceptionResolver = DefaultExceptionResolver.INSTANCE;
    private Map<String, String> headers = new HashMap<String, String>();
    private ObjectMapper mapper;
    private URL serviceUrl;

    public JsonRpcHttpAsyncClient(URL serviceUrl) {
        this(new ObjectMapper(), serviceUrl, new HashMap<String, String>());
    }

    public JsonRpcHttpAsyncClient(URL serviceUrl, Map<String, String> headers) {
        this(new ObjectMapper(), serviceUrl, headers);
    }

    public JsonRpcHttpAsyncClient(ObjectMapper mapper, URL serviceUrl, Map<String, String> headers) {
        this.initialize();
        this.mapper = mapper;
        this.serviceUrl = serviceUrl;
        this.headers.putAll(headers);
    }

    public static void setSSLContext(SSLContext sslContext) {
        JsonRpcHttpAsyncClient.sslContext = sslContext;
    }

    public Future<Object> invoke(String methodName, Object argument) {
        return this.invoke(methodName, argument, Object.class, new HashMap<String, String>());
    }

    public <T> Future<T> invoke(String methodName, Object argument, Class<T> returnType) {
        return this.invoke(methodName, argument, returnType, new HashMap<String, String>());
    }

    public <T> Future<T> invoke(String methodName, Object argument, Class<T> returnType, Map<String, String> extraHeaders) {
        return this.doInvoke(methodName, argument, returnType, extraHeaders, new JsonRpcFuture());
    }

    public void invoke(String methodName, Object argument, JsonRpcCallback<Object> callback) {
        this.invoke(methodName, argument, Object.class, new HashMap<String, String>(), callback);
    }

    public <T> void invoke(String methodName, Object argument, Class<T> returnType, JsonRpcCallback<T> callback) {
        this.invoke(methodName, argument, returnType, new HashMap<String, String>(), callback);
    }

    private <T> void invoke(String methodName, Object argument, Class<T> returnType, Map<String, String> extraHeaders, JsonRpcCallback<T> callback) {
        this.doInvoke(methodName, argument, returnType, extraHeaders, callback);
    }

    private <T> Future<T> doInvoke(String methodName, Object argument, Class<T> returnType, Map<String, String> extraHeaders, JsonRpcCallback<T> callback) {
        String path = this.serviceUrl.getPath() + (this.serviceUrl.getQuery() != null ? "?" + this.serviceUrl.getQuery() : "");
        int port = this.serviceUrl.getPort() != -1 ? this.serviceUrl.getPort() : this.serviceUrl.getDefaultPort();
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", path);
        this.addHeaders((HttpRequest)request, this.headers);
        this.addHeaders((HttpRequest)request, extraHeaders);
        try {
            this.writeRequest(methodName, argument, (HttpRequest)request);
        }
        catch (IOException e) {
            callback.onError(e);
        }
        HttpHost target = new HttpHost(this.serviceUrl.getHost(), port, this.serviceUrl.getProtocol());
        BasicAsyncRequestProducer asyncRequestProducer = new BasicAsyncRequestProducer(target, (HttpRequest)request);
        BasicAsyncResponseConsumer asyncResponseConsumer = new BasicAsyncResponseConsumer();
        RequestAsyncFuture<T> futureCallback = new RequestAsyncFuture<T>(returnType, callback);
        BasicHttpContext httpContext = new BasicHttpContext();
        requester.execute((HttpAsyncRequestProducer)asyncRequestProducer, (HttpAsyncResponseConsumer)asyncResponseConsumer, (ConnPool)pool, (HttpContext)httpContext, futureCallback);
        return callback instanceof JsonRpcFuture ? (Future)((Object)callback) : null;
    }

    private void writeRequest(String methodName, Object arguments, HttpRequest httpRequest) throws IOException {
        ObjectNode request = this.mapper.createObjectNode();
        request.put("id", nextId.getAndIncrement());
        request.put("jsonrpc", JSON_RPC_VERSION);
        request.put("method", methodName);
        if (arguments != null && arguments.getClass().isArray()) {
            Object[] args = (Object[])Object[].class.cast(arguments);
            if (args.length > 0) {
                request.set("params", this.mapper.valueToTree(Object[].class.cast(arguments)));
            }
        } else if (arguments != null && Collection.class.isInstance(arguments)) {
            if (!((Collection)Collection.class.cast(arguments)).isEmpty()) {
                request.set("params", this.mapper.valueToTree(arguments));
            }
        } else if (arguments != null && Map.class.isInstance(arguments)) {
            if (!((Map)Map.class.cast(arguments)).isEmpty()) {
                request.set("params", this.mapper.valueToTree(arguments));
            }
        } else if (arguments != null) {
            request.set("params", this.mapper.valueToTree(arguments));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "JSON-PRC Request: " + request.toString());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        this.mapper.writeValue((OutputStream)baos, (Object)request);
        HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)httpRequest;
        ByteArrayEntity entity = entityRequest.getFirstHeader("Content-Type") == null ? new ByteArrayEntity(baos.toByteArray(), ContentType.APPLICATION_JSON) : new ByteArrayEntity(baos.toByteArray());
        entityRequest.setEntity((HttpEntity)entity);
    }

    private <T> T readResponse(Type returnType, InputStream ips) throws Throwable {
        JsonNode response = this.mapper.readTree((InputStream)new NoCloseInputStream(ips));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "JSON-PRC Response: " + response.toString());
        }
        if (!response.isObject()) {
            throw new JsonRpcClientException(0, "Invalid JSON-RPC response", response);
        }
        ObjectNode jsonObject = (ObjectNode)ObjectNode.class.cast(response);
        if (jsonObject.has("error") && jsonObject.get("error") != null && !jsonObject.get("error").isNull()) {
            if (this.exceptionResolver == null) {
                throw DefaultExceptionResolver.INSTANCE.resolveException(jsonObject);
            }
            throw this.exceptionResolver.resolveException(jsonObject);
        }
        if (jsonObject.has("result") && !jsonObject.get("result").isNull() && jsonObject.get("result") != null) {
            JsonParser returnJsonParser = this.mapper.treeAsTokens((TreeNode)jsonObject.get("result"));
            JavaType returnJavaType = TypeFactory.defaultInstance().constructType(returnType);
            return (T)this.mapper.readValue(returnJsonParser, returnJavaType);
        }
        return null;
    }

    private void addHeaders(HttpRequest request, Map<String, String> headers) {
        for (String key : headers.keySet()) {
            request.addHeader(key, headers.get(key));
        }
    }

    private void initialize() {
        DefaultConnectingIOReactor ioReactor;
        if (initialized.getAndSet(true)) {
            return;
        }
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", Integer.getInteger("com.googlecode.jsonrpc4j.async.socket.timeout", 30000).intValue());
        params.setIntParameter("http.connection.timeout", Integer.getInteger("com.googlecode.jsonrpc4j.async.connect.timeout", 30000).intValue());
        params.setIntParameter("http.socket.buffer-size", Integer.getInteger("com.googlecode.jsonrpc4j.async.socket.buffer", 8192).intValue());
        params.setBooleanParameter("http.tcp.nodelay", Boolean.valueOf(System.getProperty("com.googlecode.jsonrpc4j.async.tcp.nodelay", "true")).booleanValue());
        params.setParameter("http.useragent", (Object)"jsonrpc4j/1.0");
        try {
            IOReactorConfig config = new IOReactorConfig();
            config.setIoThreadCount(Integer.getInteger("com.googlecode.jsonrpc4j.async.reactor.threads", 1).intValue());
            ioReactor = new DefaultConnectingIOReactor(config);
        }
        catch (IOReactorException e) {
            throw new RuntimeException("Exception initializing asynchronous Apache HTTP Client", e);
        }
        if (sslContext == null) {
            try {
                sslContext = SSLContext.getDefault();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        BasicNIOConnFactory nioConnFactory = new BasicNIOConnFactory(sslContext, null, (HttpParams)params);
        pool = new BasicNIOConnPool((ConnectingIOReactor)ioReactor, (NIOConnFactory)nioConnFactory, (HttpParams)params);
        pool.setDefaultMaxPerRoute(Integer.getInteger("com.googlecode.jsonrpc4j.async.max.inflight.route", 500).intValue());
        pool.setMaxTotal(Integer.getInteger("com.googlecode.jsonrpc4j.async.max.inflight.total", 500).intValue());
        Thread t = new Thread(new Runnable((HttpParams)params, (ConnectingIOReactor)ioReactor){
            final /* synthetic */ HttpParams val$params;
            final /* synthetic */ ConnectingIOReactor val$ioReactor;
            {
                this.val$params = httpParams;
                this.val$ioReactor = connectingIOReactor;
            }

            @Override
            public void run() {
                try {
                    HttpAsyncRequestExecutor protocolHandler = new HttpAsyncRequestExecutor();
                    DefaultHttpClientIODispatch ioEventDispatch = new DefaultHttpClientIODispatch((NHttpClientEventHandler)protocolHandler, sslContext, this.val$params);
                    this.val$ioReactor.execute((IOEventDispatch)ioEventDispatch);
                }
                catch (InterruptedIOException ex) {
                    System.err.println("Interrupted");
                }
                catch (IOException e) {
                    System.err.println("I/O error: " + e.getMessage());
                }
            }
        }, "jsonrpc4j HTTP IOReactor");
        t.setDaemon(true);
        t.start();
        ImmutableHttpProcessor httpproc = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(), new RequestExpectContinue()});
        requester = new HttpAsyncRequester((HttpProcessor)httpproc, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpParams)params);
    }

    static {
        initialized = new AtomicBoolean();
        nextId = new AtomicLong();
    }

    private class JsonRpcFuture<T>
    implements Future<T>,
    JsonRpcCallback<T> {
        private T object;
        private boolean done;
        private ExecutionException exception;

        private JsonRpcFuture() {
        }

        @Override
        public synchronized boolean isDone() {
            return this.done;
        }

        @Override
        public synchronized T get() throws InterruptedException, ExecutionException {
            while (!this.done) {
                this.wait();
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.object;
        }

        @Override
        public synchronized T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            while (!this.done) {
                this.wait(unit.toMillis(timeout));
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.object;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public synchronized void onComplete(T result) {
            this.object = result;
            this.done = true;
            this.notify();
        }

        @Override
        public synchronized void onError(Throwable t) {
            this.exception = new ExecutionException(t);
            this.done = true;
            this.notify();
        }
    }

    private class RequestAsyncFuture<T>
    implements FutureCallback<HttpResponse> {
        private JsonRpcCallback<T> callBack;
        private Class<T> type;

        RequestAsyncFuture(Class<T> type, JsonRpcCallback<T> callBack) {
            this.type = type;
            this.callBack = callBack;
        }

        public void completed(HttpResponse response) {
            block5: {
                try {
                    StatusLine statusLine = response.getStatusLine();
                    int statusCode = statusLine.getStatusCode();
                    if (statusCode == 200) {
                        InputStream stream;
                        HttpEntity entity = response.getEntity();
                        try {
                            stream = entity.getContent();
                        }
                        catch (Exception e) {
                            this.failed(e);
                            return;
                        }
                        this.callBack.onComplete(this.type.cast(JsonRpcHttpAsyncClient.this.readResponse(this.type, stream)));
                        break block5;
                    }
                    this.callBack.onError(new RuntimeException("Unexpected response code: " + statusCode));
                }
                catch (Throwable t) {
                    this.callBack.onError(t);
                }
            }
        }

        public void failed(Exception ex) {
            this.callBack.onError(ex);
        }

        public void cancelled() {
            this.callBack.onError(new RuntimeException("HTTP Request was cancelled"));
        }
    }
}

