/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.googlecode.jsonrpc4j.AnnotationsErrorResolver;
import com.googlecode.jsonrpc4j.DefaultErrorResolver;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.InvocationListener;
import com.googlecode.jsonrpc4j.JsonRpcParam;
import com.googlecode.jsonrpc4j.MultipleErrorResolver;
import com.googlecode.jsonrpc4j.NoCloseOutputStream;
import com.googlecode.jsonrpc4j.ReadContext;
import com.googlecode.jsonrpc4j.ReflectionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.iharder.Base64;

public class JsonRpcBasicServer {
    private static final Logger LOGGER = Logger.getLogger(JsonRpcBasicServer.class.getName());
    public static final String JSONRPC_RESPONSE_CONTENT_TYPE = "application/json-rpc";
    public static final ErrorResolver DEFAULT_ERRROR_RESOLVER = new MultipleErrorResolver(AnnotationsErrorResolver.INSTANCE, DefaultErrorResolver.INSTANCE);
    private static Class<?> WEBPARAM_ANNOTATION_CLASS;
    private static Method WEBPARAM_NAME_METHOD;
    private boolean backwardsComaptible = true;
    private boolean rethrowExceptions = false;
    private boolean allowExtraParams = false;
    private boolean allowLessParams = false;
    private ErrorResolver errorResolver = null;
    private ObjectMapper mapper;
    private Object handler;
    private Class<?> remoteInterface;
    private InvocationListener invocationListener = null;
    private Level exceptionLogLevel = Level.WARNING;

    public JsonRpcBasicServer(ObjectMapper mapper, Object handler, Class<?> remoteInterface) {
        this.mapper = mapper;
        this.handler = handler;
        this.remoteInterface = remoteInterface;
    }

    public JsonRpcBasicServer(ObjectMapper mapper, Object handler) {
        this(mapper, handler, null);
    }

    public JsonRpcBasicServer(Object handler, Class<?> remoteInterface) {
        this(new ObjectMapper(), handler, remoteInterface);
    }

    public JsonRpcBasicServer(Object handler) {
        this(new ObjectMapper(), handler, null);
    }

    public int handle(InputStream ips, OutputStream ops) throws IOException {
        ReadContext ctx = ReadContext.getReadContext(ips, this.mapper);
        JsonNode jsonNode = null;
        try {
            ctx.assertReadable();
            jsonNode = ctx.nextValue();
        }
        catch (JsonParseException e) {
            this.writeAndFlushValue(ops, this.createErrorResponse("jsonrpc", "null", -32700, "Parse error", null));
            return -32700;
        }
        return this.handleNode(jsonNode, ops);
    }

    protected static InputStream createInputStream(String method, String id, String params) throws IOException {
        String decodedParams = URLDecoder.decode(new String(Base64.decode((String)params)), "UTF-8");
        String request = "{ " + "\"id\": \"" + id + "\", " + "\"method\": \"" + method + "\", " + "\"params\": " + decodedParams + " " + "}";
        return new ByteArrayInputStream(request.getBytes());
    }

    protected Class<?>[] getHandlerInterfaces(String serviceName) {
        if (this.remoteInterface != null) {
            return new Class[]{this.remoteInterface};
        }
        if (Proxy.isProxyClass(this.handler.getClass())) {
            return this.handler.getClass().getInterfaces();
        }
        return new Class[]{this.handler.getClass()};
    }

    public int handleNode(JsonNode node, OutputStream ops) throws IOException {
        if (node.isObject()) {
            return this.handleObject((ObjectNode)ObjectNode.class.cast(node), ops);
        }
        if (node.isArray()) {
            return this.handleArray((ArrayNode)ArrayNode.class.cast(node), ops);
        }
        this.writeAndFlushValue(ops, this.createErrorResponse("2.0", "null", -32600, "Invalid Request", null));
        return -32600;
    }

    public int handleArray(ArrayNode node, OutputStream ops) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Handing " + node.size() + " requests");
        }
        ops.write(91);
        for (int i = 0; i < node.size(); ++i) {
            int result = this.handleNode(node.get(i), ops);
            if (result != 0) {
                return result;
            }
            if (i == node.size() - 1) continue;
            ops.write(44);
        }
        ops.write(93);
        return 0;
    }

    public int handleObject(ObjectNode node, OutputStream ops) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Request: " + node.toString());
        }
        if (!this.backwardsComaptible && !node.has("jsonrpc") || !node.has("method")) {
            this.writeAndFlushValue(ops, this.createErrorResponse("2.0", "null", -32600, "Invalid Request", null));
            return -32600;
        }
        int returnCode = 0;
        JsonNode jsonPrcNode = node.get("jsonrpc");
        JsonNode methodNode = node.get("method");
        JsonNode idNode = node.get("id");
        JsonNode paramsNode = node.get("params");
        String jsonRpc = jsonPrcNode != null && !jsonPrcNode.isNull() ? jsonPrcNode.asText() : "2.0";
        String methodName = this.getMethodName(methodNode);
        String serviceName = this.getServiceName(methodNode);
        Object id = this.parseId(idNode);
        HashSet<Method> methods = new HashSet<Method>();
        methods.addAll(ReflectionUtil.findMethods(this.getHandlerInterfaces(serviceName), methodName));
        if (methods.isEmpty()) {
            this.writeAndFlushValue(ops, this.createErrorResponse(jsonRpc, id, -32601, "Method not found", null));
            return -32601;
        }
        MethodAndArgs methodArgs = this.findBestMethodByParamsNode(methods, paramsNode);
        if (methodArgs == null) {
            this.writeAndFlushValue(ops, this.createErrorResponse(jsonRpc, id, -32602, "Invalid method parameters", null));
            return -32602;
        }
        JsonNode result = null;
        Throwable thrown = null;
        long beforeMs = System.currentTimeMillis();
        if (this.invocationListener != null) {
            this.invocationListener.willInvoke(methodArgs.method, methodArgs.arguments);
        }
        try {
            result = this.invoke(this.getHandler(serviceName), methodArgs.method, methodArgs.arguments);
        }
        catch (Throwable e) {
            thrown = e;
        }
        if (this.invocationListener != null) {
            this.invocationListener.didInvoke(methodArgs.method, methodArgs.arguments, result, thrown, System.currentTimeMillis() - beforeMs);
        }
        if (id != null) {
            ErrorResolver.JsonError error = null;
            if (thrown != null) {
                Throwable e = thrown;
                while (InvocationTargetException.class.isInstance(e)) {
                    e = ((InvocationTargetException)InvocationTargetException.class.cast(e)).getTargetException();
                    while (UndeclaredThrowableException.class.isInstance(e)) {
                        e = ((UndeclaredThrowableException)UndeclaredThrowableException.class.cast(e)).getUndeclaredThrowable();
                    }
                }
                error = this.errorResolver != null ? this.errorResolver.resolveError(e, methodArgs.method, methodArgs.arguments) : DEFAULT_ERRROR_RESOLVER.resolveError(e, methodArgs.method, methodArgs.arguments);
                if (error == null) {
                    error = new ErrorResolver.JsonError(0, e.getMessage(), e.getClass().getName());
                }
            }
            ObjectNode response = null;
            if (error != null) {
                response = this.createErrorResponse(jsonRpc, id, error.getCode(), error.getMessage(), error.getData());
                returnCode = error.getCode();
            } else {
                response = this.createSuccessResponse(jsonRpc, id, result);
            }
            this.writeAndFlushValue(ops, response);
        }
        if (thrown != null) {
            if (LOGGER.isLoggable(this.exceptionLogLevel)) {
                LOGGER.log(this.exceptionLogLevel, "Error in JSON-RPC Service", thrown);
            }
            if (this.rethrowExceptions) {
                throw new RuntimeException(thrown);
            }
        }
        return returnCode;
    }

    protected String getServiceName(JsonNode methodNode) {
        return null;
    }

    protected String getMethodName(JsonNode methodNode) {
        return methodNode != null && !methodNode.isNull() ? methodNode.asText() : null;
    }

    protected Object getHandler(String serviceName) {
        return this.handler;
    }

    protected JsonNode invoke(Object target, Method m, List<JsonNode> params) throws IOException, IllegalAccessException, InvocationTargetException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Invoking method: " + m.getName());
        }
        Object[] convertedParams = new Object[params.size()];
        Type[] parameterTypes = m.getGenericParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            JsonParser paramJsonParser = this.mapper.treeAsTokens((TreeNode)params.get(i));
            JavaType paramJavaType = TypeFactory.defaultInstance().constructType(parameterTypes[i]);
            convertedParams[i] = this.mapper.readValue(paramJsonParser, paramJavaType);
        }
        Object result = m.invoke(target, convertedParams);
        return m.getGenericReturnType() != null ? this.mapper.valueToTree(result) : null;
    }

    protected ObjectNode createErrorResponse(String jsonRpc, Object id, int code, String message, Object data) {
        ObjectNode response = this.mapper.createObjectNode();
        ObjectNode error = this.mapper.createObjectNode();
        error.put("code", code);
        error.put("message", message);
        if (data != null) {
            error.set("data", this.mapper.valueToTree(data));
        }
        response.put("jsonrpc", jsonRpc);
        if (Integer.class.isInstance(id)) {
            response.put("id", ((Integer)Integer.class.cast(id)).intValue());
        } else if (Long.class.isInstance(id)) {
            response.put("id", ((Long)Long.class.cast(id)).longValue());
        } else if (Float.class.isInstance(id)) {
            response.put("id", ((Float)Float.class.cast(id)).floatValue());
        } else if (Double.class.isInstance(id)) {
            response.put("id", ((Double)Double.class.cast(id)).doubleValue());
        } else if (BigDecimal.class.isInstance(id)) {
            response.put("id", (BigDecimal)BigDecimal.class.cast(id));
        } else {
            response.put("id", (String)String.class.cast(id));
        }
        response.set("error", (JsonNode)error);
        return response;
    }

    protected ObjectNode createSuccessResponse(String jsonRpc, Object id, JsonNode result) {
        ObjectNode response = this.mapper.createObjectNode();
        response.put("jsonrpc", jsonRpc);
        if (Integer.class.isInstance(id)) {
            response.put("id", ((Integer)Integer.class.cast(id)).intValue());
        } else if (Long.class.isInstance(id)) {
            response.put("id", ((Long)Long.class.cast(id)).longValue());
        } else if (Float.class.isInstance(id)) {
            response.put("id", ((Float)Float.class.cast(id)).floatValue());
        } else if (Double.class.isInstance(id)) {
            response.put("id", ((Double)Double.class.cast(id)).doubleValue());
        } else if (BigDecimal.class.isInstance(id)) {
            response.put("id", (BigDecimal)BigDecimal.class.cast(id));
        } else {
            response.put("id", (String)String.class.cast(id));
        }
        response.set("result", result);
        return response;
    }

    private MethodAndArgs findBestMethodByParamsNode(Set<Method> methods, JsonNode paramsNode) {
        if (paramsNode == null || paramsNode.isNull()) {
            return this.findBestMethodUsingParamIndexes(methods, 0, null);
        }
        if (paramsNode.isArray()) {
            return this.findBestMethodUsingParamIndexes(methods, paramsNode.size(), (ArrayNode)ArrayNode.class.cast(paramsNode));
        }
        if (paramsNode.isObject()) {
            HashSet<String> fieldNames = new HashSet<String>();
            Iterator itr = paramsNode.fieldNames();
            while (itr.hasNext()) {
                fieldNames.add((String)itr.next());
            }
            return this.findBestMethodUsingParamNames(methods, fieldNames, (ObjectNode)ObjectNode.class.cast(paramsNode));
        }
        throw new IllegalArgumentException("Unknown params node type: " + paramsNode.toString());
    }

    private MethodAndArgs findBestMethodUsingParamIndexes(Set<Method> methods, int paramCount, ArrayNode paramNodes) {
        int numParams = paramNodes != null && !paramNodes.isNull() ? paramNodes.size() : 0;
        int bestParamNumDiff = Integer.MAX_VALUE;
        HashSet<Method> matchedMethods = new HashSet<Method>();
        for (Method method : methods) {
            Class<?>[] paramTypes = method.getParameterTypes();
            int paramNumDiff = paramTypes.length - paramCount;
            if (Math.abs(paramNumDiff) > Math.abs(bestParamNumDiff) || !this.allowExtraParams && paramNumDiff < 0 || !this.allowLessParams && paramNumDiff > 0) continue;
            if (Math.abs(paramNumDiff) < Math.abs(bestParamNumDiff)) {
                matchedMethods.clear();
            }
            matchedMethods.add(method);
            bestParamNumDiff = paramNumDiff;
        }
        if (matchedMethods.isEmpty()) {
            return null;
        }
        Method bestMethod = null;
        if (matchedMethods.size() == 1 || numParams == 0) {
            bestMethod = (Method)matchedMethods.iterator().next();
        } else {
            int mostMatches = -1;
            for (Method method : matchedMethods) {
                List<Class<?>> parameterTypes = ReflectionUtil.getParameterTypes(method);
                int numMatches = 0;
                for (int i = 0; i < parameterTypes.size() && i < numParams; ++i) {
                    if (!this.isMatchingType(paramNodes.get(i), parameterTypes.get(i))) continue;
                    ++numMatches;
                }
                if (numMatches <= mostMatches) continue;
                mostMatches = numMatches;
                bestMethod = method;
            }
        }
        MethodAndArgs ret = new MethodAndArgs();
        ret.method = bestMethod;
        int numParameters = bestMethod.getParameterTypes().length;
        for (int i = 0; i < numParameters; ++i) {
            if (i < numParams) {
                ret.arguments.add(paramNodes.get(i));
                continue;
            }
            ret.arguments.add(NullNode.getInstance());
        }
        return ret;
    }

    private MethodAndArgs findBestMethodUsingParamNames(Set<Method> methods, Set<String> paramNames, ObjectNode paramNodes) {
        int maxMatchingParams = -1;
        int maxMatchingParamTypes = -1;
        Method bestMethod = null;
        ArrayList<1> bestAnnotations = null;
        for (Method method : methods) {
            Object annotationList2;
            List<Class<?>> parameterTypes = ReflectionUtil.getParameterTypes(method);
            if (!this.allowExtraParams && paramNames.size() > parameterTypes.size() || !this.allowLessParams && paramNames.size() < parameterTypes.size()) continue;
            ArrayList<1> annotations = new ArrayList<1>();
            List<Object> jaxwsAnnotations = WEBPARAM_ANNOTATION_CLASS != null ? ReflectionUtil.getParameterAnnotations(method, WEBPARAM_ANNOTATION_CLASS) : new ArrayList();
            for (Object annotationList2 : jaxwsAnnotations) {
                if (annotationList2.size() > 0) {
                    final Annotation annotation = (Annotation)annotationList2.get(0);
                    annotations.add(new JsonRpcParam(){

                        @Override
                        public Class<? extends Annotation> annotationType() {
                            return JsonRpcParam.class;
                        }

                        @Override
                        public String value() {
                            try {
                                return (String)WEBPARAM_NAME_METHOD.invoke((Object)annotation, new Object[0]);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    continue;
                }
                annotationList2.add(null);
            }
            List<List<JsonRpcParam>> methodAnnotations = ReflectionUtil.getParameterAnnotations(method, JsonRpcParam.class);
            annotationList2 = methodAnnotations.iterator();
            while (annotationList2.hasNext()) {
                List annots = (List)annotationList2.next();
                if (annots.size() > 0) {
                    annotations.add(annots.get(0));
                    continue;
                }
                annots.add(null);
            }
            int numMatchingParamTypes = 0;
            int numMatchingParams = 0;
            for (int i = 0; i < annotations.size(); ++i) {
                JsonRpcParam annotation = (JsonRpcParam)annotations.get(i);
                if (annotation == null) continue;
                String paramName = annotation.value();
                boolean hasParamName = paramNames.contains(paramName);
                if (hasParamName && this.isMatchingType(paramNodes.get(paramName), parameterTypes.get(i))) {
                    ++numMatchingParamTypes;
                    ++numMatchingParams;
                    continue;
                }
                if (!hasParamName) continue;
                ++numMatchingParams;
            }
            if (!this.allowExtraParams && numMatchingParams > parameterTypes.size() || !this.allowLessParams && numMatchingParams < parameterTypes.size() || numMatchingParams <= maxMatchingParams && (numMatchingParams != maxMatchingParams || numMatchingParamTypes <= maxMatchingParamTypes)) continue;
            bestMethod = method;
            maxMatchingParams = numMatchingParams;
            maxMatchingParamTypes = numMatchingParamTypes;
            bestAnnotations = annotations;
        }
        if (bestMethod == null) {
            return null;
        }
        MethodAndArgs ret = new MethodAndArgs();
        ret.method = bestMethod;
        int numParameters = bestMethod.getParameterTypes().length;
        for (int i = 0; i < numParameters; ++i) {
            JsonRpcParam param = (JsonRpcParam)bestAnnotations.get(i);
            if (param != null && paramNames.contains(param.value())) {
                ret.arguments.add(paramNodes.get(param.value()));
                continue;
            }
            ret.arguments.add(NullNode.getInstance());
        }
        return ret;
    }

    private boolean isMatchingType(JsonNode node, Class<?> type) {
        if (node.isNull()) {
            return true;
        }
        if (node.isTextual()) {
            return String.class.isAssignableFrom(type);
        }
        if (node.isNumber()) {
            return Number.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type);
        }
        if (node.isArray() && type.isArray()) {
            return node.size() > 0 ? this.isMatchingType(node.get(0), type.getComponentType()) : false;
        }
        if (node.isArray()) {
            return type.isArray() || Collection.class.isAssignableFrom(type);
        }
        if (node.isBinary()) {
            return byte[].class.isAssignableFrom(type) || Byte[].class.isAssignableFrom(type) || char[].class.isAssignableFrom(type) || Character[].class.isAssignableFrom(type);
        }
        if (node.isBoolean()) {
            return Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type);
        }
        if (node.isObject() || node.isPojo()) {
            return !type.isPrimitive() && !String.class.isAssignableFrom(type) && !Number.class.isAssignableFrom(type) && !Boolean.class.isAssignableFrom(type);
        }
        return false;
    }

    private void writeAndFlushValue(OutputStream ops, Object value) throws IOException {
        this.mapper.writeValue((OutputStream)new NoCloseOutputStream(ops), value);
        ops.write(10);
    }

    private Object parseId(JsonNode node) {
        if (node == null || node.isNull()) {
            return null;
        }
        if (node.isDouble()) {
            return node.asDouble();
        }
        if (node.isFloatingPointNumber()) {
            return node.asDouble();
        }
        if (node.isInt()) {
            return node.asInt();
        }
        if (node.isIntegralNumber()) {
            return node.asInt();
        }
        if (node.isLong()) {
            return node.asLong();
        }
        if (node.isTextual()) {
            return node.asText();
        }
        throw new IllegalArgumentException("Unknown id type");
    }

    public void setBackwardsComaptible(boolean backwardsComaptible) {
        this.backwardsComaptible = backwardsComaptible;
    }

    public void setRethrowExceptions(boolean rethrowExceptions) {
        this.rethrowExceptions = rethrowExceptions;
    }

    public void setAllowExtraParams(boolean allowExtraParams) {
        this.allowExtraParams = allowExtraParams;
    }

    public void setAllowLessParams(boolean allowLessParams) {
        this.allowLessParams = allowLessParams;
    }

    public void setErrorResolver(ErrorResolver errorResolver) {
        this.errorResolver = errorResolver;
    }

    public void setExceptionLogLevel(Level exceptionLogLevel) {
        this.exceptionLogLevel = exceptionLogLevel;
    }

    public void setInvocationListener(InvocationListener invocationListener) {
        this.invocationListener = invocationListener;
    }

    static {
        ClassLoader classLoader = JsonRpcBasicServer.class.getClassLoader();
        try {
            WEBPARAM_ANNOTATION_CLASS = classLoader.loadClass("javax.jws.WebParam");
            WEBPARAM_NAME_METHOD = WEBPARAM_ANNOTATION_CLASS.getMethod("name", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class MethodAndArgs {
        private Method method = null;
        private List<JsonNode> arguments = new ArrayList<JsonNode>();

        private MethodAndArgs() {
        }
    }
}

