/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonrpc4j.DefaultErrorResolver;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.JsonRpcError;
import com.googlecode.jsonrpc4j.JsonRpcErrors;
import com.googlecode.jsonrpc4j.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.List;

public class AnnotationsErrorResolver
implements ErrorResolver {
    public static final AnnotationsErrorResolver INSTANCE = new AnnotationsErrorResolver();

    @Override
    public ErrorResolver.JsonError resolveError(Throwable t, Method method, List<JsonNode> arguments) {
        JsonRpcErrors errors = ReflectionUtil.getAnnotation(method, JsonRpcErrors.class);
        if (errors != null) {
            for (JsonRpcError em : errors.value()) {
                if (!em.exception().isInstance(t)) continue;
                String message = em.message() != null && em.message().trim().length() > 0 ? em.message() : t.getMessage();
                return new ErrorResolver.JsonError(em.code(), message, new DefaultErrorResolver.ErrorData(em.exception().getName(), message));
            }
        }
        return null;
    }
}

