/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.bean.WxCardApiSignature;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.mp.api.WxMpCardService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpCardResult;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpCardServiceImpl
implements WxMpCardService {
    private final Logger log = LoggerFactory.getLogger(WxMpCardServiceImpl.class);
    private WxMpService wxMpService;

    public WxMpCardServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public WxMpService getWxMpService() {
        return this.wxMpService;
    }

    @Override
    public String getCardApiTicket() throws WxErrorException {
        return this.getCardApiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCardApiTicket(boolean forceRefresh) throws WxErrorException {
        Lock lock = this.getWxMpService().getWxMpConfigStorage().getCardApiTicketLock();
        try {
            lock.lock();
            if (forceRefresh) {
                this.getWxMpService().getWxMpConfigStorage().expireCardApiTicket();
            }
            if (this.getWxMpService().getWxMpConfigStorage().isCardApiTicketExpired()) {
                String responseContent = (String)this.wxMpService.execute(SimpleGetRequestExecutor.create((RequestHttp)this.getWxMpService().getRequestHttp()), "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=wx_card", null);
                JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
                JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                String cardApiTicket = tmpJsonObject.get("ticket").getAsString();
                int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                this.getWxMpService().getWxMpConfigStorage().updateCardApiTicket(cardApiTicket, expiresInSeconds);
            }
        }
        finally {
            lock.unlock();
        }
        return this.getWxMpService().getWxMpConfigStorage().getCardApiTicket();
    }

    @Override
    public WxCardApiSignature createCardApiSignature(String ... optionalSignParam) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonceStr = RandomUtils.getRandomStr();
        String cardApiTicket = this.getCardApiTicket(false);
        String[] signParam = Arrays.copyOf(optionalSignParam, optionalSignParam.length + 3);
        signParam[optionalSignParam.length] = String.valueOf(timestamp);
        signParam[optionalSignParam.length + 1] = nonceStr;
        signParam[optionalSignParam.length + 2] = cardApiTicket;
        String signature = SHA1.gen((String[])signParam);
        WxCardApiSignature cardApiSignature = new WxCardApiSignature();
        cardApiSignature.setTimestamp(Long.valueOf(timestamp));
        cardApiSignature.setNonceStr(nonceStr);
        cardApiSignature.setSignature(signature);
        return cardApiSignature;
    }

    @Override
    public String decryptCardCode(String encryptCode) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("encrypt_code", encryptCode);
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/card/code/decrypt", param.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
        JsonPrimitive jsonPrimitive = tmpJsonObject.getAsJsonPrimitive("code");
        return jsonPrimitive.getAsString();
    }

    @Override
    public WxMpCardResult queryCardCode(String cardId, String code, boolean checkConsume) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        param.addProperty("code", code);
        param.addProperty("check_consume", Boolean.valueOf(checkConsume));
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/card/code/get", param.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (WxMpCardResult)WxMpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement, new TypeToken<WxMpCardResult>(){}.getType());
    }

    @Override
    public String consumeCardCode(String code) throws WxErrorException {
        return this.consumeCardCode(code, null);
    }

    @Override
    public String consumeCardCode(String code, String cardId) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("code", code);
        if (cardId != null && !"".equals(cardId)) {
            param.addProperty("card_id", cardId);
        }
        return this.wxMpService.post("https://api.weixin.qq.com/card/code/consume", param.toString());
    }

    @Override
    public void markCardCode(String code, String cardId, String openId, boolean isMark) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("code", code);
        param.addProperty("card_id", cardId);
        param.addProperty("openid", openId);
        param.addProperty("is_mark", Boolean.valueOf(isMark));
        String responseContent = this.getWxMpService().post("https://api.weixin.qq.com/card/code/mark", param.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        WxMpCardResult cardResult = (WxMpCardResult)WxMpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement, new TypeToken<WxMpCardResult>(){}.getType());
        if (!"0".equals(cardResult.getErrorCode())) {
            this.log.warn("\u670b\u53cb\u7684\u5238mark\u5931\u8d25\uff1a{}", (Object)cardResult.getErrorMsg());
        }
    }

    @Override
    public String getCardDetail(String cardId) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/card/get", param.toString());
        JsonObject json = new JsonParser().parse(responseContent).getAsJsonObject();
        String errcode = json.get("errcode").getAsString();
        if (!"0".equals(errcode)) {
            String errmsg = json.get("errmsg").getAsString();
            throw new WxErrorException(WxError.builder().errorCode(Integer.valueOf(errcode).intValue()).errorMsg(errmsg).build());
        }
        return responseContent;
    }
}

