/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.annotation.Required;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpStoreService;
import me.chanjar.weixin.mp.bean.store.WxMpStoreBaseInfo;
import me.chanjar.weixin.mp.bean.store.WxMpStoreInfo;
import me.chanjar.weixin.mp.bean.store.WxMpStoreListResult;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import org.joor.Reflect;

public class WxMpStoreServiceImpl
implements WxMpStoreService {
    private static final String API_BASE_URL = "http://api.weixin.qq.com/cgi-bin/poi";
    private WxMpService wxMpService;

    public WxMpStoreServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public void add(WxMpStoreBaseInfo request) throws WxErrorException {
        this.checkParameters(request);
        String url = "http://api.weixin.qq.com/cgi-bin/poi/addpoi";
        String response = this.wxMpService.post(url, request.toJson());
        WxError wxError = WxError.fromJson((String)response);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
    }

    @Override
    public WxMpStoreBaseInfo get(String poiId) throws WxErrorException {
        String url = "http://api.weixin.qq.com/cgi-bin/poi/getpoi";
        JsonObject paramObject = new JsonObject();
        paramObject.addProperty("poi_id", poiId);
        String response = this.wxMpService.post(url, paramObject.toString());
        WxError wxError = WxError.fromJson((String)response);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
        return WxMpStoreBaseInfo.fromJson(new JsonParser().parse(response).getAsJsonObject().get("business").getAsJsonObject().get("base_info").toString());
    }

    @Override
    public void delete(String poiId) throws WxErrorException {
        String url = "http://api.weixin.qq.com/cgi-bin/poi/delpoi";
        JsonObject paramObject = new JsonObject();
        paramObject.addProperty("poi_id", poiId);
        String response = this.wxMpService.post(url, paramObject.toString());
        WxError wxError = WxError.fromJson((String)response);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
    }

    private void checkParameters(WxMpStoreBaseInfo request) {
        ArrayList nullFields = Lists.newArrayList();
        for (Map.Entry entry : Reflect.on((Object)request).fields().entrySet()) {
            Reflect reflect = (Reflect)entry.getValue();
            try {
                Field field = request.getClass().getDeclaredField((String)entry.getKey());
                if (!field.isAnnotationPresent(Required.class) || reflect.get() != null) continue;
                nullFields.add(entry.getKey());
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
        if (!nullFields.isEmpty()) {
            throw new IllegalArgumentException("\u5fc5\u586b\u5b57\u6bb5[" + nullFields + "]\u5fc5\u987b\u63d0\u4f9b\u503c");
        }
    }

    @Override
    public WxMpStoreListResult list(int begin, int limit) throws WxErrorException {
        String url = "http://api.weixin.qq.com/cgi-bin/poi/getpoilist";
        JsonObject params = new JsonObject();
        params.addProperty("begin", (Number)begin);
        params.addProperty("limit", (Number)limit);
        String response = this.wxMpService.post(url, params.toString());
        WxError wxError = WxError.fromJson((String)response);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
        return WxMpStoreListResult.fromJson(response);
    }

    @Override
    public List<WxMpStoreInfo> listAll() throws WxErrorException {
        int limit = 50;
        WxMpStoreListResult list = this.list(0, limit);
        List<WxMpStoreInfo> stores = list.getBusinessList();
        if (list.getTotalCount() > limit) {
            int begin = limit;
            WxMpStoreListResult followingList = this.list(begin, limit);
            while (followingList.getBusinessList().size() > 0) {
                stores.addAll(followingList.getBusinessList());
                if ((begin += limit) >= list.getTotalCount()) break;
                followingList = this.list(begin, limit);
            }
        }
        return stores;
    }

    @Override
    public void update(WxMpStoreBaseInfo request) throws WxErrorException {
        String url = "http://api.weixin.qq.com/cgi-bin/poi/updatepoi";
        String response = this.wxMpService.post(url, request.toJson());
        WxError wxError = WxError.fromJson((String)response);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
    }

    @Override
    public List<String> listCategories() throws WxErrorException {
        String url = "http://api.weixin.qq.com/cgi-bin/poi/getwxcategory";
        String response = this.wxMpService.get(url, null);
        WxError wxError = WxError.fromJson((String)response);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
        return (List)WxMpGsonBuilder.create().fromJson(new JsonParser().parse(response).getAsJsonObject().get("category_list"), new TypeToken<List<String>>(){}.getType());
    }
}

