/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.token;

import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.TokenStorager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryTokenStorager
implements TokenStorager {
    private final Map<String, Token> CONMAP = new ConcurrentHashMap<String, Token>();

    @Override
    public Token lookup(String cacheKey) throws WeixinException {
        Token token = this.CONMAP.get(cacheKey);
        if (token != null && token.getCreateTime() + (long)token.getExpiresIn() * 1000L - 60000L > System.currentTimeMillis()) {
            return token;
        }
        return null;
    }

    @Override
    public void caching(String cacheKey, Token token) throws WeixinException {
        this.CONMAP.put(cacheKey, token);
    }

    @Override
    public Token evict(String cacheKey) throws WeixinException {
        return this.CONMAP.remove(cacheKey);
    }

    @Override
    public void clear() throws WeixinException {
        this.CONMAP.clear();
    }
}

