/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment.mch;

import com.foxinmy.weixin4j.model.Consts;
import com.foxinmy.weixin4j.model.WeixinPayAccount;
import com.foxinmy.weixin4j.payment.PayRequest;
import com.foxinmy.weixin4j.payment.mch.AbstractPayRequest;
import com.foxinmy.weixin4j.type.TradeType;
import com.foxinmy.weixin4j.util.DigestUtil;
import com.foxinmy.weixin4j.util.MapUtil;
import com.foxinmy.weixin4j.util.URLEncodingUtil;

public class WAPPayRequest
extends AbstractPayRequest {
    public WAPPayRequest(String prePayId, WeixinPayAccount payAccount) {
        super(prePayId, payAccount);
    }

    @Override
    public TradeType getPaymentType() {
        return TradeType.WAP;
    }

    @Override
    public PayRequest toRequestObject() {
        PayRequest payRequest = new PayRequest(this.getPaymentAccount().getId(), this.getPaymentType().name());
        payRequest.setPrepayId(this.getPrePayId());
        return payRequest;
    }

    @Override
    public String toRequestString() {
        PayRequest payRequest = this.toRequestObject();
        String original = MapUtil.toJoinString(payRequest, true, true);
        String sign = DigestUtil.MD5(String.format("%s&key=%s", original, this.getPaymentAccount().getPaySignKey())).toUpperCase();
        return String.format("weixin://wap/pay?%s", URLEncodingUtil.encoding(String.format("%s&sign=%s", original, sign), Consts.UTF_8, true));
    }
}

