/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment.mch;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.payment.mch.MerchantResult;
import com.foxinmy.weixin4j.payment.mch.RefundDetail;
import com.foxinmy.weixin4j.type.CurrencyType;
import com.foxinmy.weixin4j.xml.ListsuffixResult;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RefundRecord
extends MerchantResult {
    private static final long serialVersionUID = -2971132874939642721L;
    @XmlElement(name="transaction_id")
    @JSONField(name="transaction_id")
    private String transactionId;
    @XmlElement(name="out_trade_no")
    @JSONField(name="out_trade_no")
    private String outTradeNo;
    @XmlElement(name="total_fee")
    @JSONField(name="total_fee")
    private int totalFee;
    @XmlElement(name="fee_type")
    @JSONField(name="fee_type")
    private String feeType;
    @XmlElement(name="cash_fee")
    @JSONField(name="cash_fee")
    private int cashFee;
    @XmlElement(name="cash_fee_type")
    @JSONField(name="cash_fee_type")
    private String cashFeeType;
    @XmlElement(name="refund_fee")
    @JSONField(name="refund_fee")
    private int refundFee;
    @XmlElement(name="coupon_refund_fee")
    @JSONField(name="coupon_refund_fee")
    private Integer couponRefundFee;
    @XmlElement(name="refund_count")
    @JSONField(name="refund_count")
    private int refundCount;
    @ListsuffixResult(value={"^out_refund_no(_\\d)$", "^refund_.*(_\\d)$"})
    private List<RefundDetail> refundList;

    protected RefundRecord() {
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    @JSONField(serialize=false)
    public double getFormatCashFee() {
        return (double)this.cashFee / 100.0;
    }

    public int getCashFee() {
        return this.cashFee;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public String getCashFeeType() {
        return this.cashFeeType;
    }

    @JSONField(serialize=false)
    public CurrencyType getFormatFeeType() {
        return this.feeType != null ? CurrencyType.valueOf(this.feeType.toUpperCase()) : null;
    }

    @JSONField(serialize=false)
    public CurrencyType getFormatCashFeeType() {
        return this.cashFeeType != null ? CurrencyType.valueOf(this.cashFeeType.toUpperCase()) : null;
    }

    @JSONField(serialize=false)
    public double getFormatCouponRefundFee() {
        return this.couponRefundFee != null ? (double)this.couponRefundFee.intValue() / 100.0 : 0.0;
    }

    public Integer getCouponRefundFee() {
        return this.couponRefundFee;
    }

    @JSONField(serialize=false)
    public double getFormatTotalFee() {
        return (double)this.totalFee / 100.0;
    }

    public int getTotalFee() {
        return this.totalFee;
    }

    public int getRefundCount() {
        return this.refundCount;
    }

    public List<RefundDetail> getRefundList() {
        return this.refundList;
    }

    public void setRefundList(List<RefundDetail> refundList) {
        this.refundList = refundList;
    }

    public int getRefundFee() {
        return this.refundFee;
    }

    @JSONField(serialize=false)
    public double getFormatRefundFee() {
        return (double)this.refundFee / 100.0;
    }

    @Override
    public String toString() {
        return "RefundRecord [transactionId=" + this.transactionId + ", outTradeNo=" + this.outTradeNo + ", totalFee=" + this.getFormatTotalFee() + ", feeType=" + this.feeType + ", cashFee=" + this.getFormatCashFee() + ", cashFeeType=" + this.cashFeeType + ", refundFee=" + this.getFormatRefundFee() + ", couponRefundFee=" + this.getFormatCouponRefundFee() + ", refundCount=" + this.refundCount + ", refundList=" + this.refundList + ", " + super.toString() + "]";
    }
}

