/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment.mch;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.payment.coupon.CouponInfo;
import com.foxinmy.weixin4j.payment.mch.MerchantResult;
import com.foxinmy.weixin4j.type.CurrencyType;
import com.foxinmy.weixin4j.type.RefundChannel;
import com.foxinmy.weixin4j.type.RefundStatus;
import com.foxinmy.weixin4j.xml.ListsuffixResult;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RefundDetail
extends MerchantResult {
    private static final long serialVersionUID = -3687863914168618620L;
    @XmlElement(name="out_refund_no")
    @JSONField(name="out_refund_no")
    private String outRefundNo;
    @XmlElement(name="refund_id")
    @JSONField(name="refund_id")
    private String refundId;
    @XmlElement(name="refund_channel")
    @JSONField(name="refund_channel")
    private String refundChannel;
    @XmlElement(name="refund_fee")
    @JSONField(name="refund_fee")
    private int refundFee;
    @XmlElement(name="refund_fee_type")
    @JSONField(name="refund_fee_type")
    private String refundFeeType;
    @XmlElement(name="total_fee")
    @JSONField(name="total_fee")
    private int totalFee;
    @XmlElement(name="fee_type")
    @JSONField(name="fee_type")
    private String feeType;
    @XmlElement(name="cash_fee")
    @JSONField(name="cash_fee")
    private int cashFee;
    @XmlElement(name="cash_fee_type")
    @JSONField(name="cash_fee_type")
    private String cashFeeType;
    @XmlElement(name="cash_refund_fee")
    @JSONField(name="cash_refund_fee")
    private Integer cashRefundFee;
    @XmlElement(name="cash_refund_fee_type")
    @JSONField(name="cash_refund_fee_type")
    private String cashRefundFeeType;
    @XmlElement(name="refund_status")
    @JSONField(name="refund_status")
    private String refundStatus;
    @XmlElement(name="coupon_refund_fee")
    @JSONField(name="coupon_refund_fee")
    private Integer couponRefundFee;
    @XmlElement(name="coupon_refund_count")
    @JSONField(name="coupon_refund_count")
    private Integer couponRefundCount;
    @ListsuffixResult
    private List<CouponInfo> couponList;

    protected RefundDetail() {
    }

    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    public String getRefundId() {
        return this.refundId;
    }

    public String getRefundChannel() {
        return this.refundChannel;
    }

    @JSONField(serialize=false)
    public RefundChannel getFormatRefundChannel() {
        return this.refundChannel != null ? RefundChannel.valueOf(this.refundChannel.toUpperCase()) : null;
    }

    public int getRefundFee() {
        return this.refundFee;
    }

    public String getFeeType() {
        return this.feeType;
    }

    @JSONField(serialize=false)
    public CurrencyType getFormatFeeType() {
        return this.feeType != null ? CurrencyType.valueOf(this.feeType.toUpperCase()) : null;
    }

    @JSONField(serialize=false)
    public double getFormatRefundFee() {
        return (double)this.refundFee / 100.0;
    }

    public String getRefundStatus() {
        return this.refundStatus;
    }

    @JSONField(serialize=false)
    public RefundStatus getFormatRefundStatus() {
        return this.refundStatus != null ? RefundStatus.valueOf(this.refundStatus.toUpperCase()) : null;
    }

    public Integer getCouponRefundFee() {
        return this.couponRefundFee;
    }

    @JSONField(serialize=false)
    public double getFormatCouponRefundFee() {
        return this.couponRefundFee != null ? (double)this.couponRefundFee.intValue() / 100.0 : 0.0;
    }

    public String getRefundFeeType() {
        return this.refundFeeType;
    }

    @JSONField(serialize=false)
    public CurrencyType getFormatRefundFeeType() {
        return this.refundFeeType != null ? CurrencyType.valueOf(this.refundFeeType.toUpperCase()) : null;
    }

    public int getTotalFee() {
        return this.totalFee;
    }

    @JSONField(serialize=false)
    public double getFormatTotalFee() {
        return (double)this.totalFee / 100.0;
    }

    public int getCashFee() {
        return this.cashFee;
    }

    @JSONField(serialize=false)
    public double getFormatCashFee() {
        return (double)this.cashFee / 100.0;
    }

    public String getCashFeeType() {
        return this.cashFeeType;
    }

    @JSONField(serialize=false)
    public CurrencyType getFormatCashFeeType() {
        return this.cashFeeType != null ? CurrencyType.valueOf(this.cashFeeType.toUpperCase()) : null;
    }

    public Integer getCashRefundFee() {
        return this.cashRefundFee;
    }

    @JSONField(serialize=false)
    public double getFormatCashRefundFee() {
        return this.cashRefundFee != null ? (double)this.cashRefundFee.intValue() / 100.0 : 0.0;
    }

    public String getCashRefundFeeType() {
        return this.cashRefundFeeType;
    }

    @JSONField(serialize=false)
    public CurrencyType getFormatCashRefundFeeType() {
        return this.cashRefundFeeType != null ? CurrencyType.valueOf(this.cashRefundFeeType.toUpperCase()) : null;
    }

    public Integer getCouponRefundCount() {
        return this.couponRefundCount;
    }

    public List<CouponInfo> getCouponList() {
        return this.couponList;
    }

    public void setCouponList(List<CouponInfo> couponList) {
        this.couponList = couponList;
    }

    @Override
    public String toString() {
        return "RefundDetail [outRefundNo=" + this.outRefundNo + ", refundId=" + this.refundId + ", refundChannel=" + this.refundChannel + ", refundFee=" + this.getFormatRefundFee() + ", refundFeeType=" + this.refundFeeType + ", totalFee=" + this.getFormatTotalFee() + ", feeType=" + this.feeType + ", cashFee=" + this.getFormatCashFee() + ", cashFeeType=" + this.cashFeeType + ", cashRefundFee=" + this.getFormatCashRefundFee() + ", cashRefundFeeType=" + this.cashRefundFeeType + ", refundStatus=" + this.refundStatus + ", couponRefundFee=" + this.getFormatCouponRefundFee() + ", couponRefundCount=" + this.couponRefundCount + ", couponList=" + this.couponList + ", " + super.toString() + "]";
    }
}

