/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment;

import com.foxinmy.weixin4j.api.CashApi;
import com.foxinmy.weixin4j.api.CouponApi;
import com.foxinmy.weixin4j.api.CustomsApi;
import com.foxinmy.weixin4j.api.PayApi;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.XmlResult;
import com.foxinmy.weixin4j.model.Pageable;
import com.foxinmy.weixin4j.model.WeixinPayAccount;
import com.foxinmy.weixin4j.payment.coupon.CouponDetail;
import com.foxinmy.weixin4j.payment.coupon.CouponResult;
import com.foxinmy.weixin4j.payment.coupon.CouponStock;
import com.foxinmy.weixin4j.payment.mch.CorpPayment;
import com.foxinmy.weixin4j.payment.mch.CorpPaymentRecord;
import com.foxinmy.weixin4j.payment.mch.CorpPaymentResult;
import com.foxinmy.weixin4j.payment.mch.CustomsOrder;
import com.foxinmy.weixin4j.payment.mch.CustomsOrderRecord;
import com.foxinmy.weixin4j.payment.mch.CustomsOrderResult;
import com.foxinmy.weixin4j.payment.mch.MchPayPackage;
import com.foxinmy.weixin4j.payment.mch.MchPayRequest;
import com.foxinmy.weixin4j.payment.mch.MerchantResult;
import com.foxinmy.weixin4j.payment.mch.NativePayResponse;
import com.foxinmy.weixin4j.payment.mch.OpenIdResult;
import com.foxinmy.weixin4j.payment.mch.Order;
import com.foxinmy.weixin4j.payment.mch.PrePay;
import com.foxinmy.weixin4j.payment.mch.Redpacket;
import com.foxinmy.weixin4j.payment.mch.RedpacketRecord;
import com.foxinmy.weixin4j.payment.mch.RedpacketSendResult;
import com.foxinmy.weixin4j.payment.mch.RefundRecord;
import com.foxinmy.weixin4j.payment.mch.RefundResult;
import com.foxinmy.weixin4j.payment.mch.SettlementRecord;
import com.foxinmy.weixin4j.type.BillType;
import com.foxinmy.weixin4j.type.CurrencyType;
import com.foxinmy.weixin4j.type.CustomsCity;
import com.foxinmy.weixin4j.type.IdQuery;
import com.foxinmy.weixin4j.type.TradeType;
import com.foxinmy.weixin4j.util.Weixin4jSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class WeixinPayProxy {
    private final PayApi payApi;
    private final CouponApi couponApi;
    private final CashApi cashApi;
    private final CustomsApi customsApi;
    private final Weixin4jSettings settings;
    public static final String VERSION = "1.6.9";

    public WeixinPayProxy() {
        this(new Weixin4jSettings());
    }

    public WeixinPayProxy(Weixin4jSettings settings) {
        this.settings = settings;
        this.payApi = new PayApi(settings.getWeixinPayAccount());
        this.couponApi = new CouponApi(settings.getWeixinPayAccount());
        this.cashApi = new CashApi(settings.getWeixinPayAccount());
        this.customsApi = new CustomsApi(settings.getWeixinPayAccount());
    }

    public WeixinPayAccount getPayAccount() {
        return this.settings.getWeixinPayAccount();
    }

    public PrePay createPrePay(MchPayPackage payPackage) throws WeixinException {
        return this.payApi.createPrePay(payPackage);
    }

    public MchPayRequest createPayRequest(MchPayPackage payPackage) throws WeixinException {
        return this.payApi.createPayRequest(payPackage);
    }

    public MchPayRequest createPayRequest(String body, String detail, String outTradeNo, double totalFee, String notifyUrl, String createIp, TradeType tradeType, String openId, String productId, String attach, Date timeStart, Date timeExpire, String goodsTag, String limitPay, String subOpenId) throws WeixinException {
        return this.payApi.createPayRequest(body, detail, outTradeNo, totalFee, notifyUrl, createIp, tradeType, openId, productId, attach, timeStart, timeExpire, goodsTag, limitPay, subOpenId);
    }

    public MchPayRequest createJSPayRequest(String openId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.payApi.createJSPayRequest(openId, body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public String createAddressRequestJSON(String url, String oauthToken) {
        return this.payApi.createAddressRequestJSON(url, oauthToken);
    }

    public String createNativePayRequestURL(String productId) {
        return this.payApi.createNativePayRequestURL(productId);
    }

    public NativePayResponse createNativePayResponse(String productId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.payApi.createNativePayResponse(productId, body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public MchPayRequest createNativePayRequest(String productId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.payApi.createNativePayRequest(productId, body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public MchPayRequest createAppPayRequest(String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.payApi.createAppPayRequest(body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public MchPayRequest createWAPPayRequest(String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.payApi.createWAPPayRequest(body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public MchPayRequest createMICROPayRequest(String authCode, String body, String outTradeNo, double totalFee, String createIp, String attach) throws WeixinException {
        return this.payApi.createMICROPayRequest(authCode, body, outTradeNo, totalFee, createIp, attach);
    }

    public Order queryOrder(IdQuery idQuery) throws WeixinException {
        return this.payApi.queryOrder(idQuery);
    }

    public RefundResult applyRefund(InputStream certificate, IdQuery idQuery, String outRefundNo, double totalFee, double refundFee, CurrencyType refundFeeType, String opUserId) throws WeixinException {
        return this.payApi.applyRefund(certificate, idQuery, outRefundNo, totalFee, refundFee, refundFeeType, opUserId);
    }

    public RefundResult applyRefund(IdQuery idQuery, String outRefundNo, double totalFee) throws WeixinException, IOException {
        return this.payApi.applyRefund(new FileInputStream(this.settings.getCertificateFile0()), idQuery, outRefundNo, totalFee);
    }

    public RefundRecord queryRefund(IdQuery idQuery) throws WeixinException {
        return this.payApi.queryRefund(idQuery);
    }

    public File downloadBill(Date billDate, BillType billType) throws WeixinException {
        return this.payApi.downloadBill(billDate, billType, this.settings.getTmpdir0());
    }

    public MerchantResult reverseOrder(InputStream certificate, IdQuery idQuery) throws WeixinException {
        return this.payApi.reverseOrder(certificate, idQuery);
    }

    public MerchantResult reverseOrder(IdQuery idQuery) throws WeixinException, IOException {
        return this.payApi.reverseOrder(new FileInputStream(this.settings.getCertificateFile0()), idQuery);
    }

    public MerchantResult closeOrder(String outTradeNo) throws WeixinException {
        return this.payApi.closeOrder(outTradeNo);
    }

    public String getPayShorturl(String url) throws WeixinException {
        return this.payApi.getShorturl(url);
    }

    public XmlResult interfaceReport(String interfaceUrl, int executeTime, String outTradeNo, String ip, Date time, XmlResult returnXml) throws WeixinException {
        return this.payApi.interfaceReport(interfaceUrl, executeTime, outTradeNo, ip, time, returnXml);
    }

    public CouponResult sendCoupon(InputStream certificate, String couponStockId, String partnerTradeNo, String openId, String opUserId) throws WeixinException {
        return this.couponApi.sendCoupon(certificate, couponStockId, partnerTradeNo, openId, opUserId);
    }

    public CouponResult sendCoupon(String couponStockId, String partnerTradeNo, String openId) throws WeixinException, IOException {
        return this.couponApi.sendCoupon(new FileInputStream(this.settings.getCertificateFile0()), couponStockId, partnerTradeNo, openId, null);
    }

    public CouponStock queryCouponStock(String couponStockId) throws WeixinException {
        return this.couponApi.queryCouponStock(couponStockId);
    }

    public CouponDetail queryCouponDetail(String couponId) throws WeixinException {
        return this.couponApi.queryCouponDetail(couponId);
    }

    public RedpacketSendResult sendRedpack(InputStream certificate, Redpacket redpacket) throws WeixinException {
        return this.cashApi.sendRedpack(certificate, redpacket);
    }

    public RedpacketSendResult sendRedpack(Redpacket redpacket) throws WeixinException, IOException {
        return this.cashApi.sendRedpack(new FileInputStream(this.settings.getCertificateFile0()), redpacket);
    }

    public RedpacketRecord queryRedpack(InputStream certificate, String outTradeNo) throws WeixinException {
        return this.cashApi.queryRedpack(certificate, outTradeNo);
    }

    public RedpacketRecord queryRedpack(String outTradeNo) throws WeixinException, IOException {
        return this.cashApi.queryRedpack(new FileInputStream(this.settings.getCertificateFile0()), outTradeNo);
    }

    public CorpPaymentResult sendCorpPayment(InputStream certificate, CorpPayment payment) throws WeixinException {
        return this.cashApi.sendCorpPayment(certificate, payment);
    }

    public CorpPaymentResult sendCorpPayment(CorpPayment payment) throws WeixinException, IOException {
        return this.cashApi.sendCorpPayment(new FileInputStream(this.settings.getCertificateFile0()), payment);
    }

    public CorpPaymentRecord queryCorpPayment(InputStream certificate, String outTradeNo) throws WeixinException {
        return this.cashApi.queryCorpPayment(certificate, outTradeNo);
    }

    public CorpPaymentRecord queryCorpPayment(String outTradeNo) throws WeixinException, IOException {
        return this.cashApi.queryCorpPayment(new FileInputStream(this.settings.getCertificateFile0()), outTradeNo);
    }

    public OpenIdResult authCode2openId(String authCode) throws WeixinException {
        return this.payApi.authCode2openId(authCode);
    }

    public SettlementRecord querySettlement(boolean status, Pageable pageable, Date start, Date end) throws WeixinException {
        return this.cashApi.querySettlement(status, pageable, start, end);
    }

    public double queryExchageRate(CurrencyType currencyType, Date date) throws WeixinException {
        return this.cashApi.queryExchageRate(currencyType, date);
    }

    public CustomsOrderResult declareCustomsOrder(CustomsOrder customsOrder) throws WeixinException {
        return this.customsApi.declareCustomsOrder(customsOrder);
    }

    public CustomsOrderRecord queryCustomsOrder(IdQuery idQuery, CustomsCity customsCity) throws WeixinException {
        return this.customsApi.queryCustomsOrder(idQuery, customsCity);
    }
}

