/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.weixin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpResponse;
import com.foxinmy.weixin4j.http.HttpStatus;
import com.foxinmy.weixin4j.http.weixin.JsonResult;
import com.foxinmy.weixin4j.http.weixin.XmlResult;
import com.foxinmy.weixin4j.util.StringUtil;
import com.foxinmy.weixin4j.xml.XmlStream;
import java.io.InputStream;

public class WeixinResponse {
    private boolean isJsonResult;
    private boolean isXmlResult;
    private volatile String text;
    private final HttpResponse response;

    public WeixinResponse(HttpResponse response) {
        this.response = response;
    }

    public void setJsonResult(boolean isJsonResult) {
        this.isJsonResult = isJsonResult;
    }

    public void setXmlResult(boolean isXmlResult) {
        this.isXmlResult = isXmlResult;
    }

    public String getAsString() {
        if (this.text == null) {
            this.text = StringUtil.newStringUtf8(this.response.getContent());
        }
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public JsonResult getAsJsonResult() {
        return (JsonResult)JSON.parseObject((String)this.getAsString(), JsonResult.class);
    }

    public JSONObject getAsJson() {
        return JSON.parseObject((String)this.getAsString());
    }

    public <T> T getAsObject(TypeReference<T> typeReference) {
        if (this.isJsonResult) {
            return (T)JSON.parseObject((String)this.getAsString(), typeReference, (Feature[])new Feature[0]);
        }
        if (this.isXmlResult) {
            Class clazz = (Class)typeReference.getType();
            return XmlStream.fromXML(this.getAsString(), clazz);
        }
        return null;
    }

    public XmlResult getAsXmlResult() {
        return XmlStream.fromXML(this.getAsString(), XmlResult.class);
    }

    public HttpHeaders getHeaders() {
        return this.response.getHeaders();
    }

    public HttpStatus getStatus() {
        return this.response.getStatus();
    }

    public InputStream getBody() {
        return this.response.getBody();
    }
}

