/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.entity;

import com.foxinmy.weixin4j.http.ContentType;
import com.foxinmy.weixin4j.http.entity.HttpEntity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StringEntity
implements HttpEntity {
    private final byte[] content;
    private final ContentType contentType;

    public StringEntity(String body) {
        this(body, ContentType.DEFAULT_TEXT);
    }

    public StringEntity(String body, ContentType contentType) {
        this.content = body.getBytes(contentType.getCharset());
        this.contentType = contentType;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public long getContentLength() {
        return this.content.length;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        outstream.write(this.content);
        outstream.flush();
    }
}

