/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.sort;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.sort.SearchSort;

public class SearchSortGeoDistance
extends SearchSort {
    private final String field;
    private final double locationLon;
    private final double locationLat;
    private String unit;

    public SearchSortGeoDistance(double locationLon, double locationLat, String field) {
        this.field = field;
        this.locationLon = locationLon;
        this.locationLat = locationLat;
    }

    @Override
    protected String identifier() {
        return "geo_distance";
    }

    @Override
    public SearchSortGeoDistance descending(boolean descending) {
        super.descending(descending);
        return this;
    }

    public SearchSortGeoDistance unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public void injectParams(JsonObject queryJson) {
        super.injectParams(queryJson);
        queryJson.put("location", JsonArray.from(this.locationLon, this.locationLat));
        queryJson.put("field", this.field);
        if (this.unit != null) {
            queryJson.put("unit", this.unit);
        }
    }
}

