/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.core;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigResponse;
import com.couchbase.client.core.message.query.GenericQueryRequest;
import com.couchbase.client.core.message.query.GenericQueryResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.Buffers;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.bucket.api.Utils;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.error.QueryExecutionException;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.query.AsyncN1qlQueryResult;
import com.couchbase.client.java.query.AsyncN1qlQueryRow;
import com.couchbase.client.java.query.DefaultAsyncN1qlQueryResult;
import com.couchbase.client.java.query.DefaultAsyncN1qlQueryRow;
import com.couchbase.client.java.query.DefaultN1qlQueryResult;
import com.couchbase.client.java.query.N1qlMetrics;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.ParameterizedN1qlQuery;
import com.couchbase.client.java.query.PrepareStatement;
import com.couchbase.client.java.query.PreparedN1qlQuery;
import com.couchbase.client.java.query.PreparedPayload;
import com.couchbase.client.java.query.SimpleN1qlQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import com.couchbase.client.java.util.LRUCache;
import com.couchbase.client.java.util.OnSubscribeDeferAndWatch;
import io.opentracing.tag.Tags;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Func7;

@InterfaceStability.Uncommitted
@InterfaceAudience.Private
public class N1qlQueryExecutor {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(N1qlQueryExecutor.class);
    private static final int QUERY_CACHE_SIZE = 5000;
    private static final String ERROR_FIELD_CODE = "code";
    private static final String ERROR_FIELD_MSG = "msg";
    protected static final String ERROR_5000_SPECIFIC_MESSAGE = "queryport.indexNotFound";
    public static final String ENCODED_PLAN_ENABLED_PROPERTY = "com.couchbase.query.encodedPlanEnabled";
    private final ClusterFacade core;
    private final String bucket;
    private final String username;
    private final String password;
    private final Map<String, PreparedPayload> queryCache;
    private final boolean encodedPlanEnabled;
    private static final Func1<AsyncN1qlQueryResult, Observable<AsyncN1qlQueryResult>> QUERY_RESULT_PEEK_FOR_RETRY = new Func1<AsyncN1qlQueryResult, Observable<AsyncN1qlQueryResult>>(){

        public Observable<AsyncN1qlQueryResult> call(final AsyncN1qlQueryResult aqr) {
            if (!aqr.parseSuccess()) {
                final Observable cachedErrors = aqr.errors().cache();
                return cachedErrors.filter((Func1)new Func1<JsonObject, Boolean>(){

                    public Boolean call(JsonObject e) {
                        return N1qlQueryExecutor.shouldRetry(e);
                    }
                }).lastOrDefault(null).flatMap((Func1)new Func1<JsonObject, Observable<AsyncN1qlQueryResult>>(){

                    public Observable<AsyncN1qlQueryResult> call(JsonObject errorJson) {
                        if (errorJson == null) {
                            DefaultAsyncN1qlQueryResult copyResult = new DefaultAsyncN1qlQueryResult(aqr.rows(), aqr.signature(), aqr.info(), (Observable<JsonObject>)cachedErrors, aqr.profileInfo(), aqr.status(), aqr.parseSuccess(), aqr.requestId(), aqr.clientContextId());
                            return Observable.just((Object)copyResult);
                        }
                        return Observable.error((Throwable)((Object)new QueryExecutionException("Error with prepared query", errorJson)));
                    }
                });
            }
            return Observable.just((Object)aqr);
        }
    };
    public static final Func1<? super AsyncN1qlQueryResult, ? extends Observable<? extends N1qlQueryResult>> ASYNC_RESULT_TO_SYNC = new Func1<AsyncN1qlQueryResult, Observable<N1qlQueryResult>>(){

        public Observable<N1qlQueryResult> call(AsyncN1qlQueryResult aqr) {
            final boolean parseSuccess = aqr.parseSuccess();
            final String requestId = aqr.requestId();
            final String clientContextId = aqr.clientContextId();
            return Observable.zip((Observable)aqr.rows().toList(), (Observable)aqr.signature().singleOrDefault((Object)JsonObject.empty()), (Observable)aqr.info().singleOrDefault((Object)N1qlMetrics.EMPTY_METRICS), (Observable)aqr.errors().toList(), (Observable)aqr.profileInfo().singleOrDefault((Object)JsonObject.empty()), aqr.status(), (Observable)aqr.finalSuccess().singleOrDefault((Object)Boolean.FALSE), (Func7)new Func7<List<AsyncN1qlQueryRow>, Object, N1qlMetrics, List<JsonObject>, JsonObject, String, Boolean, N1qlQueryResult>(){

                public N1qlQueryResult call(List<AsyncN1qlQueryRow> rows, Object signature, N1qlMetrics info, List<JsonObject> errors, JsonObject profileInfo, String finalStatus, Boolean finalSuccess) {
                    return new DefaultN1qlQueryResult(rows, signature, info, errors, profileInfo, finalStatus, finalSuccess, parseSuccess, requestId, clientContextId);
                }
            });
        }
    };

    public N1qlQueryExecutor(ClusterFacade core, String bucket, String username, String password) {
        this(core, bucket, username, password, new LRUCache<String, PreparedPayload>(5000), true);
    }

    public N1qlQueryExecutor(ClusterFacade core, String bucket, String password) {
        this(core, bucket, bucket, password, new LRUCache<String, PreparedPayload>(5000), true);
    }

    public N1qlQueryExecutor(ClusterFacade core, String bucket, String password, boolean encodedPlanEnabled) {
        this(core, bucket, bucket, password, new LRUCache<String, PreparedPayload>(5000), encodedPlanEnabled);
    }

    public N1qlQueryExecutor(ClusterFacade core, String bucket, String username, String password, boolean encodedPlanEnabled) {
        this(core, bucket, username, password, new LRUCache<String, PreparedPayload>(5000), encodedPlanEnabled);
    }

    protected N1qlQueryExecutor(ClusterFacade core, String bucket, String username, String password, LRUCache<String, PreparedPayload> lruCache, boolean encodedPlanEnabled) {
        this.core = core;
        this.bucket = bucket;
        this.username = username;
        this.password = password;
        this.encodedPlanEnabled = encodedPlanEnabled;
        this.queryCache = Collections.synchronizedMap(lruCache);
    }

    public Observable<AsyncN1qlQueryResult> execute(N1qlQuery query, CouchbaseEnvironment env, long timeout, TimeUnit timeUnit) {
        if (query.params().isAdhoc()) {
            return this.executeQuery(query, env, timeout, timeUnit);
        }
        return this.dispatchPrepared(query, env, timeout, timeUnit);
    }

    protected Observable<AsyncN1qlQueryResult> executeQuery(final N1qlQuery query, final CouchbaseEnvironment env, final long timeout, final TimeUnit timeUnit) {
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<GenericQueryResponse>>(){

            public Observable<GenericQueryResponse> call(Subscriber subscriber) {
                GenericQueryRequest request = N1qlQueryExecutor.this.createN1qlRequest(query, N1qlQueryExecutor.this.bucket, N1qlQueryExecutor.this.username, N1qlQueryExecutor.this.password, null);
                Utils.addRequestSpan(env, (CouchbaseRequest)request, "n1ql");
                if (env.operationTracingEnabled()) {
                    request.span().setTag(Tags.DB_STATEMENT.getKey(), query.statement().toString());
                }
                request.subscriber(subscriber);
                return Utils.applyTimeout(N1qlQueryExecutor.this.core.send((CouchbaseRequest)request), (CouchbaseRequest)request, env, timeout, timeUnit);
            }
        }).flatMap((Func1)new Func1<GenericQueryResponse, Observable<AsyncN1qlQueryResult>>(){

            public Observable<AsyncN1qlQueryResult> call(GenericQueryResponse response) {
                Observable rows = response.rows().map((Func1)new Func1<ByteBuf, AsyncN1qlQueryRow>(){

                    public AsyncN1qlQueryRow call(ByteBuf byteBuf) {
                        try {
                            byte[] copy = TranscoderUtils.copyByteBufToByteArray(byteBuf);
                            DefaultAsyncN1qlQueryRow defaultAsyncN1qlQueryRow = new DefaultAsyncN1qlQueryRow(copy);
                            return defaultAsyncN1qlQueryRow;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode N1QL Query Row.", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                });
                Observable signature = response.signature().map((Func1)new Func1<ByteBuf, Object>(){

                    public Object call(ByteBuf byteBuf) {
                        try {
                            Object object = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.byteBufJsonValueToObject(byteBuf);
                            return object;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode N1QL Query Signature", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                });
                Observable info = response.info().map((Func1)new Func1<ByteBuf, JsonObject>(){

                    public JsonObject call(ByteBuf byteBuf) {
                        try {
                            JsonObject jsonObject = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                            return jsonObject;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode N1QL Query Info.", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                }).map((Func1)new Func1<JsonObject, N1qlMetrics>(){

                    public N1qlMetrics call(JsonObject jsonObject) {
                        return new N1qlMetrics(jsonObject);
                    }
                });
                Observable finalStatus = response.queryStatus();
                Observable errors = response.errors().map((Func1)new Func1<ByteBuf, JsonObject>(){

                    public JsonObject call(ByteBuf byteBuf) {
                        try {
                            JsonObject jsonObject = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                            return jsonObject;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode View Info.", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                });
                Observable profileInfo = response.profileInfo().map((Func1)new Func1<ByteBuf, JsonObject>(){

                    public JsonObject call(ByteBuf byteBuf) {
                        try {
                            JsonObject jsonObject = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                            return jsonObject;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode profile Info.", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                });
                boolean parseSuccess = response.status().isSuccess();
                String contextId = response.clientRequestId() == null ? "" : response.clientRequestId();
                String requestId = response.requestId();
                DefaultAsyncN1qlQueryResult r = new DefaultAsyncN1qlQueryResult((Observable<AsyncN1qlQueryRow>)rows, (Observable<Object>)signature, (Observable<N1qlMetrics>)info, (Observable<JsonObject>)errors, (Observable<JsonObject>)profileInfo, (Observable<String>)finalStatus, parseSuccess, requestId, contextId);
                return Observable.just((Object)r);
            }
        });
    }

    private static boolean shouldRetry(JsonObject errorJson) {
        if (errorJson == null) {
            return false;
        }
        Integer code = errorJson.getInt(ERROR_FIELD_CODE);
        String msg = errorJson.getString(ERROR_FIELD_MSG);
        if (code == null || msg == null) {
            return false;
        }
        return code == 4050 || code == 4070 || code == 5000 && msg.contains(ERROR_5000_SPECIFIC_MESSAGE);
    }

    protected Observable<AsyncN1qlQueryResult> dispatchPrepared(final N1qlQuery query, final CouchbaseEnvironment env, final long timeout, final TimeUnit timeUnit) {
        PreparedPayload payload = this.queryCache.get(query.statement().toString());
        Func1<Throwable, Observable<AsyncN1qlQueryResult>> retryFunction = new Func1<Throwable, Observable<AsyncN1qlQueryResult>>(){

            public Observable<AsyncN1qlQueryResult> call(Throwable throwable) {
                return N1qlQueryExecutor.this.retryPrepareAndExecuteOnce(throwable, query, env, timeout, timeUnit);
            }
        };
        if (payload != null) {
            return this.executePrepared(query, payload, env, timeout, timeUnit).flatMap(QUERY_RESULT_PEEK_FOR_RETRY).onErrorResumeNext((Func1)retryFunction);
        }
        return this.prepareAndExecute(query, env, timeout, timeUnit).flatMap(QUERY_RESULT_PEEK_FOR_RETRY).onErrorResumeNext((Func1)retryFunction);
    }

    protected Observable<AsyncN1qlQueryResult> retryPrepareAndExecuteOnce(Throwable error, N1qlQuery query, CouchbaseEnvironment env, long timeout, TimeUnit timeUnit) {
        if (error instanceof QueryExecutionException && N1qlQueryExecutor.shouldRetry(((QueryExecutionException)((Object)error)).getN1qlError())) {
            this.queryCache.remove(query.statement().toString());
            return this.prepareAndExecute(query, env, timeout, timeUnit);
        }
        return Observable.error((Throwable)error);
    }

    protected Observable<AsyncN1qlQueryResult> prepareAndExecute(final N1qlQuery query, final CouchbaseEnvironment env, final long timeout, final TimeUnit timeUnit) {
        return this.prepare(query.statement()).flatMap((Func1)new Func1<PreparedPayload, Observable<AsyncN1qlQueryResult>>(){

            public Observable<AsyncN1qlQueryResult> call(PreparedPayload payload) {
                N1qlQueryExecutor.this.queryCache.put(query.statement().toString(), payload);
                return N1qlQueryExecutor.this.executePrepared(query, payload, env, timeout, timeUnit);
            }
        });
    }

    protected Observable<AsyncN1qlQueryResult> executePrepared(N1qlQuery query, PreparedPayload payload, CouchbaseEnvironment env, long timeout, TimeUnit timeUnit) {
        ParameterizedN1qlQuery pq;
        PreparedN1qlQuery preparedQuery = query instanceof ParameterizedN1qlQuery ? ((pq = (ParameterizedN1qlQuery)query).isPositional() ? new PreparedN1qlQuery(payload, (JsonArray)pq.statementParameters(), query.params()) : new PreparedN1qlQuery(payload, (JsonObject)pq.statementParameters(), query.params())) : new PreparedN1qlQuery(payload, query.params());
        preparedQuery.setEncodedPlanEnabled(this.isEncodedPlanEnabled());
        return this.executeQuery(preparedQuery, env, timeout, timeUnit);
    }

    protected Observable<PreparedPayload> prepare(Statement statement) {
        final PrepareStatement prepared = statement instanceof PrepareStatement ? (PrepareStatement)statement : PrepareStatement.prepare(statement);
        final SimpleN1qlQuery query = N1qlQuery.simple(prepared);
        Observable source = this.isEncodedPlanEnabled() ? OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<? extends GenericQueryResponse>>(){

            public Observable<GenericQueryResponse> call(Subscriber subscriber) {
                GenericQueryRequest request = N1qlQueryExecutor.this.createN1qlRequest(query, N1qlQueryExecutor.this.bucket, N1qlQueryExecutor.this.username, N1qlQueryExecutor.this.password, null);
                request.subscriber(subscriber);
                return N1qlQueryExecutor.this.core.send((CouchbaseRequest)request);
            }
        }) : Observable.defer((Func0)new Func0<Observable<GetClusterConfigResponse>>(){

            public Observable<GetClusterConfigResponse> call() {
                return N1qlQueryExecutor.this.core.send((CouchbaseRequest)new GetClusterConfigRequest());
            }
        }).flatMap((Func1)new Func1<GetClusterConfigResponse, Observable<NodeInfo>>(){

            public Observable<NodeInfo> call(GetClusterConfigResponse getClusterConfigResponse) {
                return Observable.from((Iterable)getClusterConfigResponse.config().bucketConfig(N1qlQueryExecutor.this.bucket).nodes());
            }
        }).filter((Func1)new Func1<NodeInfo, Boolean>(){

            public Boolean call(NodeInfo nodeInfo) {
                return nodeInfo.services().containsKey(ServiceType.QUERY) || nodeInfo.sslServices().containsKey(ServiceType.QUERY);
            }
        }).flatMap((Func1)new Func1<NodeInfo, Observable<GenericQueryResponse>>(){

            public Observable<GenericQueryResponse> call(NodeInfo nodeInfo) {
                try {
                    InetAddress hostname = InetAddress.getByName(nodeInfo.hostname().address());
                    final GenericQueryRequest req = N1qlQueryExecutor.this.createN1qlRequest(query, N1qlQueryExecutor.this.bucket, N1qlQueryExecutor.this.username, N1qlQueryExecutor.this.password, hostname);
                    return OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<? extends GenericQueryResponse>>(){

                        public Observable<? extends GenericQueryResponse> call(Subscriber subscriber) {
                            req.subscriber(subscriber);
                            return N1qlQueryExecutor.this.core.send((CouchbaseRequest)req);
                        }
                    });
                }
                catch (UnknownHostException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
        return source.flatMap((Func1)new Func1<GenericQueryResponse, Observable<PreparedPayload>>(){

            public Observable<PreparedPayload> call(GenericQueryResponse r) {
                if (r.status().isSuccess()) {
                    r.info().subscribe(Buffers.BYTE_BUF_RELEASER);
                    r.signature().subscribe(Buffers.BYTE_BUF_RELEASER);
                    r.errors().subscribe(Buffers.BYTE_BUF_RELEASER);
                    r.profileInfo().subscribe(Buffers.BYTE_BUF_RELEASER);
                    return r.rows().map((Func1)new Func1<ByteBuf, PreparedPayload>(){

                        public PreparedPayload call(ByteBuf byteBuf) {
                            try {
                                JsonObject value = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                                PreparedPayload preparedPayload = N1qlQueryExecutor.this.extractPreparedPayloadFromResponse(prepared, value);
                                return preparedPayload;
                            }
                            catch (Exception e) {
                                throw new TranscodingException("Could not decode N1QL Query Plan.", e);
                            }
                            finally {
                                byteBuf.release();
                            }
                        }
                    });
                }
                r.info().subscribe(Buffers.BYTE_BUF_RELEASER);
                r.signature().subscribe(Buffers.BYTE_BUF_RELEASER);
                r.rows().subscribe(Buffers.BYTE_BUF_RELEASER);
                r.profileInfo().subscribe(Buffers.BYTE_BUF_RELEASER);
                return r.errors().map((Func1)new Func1<ByteBuf, Exception>(){

                    public Exception call(ByteBuf byteBuf) {
                        try {
                            JsonObject value = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                            CouchbaseException couchbaseException = new CouchbaseException("N1qlQuery Error - " + value.toString());
                            return couchbaseException;
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode N1QL Query Plan.", e);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }
                }).reduce(new ArrayList(), (Func2)new Func2<ArrayList<Throwable>, Exception, ArrayList<Throwable>>(){

                    public ArrayList<Throwable> call(ArrayList<Throwable> throwables, Exception error) {
                        throwables.add(error);
                        return throwables;
                    }
                }).flatMap((Func1)new Func1<ArrayList<Throwable>, Observable<PreparedPayload>>(){

                    public Observable<PreparedPayload> call(ArrayList<Throwable> errors) {
                        if (errors.size() == 1) {
                            return Observable.error((Throwable)new CouchbaseException("Error while preparing plan", errors.get(0)));
                        }
                        return Observable.error((Throwable)new CompositeException("Multiple errors while preparing plan", errors));
                    }
                });
            }
        }).last();
    }

    private GenericQueryRequest createN1qlRequest(N1qlQuery query, String bucket, String username, String password, InetAddress targetNode) {
        String rawQuery = query.n1ql().toString();
        rawQuery = rawQuery.replaceAll("#CURRENT_BUCKET#", "`" + bucket + "`");
        String statement = query.statement().toString();
        if (targetNode != null) {
            return GenericQueryRequest.jsonQuery((String)rawQuery, (String)bucket, (String)username, (String)password, (InetAddress)targetNode, (String)query.params().clientContextId(), (String)statement);
        }
        return GenericQueryRequest.jsonQuery((String)rawQuery, (String)bucket, (String)username, (String)password, (String)query.params().clientContextId(), (String)statement);
    }

    protected PreparedPayload extractPreparedPayloadFromResponse(PrepareStatement prepared, JsonObject response) {
        return new PreparedPayload(prepared.originalStatement(), response.getString("name"), response.getString("encoded_plan"));
    }

    public int invalidateQueryCache() {
        int oldSize = this.queryCache.size();
        this.queryCache.clear();
        return oldSize;
    }

    public boolean isEncodedPlanEnabled() {
        return this.encodedPlanEnabled;
    }
}

