/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.transport;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.DisconnectableHub;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.messages.WebSocketPacketMessage;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.transport.MainBaseClient;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import java.util.UUID;

public class WebSocketClient
extends MainBaseClient {
    private final Configuration config;

    public WebSocketClient(Channel channel, AckManager ackManager, DisconnectableHub disconnectable, UUID sessionId, Transport transport, StoreFactory storeFactory, HandshakeData handshakeData, Configuration config) {
        super(sessionId, ackManager, disconnectable, transport, storeFactory, handshakeData);
        this.setChannel(channel);
        this.config = config;
    }

    @Override
    public Future send(final Packet packet) {
        if (this.config.isUseStrictOrdering()) {
            return this.getChannel().eventLoop().submit(new Runnable(){

                @Override
                public void run() {
                    WebSocketClient.this.getChannel().writeAndFlush((Object)new WebSocketPacketMessage(WebSocketClient.this.getSessionId(), packet));
                }
            });
        }
        return this.getChannel().writeAndFlush((Object)new WebSocketPacketMessage(this.getSessionId(), packet));
    }
}

