/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.transport;

import com.corundumstudio.socketio.DisconnectableHub;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.parser.PacketType;
import com.corundumstudio.socketio.store.Store;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.transport.NamespaceClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class MainBaseClient {
    private final ConcurrentMap<Namespace, SocketIOClient> namespaceClients = new ConcurrentHashMap<Namespace, SocketIOClient>();
    private final Store store;
    private final AtomicBoolean disconnected = new AtomicBoolean();
    private final DisconnectableHub disconnectableHub;
    private final AckManager ackManager;
    private final UUID sessionId;
    private final Transport transport;
    private Channel channel;
    private final HandshakeData handshakeData;

    public MainBaseClient(UUID sessionId, AckManager ackManager, DisconnectableHub disconnectable, Transport transport, StoreFactory storeFactory, HandshakeData handshakeData) {
        this.sessionId = sessionId;
        this.ackManager = ackManager;
        this.disconnectableHub = disconnectable;
        this.transport = transport;
        this.store = storeFactory.createStore(sessionId);
        this.handshakeData = handshakeData;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public abstract Future send(Packet var1);

    public void removeChildClient(SocketIOClient client) {
        this.namespaceClients.remove((Namespace)client.getNamespace());
        if (this.namespaceClients.isEmpty()) {
            this.disconnectableHub.onDisconnect(this);
        }
    }

    public SocketIOClient getChildClient(Namespace namespace) {
        return (SocketIOClient)this.namespaceClients.get(namespace);
    }

    public SocketIOClient addChildClient(Namespace namespace) {
        NamespaceClient client = new NamespaceClient(this, namespace);
        this.namespaceClients.put(namespace, client);
        return client;
    }

    public Collection<SocketIOClient> getAllChildClients() {
        return this.namespaceClients.values();
    }

    public boolean isConnected() {
        return !this.disconnected.get();
    }

    public void onChannelDisconnect() {
        this.disconnected.set(true);
        for (SocketIOClient client : this.getAllChildClients()) {
            ((NamespaceClient)client).onDisconnect();
        }
    }

    public HandshakeData getHandshakeData() {
        return this.handshakeData;
    }

    public AckManager getAckManager() {
        return this.ackManager;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public SocketAddress getRemoteAddress() {
        return this.channel.remoteAddress();
    }

    public void disconnect() {
        Future future = this.send(new Packet(PacketType.DISCONNECT));
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        this.onChannelDisconnect();
    }

    Channel getChannel() {
        return this.channel;
    }

    void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Store getStore() {
        return this.store;
    }
}

