/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.messages.AuthorizeMessage;
import com.corundumstudio.socketio.messages.BaseMessage;
import com.corundumstudio.socketio.messages.HttpMessage;
import com.corundumstudio.socketio.messages.WebSocketPacketMessage;
import com.corundumstudio.socketio.messages.WebsocketErrorMessage;
import com.corundumstudio.socketio.messages.XHRErrorMessage;
import com.corundumstudio.socketio.messages.XHROutMessage;
import com.corundumstudio.socketio.messages.XHRSendPacketsMessage;
import com.corundumstudio.socketio.parser.Encoder;
import com.corundumstudio.socketio.transport.XHRPollingClient;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.Attribute;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class EncoderHandler
extends ChannelOutboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Encoder encoder;
    private final Configuration configuration;

    public EncoderHandler(Encoder encoder, Configuration configuration) {
        this.encoder = encoder;
        this.configuration = configuration;
    }

    private void write(XHRSendPacketsMessage msg, ChannelHandlerContext ctx, ByteBuf out) throws IOException {
        Channel channel = ctx.channel();
        Attribute attr = channel.attr(XHRPollingClient.WRITE_ONCE);
        if (!channel.isActive() || msg.getPacketQueue().isEmpty() || !attr.compareAndSet(null, (Object)true)) {
            out.release();
            return;
        }
        this.encoder.encodePackets(msg.getPacketQueue(), out, ctx.alloc());
        this.sendMessage(msg, channel, out);
    }

    private void sendMessage(HttpMessage msg, Channel channel, ByteBuf out) {
        HttpResponse res = this.createHttpResponse(msg, out);
        channel.write((Object)res);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Out message: {} - sessionId: {}", (Object)out.toString(CharsetUtil.UTF_8), (Object)msg.getSessionId());
        }
        if (out.isReadable()) {
            channel.write((Object)out);
        } else {
            out.release();
        }
        ChannelFuture f = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private HttpResponse createHttpResponse(HttpMessage msg, ByteBuf message) {
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        if (msg instanceof AuthorizeMessage) {
            AuthorizeMessage am = (AuthorizeMessage)msg;
            if (am.getJsonpParam() != null) {
                HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Content-Type", (Object)"application/javascript");
            } else {
                HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Content-Type", (Object)"text/plain; charset=UTF-8");
            }
        } else {
            HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Content-Type", (Object)"text/plain; charset=UTF-8");
        }
        HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Connection", (Object)"keep-alive");
        if (this.configuration.getOrigin() == null) {
            if (msg.getOrigin() != null) {
                HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Access-Control-Allow-Origin", (Object)msg.getOrigin());
                HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Access-Control-Allow-Credentials", (Object)"true");
            }
        } else {
            HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Access-Control-Allow-Origin", (Object)this.configuration.getOrigin());
        }
        HttpHeaders.setContentLength((io.netty.handler.codec.http.HttpMessage)res, (long)message.readableBytes());
        return res;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof BaseMessage)) {
            super.write(ctx, msg, promise);
            return;
        }
        ByteBuf out = this.encoder.allocateBuffer(ctx.alloc());
        if (msg instanceof AuthorizeMessage) {
            this.handle((AuthorizeMessage)msg, ctx.channel(), out);
        }
        if (msg instanceof XHRSendPacketsMessage) {
            this.write((XHRSendPacketsMessage)msg, ctx, out);
        }
        if (msg instanceof XHROutMessage) {
            this.sendMessage((XHROutMessage)msg, ctx.channel(), out);
        }
        if (msg instanceof XHRErrorMessage) {
            XHRErrorMessage xhrErrorMessage = (XHRErrorMessage)msg;
            this.encoder.encodePacket(xhrErrorMessage.getPacket(), out);
            this.sendMessage(xhrErrorMessage, ctx.channel(), out);
        }
        if (msg instanceof WebSocketPacketMessage) {
            this.handle((WebSocketPacketMessage)msg, ctx.channel(), out);
        }
        if (msg instanceof WebsocketErrorMessage) {
            this.handle((WebsocketErrorMessage)msg, ctx.channel(), out);
        }
    }

    private void handle(AuthorizeMessage authMsg, Channel channel, ByteBuf out) throws IOException {
        String message = authMsg.getMsg();
        if (authMsg.getJsonpParam() != null) {
            this.encoder.encodeJsonP(authMsg.getJsonpParam(), message, out);
        } else {
            out.writeBytes(message.getBytes(CharsetUtil.UTF_8));
        }
        this.sendMessage(authMsg, channel, out);
    }

    private void handle(WebSocketPacketMessage webSocketPacketMessage, Channel channel, ByteBuf out) throws IOException {
        this.encoder.encodePacket(webSocketPacketMessage.getPacket(), out);
        TextWebSocketFrame res = new TextWebSocketFrame(out);
        this.log.trace("Out message: {} sessionId: {}", (Object)out.toString(CharsetUtil.UTF_8), (Object)webSocketPacketMessage.getSessionId());
        if (out.isReadable()) {
            channel.writeAndFlush((Object)res);
        } else {
            out.release();
        }
    }

    private void handle(WebsocketErrorMessage websocketErrorMessage, Channel channel, ByteBuf out) throws IOException {
        this.encoder.encodePacket(websocketErrorMessage.getPacket(), out);
        TextWebSocketFrame frame = new TextWebSocketFrame(out);
        channel.writeAndFlush((Object)frame);
    }
}

