/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.annotation;

import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.annotation.AnnotationScanner;
import com.corundumstudio.socketio.annotation.OnJsonObject;
import com.corundumstudio.socketio.handler.SocketIOException;
import com.corundumstudio.socketio.listener.DataListener;
import com.corundumstudio.socketio.namespace.Namespace;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OnJsonObjectScanner
implements AnnotationScanner {
    @Override
    public Class<? extends Annotation> getScanAnnotation() {
        return OnJsonObject.class;
    }

    @Override
    public void addListener(Namespace namespace, final Object object, final Method method, Annotation annot) {
        final int socketIOClientIndex = this.paramIndex(method, SocketIOClient.class);
        final int ackRequestIndex = this.paramIndex(method, AckRequest.class);
        final int dataIndex = this.dataIndex(method);
        Class<?> objectType = method.getParameterTypes()[dataIndex];
        namespace.addJsonObjectListener(objectType, new DataListener<Object>(){

            @Override
            public void onData(SocketIOClient client, Object data, AckRequest ackSender) {
                try {
                    Object[] args = new Object[method.getParameterTypes().length];
                    if (socketIOClientIndex != -1) {
                        args[socketIOClientIndex] = client;
                    }
                    if (ackRequestIndex != -1) {
                        args[ackRequestIndex] = ackSender;
                    }
                    if (dataIndex != -1) {
                        args[dataIndex] = data;
                    }
                    method.invoke(object, args);
                }
                catch (InvocationTargetException e) {
                    throw new SocketIOException(e.getCause());
                }
                catch (Exception e) {
                    throw new SocketIOException(e);
                }
            }
        });
    }

    private int dataIndex(Method method) {
        int index = 0;
        for (Class<?> type : method.getParameterTypes()) {
            if (!type.equals(AckRequest.class) && !type.equals(SocketIOClient.class)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int paramIndex(Method method, Class clazz) {
        int index = 0;
        for (Class<?> type : method.getParameterTypes()) {
            if (type.equals(clazz)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void validate(Method method, Class clazz) {
        int paramsCount = 3;
        int socketIOClientIndex = this.paramIndex(method, SocketIOClient.class);
        int ackRequestIndex = this.paramIndex(method, AckRequest.class);
        int dataIndex = this.dataIndex(method);
        if (dataIndex == -1) {
            throw new IllegalArgumentException("Wrong OnJsonObject listener signature: " + clazz + "." + method.getName() + " Data parameter is mandatory.");
        }
        if (socketIOClientIndex == -1) {
            --paramsCount;
        }
        if (ackRequestIndex == -1) {
            --paramsCount;
        }
        if (paramsCount != method.getParameterTypes().length) {
            throw new IllegalArgumentException("Wrong OnJsonObject listener signature: " + clazz + "." + method.getName());
        }
    }
}

