/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.DisconnectableHub;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.handler.AuthorizeHandler;
import com.corundumstudio.socketio.handler.EncoderHandler;
import com.corundumstudio.socketio.handler.HeartbeatHandler;
import com.corundumstudio.socketio.handler.PacketHandler;
import com.corundumstudio.socketio.handler.PacketListener;
import com.corundumstudio.socketio.handler.ResourceHandler;
import com.corundumstudio.socketio.handler.WrongUrlHandler;
import com.corundumstudio.socketio.namespace.NamespacesHub;
import com.corundumstudio.socketio.parser.Decoder;
import com.corundumstudio.socketio.parser.Encoder;
import com.corundumstudio.socketio.parser.JsonSupport;
import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.HashedWheelScheduler;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.store.pubsub.DisconnectMessage;
import com.corundumstudio.socketio.transport.FlashPolicyHandler;
import com.corundumstudio.socketio.transport.FlashSocketTransport;
import com.corundumstudio.socketio.transport.MainBaseClient;
import com.corundumstudio.socketio.transport.WebSocketTransport;
import com.corundumstudio.socketio.transport.XHRPollingTransport;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketIOChannelInitializer
extends ChannelInitializer<Channel>
implements DisconnectableHub {
    public static final String SOCKETIO_ENCODER = "socketioEncoder";
    public static final String WEB_SOCKET_TRANSPORT = "webSocketTransport";
    public static final String FLASH_SOCKET_TRANSPORT = "flashSocketTransport";
    public static final String XHR_POLLING_TRANSPORT = "xhrPollingTransport";
    public static final String AUTHORIZE_HANDLER = "authorizeHandler";
    public static final String PACKET_HANDLER = "packetHandler";
    public static final String HTTP_ENCODER = "encoder";
    public static final String HTTP_AGGREGATOR = "aggregator";
    public static final String HTTP_REQUEST_DECODER = "decoder";
    public static final String SSL_HANDLER = "ssl";
    public static final String FLASH_POLICY_HANDLER = "flashPolicyHandler";
    public static final String RESOURCE_HANDLER = "resourceHandler";
    public static final String WRONG_URL_HANDLER = "wrongUrlBlocker";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int protocol = 1;
    private AckManager ackManager;
    private AuthorizeHandler authorizeHandler;
    private XHRPollingTransport xhrPollingTransport;
    private WebSocketTransport webSocketTransport;
    private FlashSocketTransport flashSocketTransport;
    private FlashPolicyHandler flashPolicyHandler;
    private ResourceHandler resourceHandler;
    private EncoderHandler encoderHandler;
    private WrongUrlHandler wrongUrlHandler;
    private CancelableScheduler scheduler = new HashedWheelScheduler();
    private PacketHandler packetHandler;
    private HeartbeatHandler heartbeatHandler;
    private SSLContext sslContext;
    private Configuration configuration;

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.scheduler.update(ctx);
    }

    public void start(Configuration configuration, NamespacesHub namespacesHub) {
        boolean isSsl;
        this.configuration = configuration;
        this.ackManager = new AckManager(this.scheduler);
        JsonSupport jsonSupport = configuration.getJsonSupport();
        Encoder encoder = new Encoder(configuration, jsonSupport);
        Decoder decoder = new Decoder(jsonSupport, this.ackManager);
        this.heartbeatHandler = new HeartbeatHandler(configuration, this.scheduler);
        PacketListener packetListener = new PacketListener(this.heartbeatHandler, this.ackManager, namespacesHub);
        String connectPath = configuration.getContext() + "/" + 1 + "/";
        boolean bl = isSsl = configuration.getKeyStore() != null;
        if (isSsl) {
            try {
                this.sslContext = this.createSSLContext(configuration);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        this.flashPolicyHandler = new FlashPolicyHandler(configuration);
        this.packetHandler = new PacketHandler(packetListener, decoder, namespacesHub, configuration.getExceptionListener());
        this.authorizeHandler = new AuthorizeHandler(connectPath, this.scheduler, configuration, namespacesHub);
        StoreFactory factory = configuration.getStoreFactory();
        factory.init(namespacesHub, this.authorizeHandler, jsonSupport);
        this.xhrPollingTransport = new XHRPollingTransport(connectPath, this.ackManager, this, this.scheduler, this.authorizeHandler, configuration);
        this.webSocketTransport = new WebSocketTransport(connectPath, isSsl, this.ackManager, this, this.authorizeHandler, this.heartbeatHandler, factory, configuration);
        this.flashSocketTransport = new FlashSocketTransport(connectPath, isSsl, this.ackManager, this, this.authorizeHandler, this.heartbeatHandler, factory, configuration);
        this.resourceHandler = new ResourceHandler(configuration.getContext());
        this.encoderHandler = new EncoderHandler(encoder, configuration);
        this.wrongUrlHandler = new WrongUrlHandler();
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        boolean isFlashTransport = this.configuration.getTransports().contains("flashsocket");
        if (isFlashTransport) {
            pipeline.addLast(FLASH_POLICY_HANDLER, (ChannelHandler)this.flashPolicyHandler);
        }
        if (this.sslContext != null) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            pipeline.addLast(SSL_HANDLER, (ChannelHandler)new SslHandler(engine));
        }
        pipeline.addLast(HTTP_REQUEST_DECODER, (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast(HTTP_AGGREGATOR, (ChannelHandler)new HttpObjectAggregator(this.configuration.getMaxHttpContentLength()));
        pipeline.addLast(HTTP_ENCODER, (ChannelHandler)new HttpResponseEncoder());
        if (isFlashTransport) {
            pipeline.addLast(RESOURCE_HANDLER, (ChannelHandler)this.resourceHandler);
        }
        pipeline.addLast(PACKET_HANDLER, (ChannelHandler)this.packetHandler);
        pipeline.addLast(AUTHORIZE_HANDLER, (ChannelHandler)this.authorizeHandler);
        pipeline.addLast(XHR_POLLING_TRANSPORT, (ChannelHandler)this.xhrPollingTransport);
        pipeline.addLast(WEB_SOCKET_TRANSPORT, (ChannelHandler)this.webSocketTransport);
        pipeline.addLast(FLASH_SOCKET_TRANSPORT, (ChannelHandler)this.flashSocketTransport);
        pipeline.addLast(SOCKETIO_ENCODER, (ChannelHandler)this.encoderHandler);
        pipeline.addLast(WRONG_URL_HANDLER, (ChannelHandler)this.wrongUrlHandler);
    }

    private SSLContext createSSLContext(Configuration configuration) throws Exception {
        TrustManager[] managers = null;
        if (configuration.getTrustStore() != null) {
            KeyStore ts = KeyStore.getInstance(configuration.getTrustStoreFormat());
            ts.load(configuration.getTrustStore(), configuration.getTrustStorePassword().toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            managers = tmf.getTrustManagers();
        }
        KeyStore ks = KeyStore.getInstance(configuration.getKeyStoreFormat());
        ks.load(configuration.getKeyStore(), configuration.getKeyStorePassword().toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, configuration.getKeyStorePassword().toCharArray());
        SSLContext serverContext = SSLContext.getInstance("TLS");
        serverContext.init(kmf.getKeyManagers(), managers, null);
        return serverContext;
    }

    @Override
    public void onDisconnect(MainBaseClient client) {
        this.heartbeatHandler.onDisconnect(client);
        this.ackManager.onDisconnect(client);
        this.xhrPollingTransport.onDisconnect(client);
        this.webSocketTransport.onDisconnect(client);
        this.flashSocketTransport.onDisconnect(client);
        this.authorizeHandler.onDisconnect(client);
        this.configuration.getStoreFactory().onDisconnect(client);
        this.configuration.getStoreFactory().pubSubStore().publish("disconnect", new DisconnectMessage(client.getSessionId()));
        this.log.debug("Client with sessionId: {} disconnected", (Object)client.getSessionId());
    }

    public void stop() {
        StoreFactory factory = this.configuration.getStoreFactory();
        factory.shutdown();
        this.scheduler.shutdown();
    }
}

