/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.BroadcastAckCallback;
import com.corundumstudio.socketio.ClientOperations;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.misc.IterableCollection;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.parser.PacketType;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.store.pubsub.DispatchMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BroadcastOperations
implements ClientOperations {
    private final Iterable<SocketIOClient> clients;
    private final Map<String, List<String>> namespaceRooms = new HashMap<String, List<String>>();
    private final StoreFactory storeFactory;

    public BroadcastOperations(Iterable<SocketIOClient> clients, StoreFactory storeFactory) {
        this.clients = clients;
        for (SocketIOClient socketIOClient : clients) {
            Namespace namespace = (Namespace)socketIOClient.getNamespace();
            Set<String> rooms = namespace.getRooms(socketIOClient);
            List<String> roomsList = this.namespaceRooms.get(namespace.getName());
            if (roomsList == null) {
                roomsList = new ArrayList<String>();
                this.namespaceRooms.put(namespace.getName(), roomsList);
            }
            roomsList.addAll(rooms);
        }
        this.storeFactory = storeFactory;
    }

    private void dispatch(Packet packet) {
        for (Map.Entry<String, List<String>> entry : this.namespaceRooms.entrySet()) {
            for (String room : entry.getValue()) {
                this.storeFactory.pubSubStore().publish("dispatch", new DispatchMessage(room, packet, entry.getKey()));
            }
        }
    }

    public Collection<SocketIOClient> getClients() {
        return new IterableCollection<SocketIOClient>(this.clients);
    }

    @Override
    public void sendMessage(String message) {
        Packet packet = new Packet(PacketType.MESSAGE);
        packet.setData(message);
        this.send(packet);
    }

    public <T> void sendMessage(String message, BroadcastAckCallback<T> ackCallback) {
        for (SocketIOClient client : this.clients) {
            client.sendMessage(message, ackCallback.createClientCallback(client));
        }
        ackCallback.loopFinished();
    }

    @Override
    public void sendJsonObject(Object object) {
        Packet packet = new Packet(PacketType.JSON);
        packet.setData(object);
        this.send(packet);
    }

    public <T> void sendJsonObject(Object object, BroadcastAckCallback<T> ackCallback) {
        for (SocketIOClient client : this.clients) {
            client.sendJsonObject(object, ackCallback.createClientCallback(client));
        }
        ackCallback.loopFinished();
    }

    @Override
    public void send(Packet packet) {
        for (SocketIOClient client : this.clients) {
            client.send(packet);
        }
        this.dispatch(packet);
    }

    public <T> void send(Packet packet, BroadcastAckCallback<T> ackCallback) {
        for (SocketIOClient client : this.clients) {
            client.send(packet, ackCallback.createClientCallback(client));
        }
        ackCallback.loopFinished();
    }

    @Override
    public void disconnect() {
        for (SocketIOClient client : this.clients) {
            client.disconnect();
        }
    }

    @Override
    public void sendEvent(String name, Object ... data) {
        Packet packet = new Packet(PacketType.EVENT);
        packet.setName(name);
        packet.setArgs(Arrays.asList(data));
        this.send(packet);
    }

    public <T> void sendEvent(String name, Object data, BroadcastAckCallback<T> ackCallback) {
        for (SocketIOClient client : this.clients) {
            client.sendEvent(name, data, ackCallback.createClientCallback(client));
        }
        ackCallback.loopFinished();
    }
}

