/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.Coercion;
import com.aoindustries.encoding.MediaException;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.io.Writable;
import com.aoindustries.servlet.jsp.LocalizedJspTagException;
import com.aoindustries.taglib.ApplicationResources;
import com.aoindustries.taglib.AttributeRequiredException;
import com.aoindustries.taglib.AutoEncodingNullTag;
import com.aoindustries.taglib.NameAttribute;
import com.aoindustries.taglib.PropertyUtils;
import com.aoindustries.taglib.TypeAttribute;
import com.aoindustries.util.i18n.BundleLookupMarkup;
import com.aoindustries.util.i18n.BundleLookupThreadContext;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class WriteTag
extends AutoEncodingNullTag
implements NameAttribute,
TypeAttribute {
    private String scope;
    private Object name;
    private String property;
    private String method = "toString";
    private MediaType mediaType = MediaType.TEXT;
    private String toStringResult;
    private BundleLookupMarkup lookupMarkup;
    private Object value;

    @Override
    public MediaType getOutputType() {
        return this.mediaType;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public void setName(Object name) {
        this.name = name;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public void setType(Object type) throws JspTagException {
        MediaType newMediaType;
        if (type instanceof MediaType) {
            newMediaType = (MediaType)type;
        } else {
            String typeStr = Coercion.toString((Object)type);
            newMediaType = MediaType.getMediaTypeByName((String)typeStr);
            if (newMediaType == null) {
                try {
                    newMediaType = MediaType.getMediaTypeForContentType((String)typeStr);
                }
                catch (MediaException e) {
                    throw new JspTagException((Throwable)e);
                }
            }
        }
        this.mediaType = newMediaType;
    }

    @Override
    protected void writePrefix(MediaType containerType, Writer out) throws JspTagException, IOException {
        block14: {
            try {
                if (this.name == null) {
                    throw new AttributeRequiredException("name");
                }
                Object bean = PropertyUtils.findObject((PageContext)this.getJspContext(), this.scope, Coercion.toString((Object)this.name), this.property, true, false);
                if (bean == null) break block14;
                if ("toString".equals(this.method)) {
                    if (bean instanceof Writable && !((Writable)bean).isFastToString()) {
                        this.value = bean;
                    } else {
                        this.toStringResult = Coercion.toString((Object)bean);
                    }
                } else {
                    try {
                        Method refMethod = bean.getClass().getMethod(this.method, new Class[0]);
                        Object retVal = refMethod.invoke(bean, new Object[0]);
                        if (retVal instanceof Writable && !((Writable)retVal).isFastToString()) {
                            this.value = retVal;
                        } else {
                            this.toStringResult = Coercion.toString((Object)retVal);
                        }
                    }
                    catch (NoSuchMethodException err) {
                        throw new LocalizedJspTagException(ApplicationResources.accessor, "WriteTag.unableToFindMethod", new Serializable[]{this.method});
                    }
                }
                if (this.toStringResult != null) {
                    BundleLookupThreadContext threadContext = BundleLookupThreadContext.getThreadContext((boolean)false);
                    this.lookupMarkup = threadContext != null ? threadContext.getLookupMarkup(this.toStringResult) : null;
                    if (this.lookupMarkup != null) {
                        this.lookupMarkup.appendPrefixTo(containerType.getMarkupType(), (Appendable)out);
                    }
                }
            }
            catch (IllegalAccessException err) {
                throw new JspTagException((Throwable)err);
            }
            catch (InvocationTargetException err) {
                throw new JspTagException((Throwable)err);
            }
        }
    }

    @Override
    protected void doTag(Writer out) throws JspTagException, IOException {
        if (this.toStringResult != null) {
            out.write(this.toStringResult);
        } else if (this.value != null) {
            Coercion.write((Object)this.value, (Writer)out);
        }
    }

    @Override
    protected void writeSuffix(MediaType containerType, Writer out) throws IOException {
        if (this.lookupMarkup != null) {
            this.lookupMarkup.appendSuffixTo(containerType.getMarkupType(), (Appendable)out);
        }
    }
}

