/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.Coercion;
import com.aoindustries.encoding.MediaException;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.taglib.Scope;
import com.aoindustries.util.MinimalList;
import java.util.List;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.ValidationMessage;

public final class TeiUtils {
    private TeiUtils() {
    }

    public static List<ValidationMessage> validateMediaType(TagData data, List<ValidationMessage> messages) {
        Object o = data.getAttribute("type");
        if (o != null && o != TagData.REQUEST_TIME_VALUE && !(o instanceof MediaType)) {
            String type = Coercion.toString((Object)o);
            try {
                MediaType mediaType = MediaType.getMediaTypeByName((String)type);
                if (mediaType == null) {
                    mediaType = MediaType.getMediaTypeForContentType((String)type);
                }
            }
            catch (MediaException err) {
                messages = MinimalList.add(messages, (Object)new ValidationMessage(data.getId(), err.getMessage()));
            }
        }
        return messages;
    }

    public static List<ValidationMessage> validateScope(TagData data, List<ValidationMessage> messages) {
        Object o = data.getAttribute("scope");
        if (o != null && o != TagData.REQUEST_TIME_VALUE) {
            String scope = Coercion.toString((Object)o);
            try {
                Scope.getScopeId(scope);
            }
            catch (JspTagException err) {
                messages = MinimalList.add(messages, (Object)new ValidationMessage(data.getId(), err.getMessage()));
            }
        }
        return messages;
    }
}

