/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.Coercion;
import com.aoindustries.encoding.MediaException;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.TextInXhtmlAttributeEncoder;
import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.net.HttpParameters;
import com.aoindustries.net.HttpParametersMap;
import com.aoindustries.servlet.http.LastModifiedServlet;
import com.aoindustries.servlet.jsp.LocalizedJspTagException;
import com.aoindustries.taglib.ApplicationResources;
import com.aoindustries.taglib.AutoEncodingBufferedTag;
import com.aoindustries.taglib.MarkupUtils;
import com.aoindustries.taglib.ParamUtils;
import com.aoindustries.taglib.ParamsAttribute;
import com.aoindustries.taglib.SrcAttribute;
import com.aoindustries.taglib.TypeAttribute;
import com.aoindustries.taglib.UrlUtils;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.DynamicAttributes;

public class ScriptTag
extends AutoEncodingBufferedTag
implements DynamicAttributes,
TypeAttribute,
SrcAttribute,
ParamsAttribute {
    private MediaType mediaType = MediaType.JAVASCRIPT;
    private String src;
    private HttpParametersMap params;
    private boolean srcAbsolute;
    private LastModifiedServlet.AddLastModifiedWhen addLastModified = LastModifiedServlet.AddLastModifiedWhen.AUTO;

    @Override
    public MediaType getContentType() {
        return this.mediaType;
    }

    @Override
    public MediaType getOutputType() {
        return this.src != null ? MediaType.XHTML : this.mediaType;
    }

    @Override
    public void setType(Object type) throws JspTagException {
        try {
            MediaType newMediaType;
            MediaType mediaType = newMediaType = type instanceof MediaType ? (MediaType)type : MediaType.getMediaTypeForContentType((String)Coercion.toString((Object)type));
            if (newMediaType != MediaType.JAVASCRIPT && newMediaType != MediaType.JSON && newMediaType != MediaType.LD_JSON) {
                throw new MediaException(ApplicationResources.accessor.getMessage("ScriptTag.unsupportedMediaType", new Object[]{newMediaType}));
            }
            this.mediaType = newMediaType;
        }
        catch (MediaException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    @Override
    public void setSrc(String src) {
        this.src = src;
    }

    @Override
    public void addParam(String name, String value) {
        if (this.params == null) {
            this.params = new HttpParametersMap();
        }
        this.params.addParameter(name, value);
    }

    public void setSrcAbsolute(boolean srcAbsolute) {
        this.srcAbsolute = srcAbsolute;
    }

    public void setAddLastModified(String addLastModified) {
        this.addLastModified = LastModifiedServlet.AddLastModifiedWhen.valueOfLowerName((String)addLastModified);
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspTagException {
        if (uri != null || !localName.startsWith("param.")) {
            throw new LocalizedJspTagException(ApplicationResources.accessor, "error.unexpectedDynamicAttribute", new Serializable[]{localName, "param.*"});
        }
        ParamUtils.setDynamicAttribute(this, uri, localName, value);
    }

    @Override
    protected void doTag(BufferResult capturedBody, Writer out) throws JspTagException, IOException {
        if (this.src == null) {
            MarkupUtils.writeWithMarkup(capturedBody, this.mediaType.getMarkupType(), out);
        } else {
            out.write("<script type=\"");
            TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)this.mediaType.getContentType(), (Appendable)out);
            out.write(34);
            UrlUtils.writeSrc(this.getJspContext(), (Appendable)out, this.src, (HttpParameters)this.params, this.srcAbsolute, this.addLastModified);
            out.write("></script>");
        }
    }
}

