/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.net.HttpParameters;
import com.aoindustries.net.HttpParametersUtils;
import com.aoindustries.servlet.http.Includer;
import com.aoindustries.servlet.http.LastModifiedServlet;
import com.aoindustries.servlet.http.ServletUtil;
import com.aoindustries.servlet.jsp.LocalizedJspTagException;
import com.aoindustries.taglib.ApplicationResources;
import com.aoindustries.taglib.AttributeRequiredException;
import com.aoindustries.taglib.DispatchTag;
import com.aoindustries.taglib.HrefAttribute;
import com.aoindustries.util.WildcardPatternMatcher;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;

public class RedirectTag
extends DispatchTag
implements HrefAttribute {
    private static final Logger logger = Logger.getLogger(RedirectTag.class.getName());
    private static final int MAXIMUM_GET_REQUEST_LENGTH = 2048;
    private String statusCode;
    private String href;
    private LastModifiedServlet.AddLastModifiedWhen addLastModified = LastModifiedServlet.AddLastModifiedWhen.AUTO;

    public static boolean isValidStatusCode(String statusCode) {
        return "moved_permanently".equals(statusCode) || "permanent".equals(statusCode) || "301".equals(statusCode) || "moved_temporarily".equals(statusCode) || "found".equals(statusCode) || "temporary".equals(statusCode) || "302".equals(statusCode) || "see_other".equals(statusCode) || "303".equals(statusCode);
    }

    public void setStatusCode(String statusCode) throws JspTagException {
        if (!RedirectTag.isValidStatusCode(statusCode)) {
            throw new LocalizedJspTagException(ApplicationResources.accessor, "RedirectTag.statusCode.invalid", new Serializable[]{statusCode});
        }
        this.statusCode = statusCode;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public void setAddLastModified(String addLastModified) {
        this.addLastModified = LastModifiedServlet.AddLastModifiedWhen.valueOfLowerName((String)addLastModified);
    }

    @Override
    protected WildcardPatternMatcher getClearParamsMatcher() {
        return WildcardPatternMatcher.matchAll();
    }

    @Override
    protected String getDynamicAttributeExceptionKey() {
        return "error.unexpectedDynamicAttribute";
    }

    @Override
    protected Serializable[] getDynamicAttributeExceptionArgs(String localName) {
        return new Serializable[]{localName, "param.*"};
    }

    @Override
    protected Map<String, ?> getArgs() {
        return null;
    }

    @Override
    protected void doTag(String servletPath) throws IOException, JspTagException, SkipPageException {
        boolean isTooLong;
        int status;
        if (this.statusCode == null) {
            throw new AttributeRequiredException("statusCode");
        }
        if ("301".equals(this.statusCode) || "moved_permanently".equals(this.statusCode) || "permanent".equals(this.statusCode)) {
            status = 301;
        } else if ("302".equals(this.statusCode) || "moved_temporarily".equals(this.statusCode) || "found".equals(this.statusCode) || "temporary".equals(this.statusCode)) {
            status = 302;
        } else if ("303".equals(this.statusCode) || "see_other".equals(this.statusCode)) {
            status = 303;
        } else {
            throw new AssertionError((Object)("Unexpected value for statusCode: " + this.statusCode));
        }
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletContext servletContext = pageContext.getServletContext();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        String responseEncoding = response.getCharacterEncoding();
        String myHref = this.href;
        if (myHref == null) {
            myHref = this.page;
        }
        if (myHref == null) {
            throw new AttributeRequiredException("href");
        }
        myHref = HttpParametersUtils.addParams((String)myHref, (HttpParameters)this.params, (String)responseEncoding);
        String location = ServletUtil.getRedirectLocation((HttpServletRequest)request, (HttpServletResponse)response, (String)servletPath, (String)(myHref = LastModifiedServlet.addLastModified((ServletContext)servletContext, (HttpServletRequest)request, (String)servletPath, (String)myHref, (LastModifiedServlet.AddLastModifiedWhen)this.addLastModified)));
        boolean bl = isTooLong = location.length() > 2048;
        if (!isTooLong || this.page == null) {
            if (isTooLong && logger.isLoggable(Level.WARNING)) {
                logger.warning(ApplicationResources.accessor.getMessage("RedirectTag.locationTooLongWarning", new Object[]{2048, location.length(), location.substring(0, 100)}));
            }
            Includer.setLocation((HttpServletRequest)request, (HttpServletResponse)response, (String)location);
            Includer.sendError((HttpServletRequest)request, (HttpServletResponse)response, (int)status);
            Includer.setPageSkipped((ServletRequest)request);
            throw new SkipPageException();
        }
        if (status == 302 || status == 303) {
            response.setHeader("Cache-Control", "no-cache");
        }
    }

    @Override
    void dispatch(RequestDispatcher dispatcher, JspWriter out, HttpServletRequest request, HttpServletResponse response) throws JspException, IOException {
        boolean oldForwarded = RedirectTag.isForwarded((ServletRequest)request);
        try {
            RedirectTag.setForwarded((ServletRequest)request, true);
            try {
                out.clear();
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException e) {
                throw new JspTagException((Throwable)e);
            }
            Includer.setPageSkipped((ServletRequest)request);
            throw new SkipPageException();
        }
        catch (Throwable throwable) {
            RedirectTag.setForwarded((ServletRequest)request, oldForwarded);
            throw throwable;
        }
    }
}

