/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.servlet.jsp.LocalizedJspTagException;
import com.aoindustries.taglib.ApplicationResources;
import com.aoindustries.taglib.AttributeRequiredException;
import com.aoindustries.taglib.Scope;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static void setAttribute(PageContext pageContext, String scope, String name, Object value) throws JspTagException {
        pageContext.setAttribute(name, value, Scope.getScopeId(scope));
    }

    public static Object findObject(PageContext pageContext, String scope, String name, String property, boolean beanRequired, boolean valueRequired) throws JspTagException {
        try {
            if (name == null) {
                throw new AttributeRequiredException("name");
            }
            Object bean = scope == null ? pageContext.findAttribute(name) : pageContext.getAttribute(name, Scope.getScopeId(scope));
            if (bean == null) {
                if (beanRequired) {
                    if (scope == null) {
                        throw new LocalizedJspTagException(ApplicationResources.accessor, "PropertyUtils.bean.required.nullScope", new Serializable[]{name});
                    }
                    throw new LocalizedJspTagException(ApplicationResources.accessor, "PropertyUtils.bean.required.scope", new Serializable[]{name, scope});
                }
                return null;
            }
            if (property == null) {
                return bean;
            }
            Object value = org.apache.commons.beanutils.PropertyUtils.getProperty((Object)bean, (String)property);
            if (valueRequired && value == null) {
                if (scope == null) {
                    throw new LocalizedJspTagException(ApplicationResources.accessor, "PropertyUtils.value.required.nullScope", new Serializable[]{property, name});
                }
                throw new LocalizedJspTagException(ApplicationResources.accessor, "PropertyUtils.value.required.scope", new Serializable[]{property, name, scope});
            }
            return value;
        }
        catch (IllegalAccessException err) {
            throw new JspTagException((Throwable)err);
        }
        catch (InvocationTargetException err) {
            throw new JspTagException((Throwable)err);
        }
        catch (NoSuchMethodException err) {
            throw new JspTagException((Throwable)err);
        }
    }
}

